<?php
/**
*
*
*    Custom Product Tabs
*    Copyright 2015  Inno-mods.io
*
*    @author    Inno-mods.io
*    @copyright Inno-mods.io
*    @version   1.2.0
*    Visit us at http://www.inno-mods.io
*
*
**/

/*
* check presta
*/
if (!defined('_PS_VERSION_')) {
    exit;
}
/*
* require our models
*/
require_once _PS_MODULE_DIR_.'customproducttabs/models/CustomProductTabs.php';
require_once _PS_MODULE_DIR_.'customproducttabs/models/CustomProductTabsContent.php';

/*
* Customproducttabs Module
*/
class Customproducttabs extends Module
{
    public function __construct()
    {
        $this->name = 'customproducttabs';
        $this->tab = 'front_office_features';
        $this->version = '1.2.0';
        $this->author = 'Inno-mods.io';
        $this->ps_versions_compliancy = array('min' => '1.5.4.0', 'max' => _PS_VERSION_ );
        $this->bootstrap = true;

        parent::__construct(); //needed for translations

        $this->displayName = $this->l('Custom Product Tabs');
        $this->description = $this->l('Custom Product Tabs is a plugin for adding extra custom product tabs in your shop products!! ');
        $this->confirmUninstall = $this->l('Are you sure you want to uninstall '.$this->displayName.'?');
    }

    /*
    * install
    */
    public function install()
    {
        if (Shop::isFeatureActive()) { //  check whether the multistore feature is active or not, and if at least two stores are presently activated
            Shop::setContext(Shop::CONTEXT_ALL); // change the context in order  to apply coming changes to all existing stores instead of only the current store
        }

        if (!parent::install() || // install
            !CustomProductTabsModel::createSchema() || // create database ( tabs tables )
            !CustomProductTabsContentModel::createSchema() || // create database ( content tables )
            !$this->registerHook('displayHeader') || // register front office header hook
            !$this->registerHook('displayBackOfficeHeader') || // register admin header hook
            !$this->registerHook('displayAdminProductsExtra') || // register admin product extra hook
            !$this->registerHook('actionProductUpdate') || // register admin product update hook
            !$this->registerHook('displayProductTab') || // register product tab hook
            !$this->registerHook('displayProductTabContent') || // register product tab content hook
            !$this->registerHook('displayProductExtraContent') ) { // register product extra tab content hook (v.1.7)
            return false;
        }

        return true;
    }

    /*
    * uninstall
    */
    public function uninstall()
    {
        // uninstall and drop module's database tables, if something fails, return false
        if (!parent::uninstall() || // uninstall
            !CustomProductTabsModel::DropSchema() || // drop database ( tabs tables )
            !CustomProductTabsContentModel::DropSchema()) { // drop database ( content tables )
            return false;
        }

        // return
        return true;
    }

    /*
    * getContent - actually it works like a module index page                                                                          
    */
    public function getContent()
    {
        $output = null;

        // get controller
        $controller = Tools::getValue('moduleController');

        // baseAdminModuleUrl
        $baseAdminModuleUrl = AdminController::$currentIndex.'&token='.Tools::getAdminTokenLite('AdminModules').'&configure='.$this->name.'&tab_module='.$this->tab.'&module_name='.$this->name.'';
        /*
        * case of saving 1.6 configuration options
        */
        if (Tools::isSubmit('ConfigurationFormSubmit')) {
 
            // save configuration
            Configuration::updateValue('CUSTOMPRODUCTSTABS_FORCE_TABS', Tools::getValue('force_tabs'), false, null, $this->context->shop->id);

            // redirect to options page with a success message
            Tools::redirectAdmin($baseAdminModuleUrl.'&moduleController=options&success=yes');
        }

        /*
        * case of saving a tab
        */
        if (Tools::isSubmit('TabFormSubmit')) {
            // get languages
            $langs = $this->getLanguagesList();

            /*
            * update case
            */
            if ((int)Tools::getValue('tab_id')) {
                // get tab by id
                $tab = new CustomProductTabsModel((int)Tools::getValue('tab_id'));

                // if name is blank ( in even one of the available languages ), redirect with error
                foreach ($langs as $lang) {
                    if (Tools::getValue('name_'.$lang['id_lang']) == '') {
                        //Tools::redirectAdmin($baseAdminModuleUrl.'&moduleController=tabForm&block_id='.$tab->id.'&error=emptyName');
                    }
                }

                // if current shop is not the same with the tab's, then redirect
                if ($this->context->shop->id != $tab->id_store) {
                    // redirect , otherwise.. because employee is not allowed to edit this shop
                    Tools::redirectAdmin($baseAdminModuleUrl.'&moduleController=tabs');
                    die;
                }

                // assign status
                $tab->status = (int)Tools::getValue('status');

                // assign all_categories
                $tab->all_categories = (int)Tools::getValue('all_categories');

                // assign all_manufacturers
                $tab->all_manufacturers = (int)Tools::getValue('all_manufacturers');

                $name = array();
                $default_content = array();
                // foreach shop language prepare respective data
                foreach ($langs as $lang) {
                    $name[$lang['id_lang']] = Tools::getValue('name_'.$lang['id_lang']);
                    $default_content[$lang['id_lang']] = Tools::getValue('default_content_'.$lang['id_lang']);
                }
                // assign multilanguage data
                $tab->name        = $name;
                $tab->default_content  = $default_content;

                // save tab
                $tab->save();


            /*
            * insert case
            */
            } else {
                // create new tab
                $tab = new CustomProductTabsModel();

                // if name is blank ( in even one of the available languages ), redirect with error
                foreach ($langs as $lang) {
                    if (Tools::getValue('name_'.$lang['id_lang']) == '') {
                        //Tools::redirectAdmin($baseAdminModuleUrl.'&moduleController=tabForm&error=emptyName');
                    }
                }

                // get shop list ids
                $shopListIds = $this->getShopsListIds();
                // assign shop only if it user has access on it
                if (in_array($this->context->shop->id, $shopListIds)) {
                    // assign
                    $tab->id_store = $this->context->shop->id;
                } else {
                    // redirect , otherwise.. because employee is not allowed to edit this shop
                    Tools::redirectAdmin($baseAdminModuleUrl.'&moduleController=tabs');
                    die;
                }

                // assign status
                $tab->status = (int)Tools::getValue('status');

                // assign all_categories
                $tab->all_categories = (int)Tools::getValue('all_categories');

                // assign all_manufacturers
                $tab->all_manufacturers = (int)Tools::getValue('all_manufacturers');
                
                $name = array();
                $default_content = array();
                // foreach shop language prepare respective data
                foreach ($langs as $lang) {
                    $name[$lang['id_lang']] = Tools::getValue('name_'.$lang['id_lang']);
                    $default_content[$lang['id_lang']] = Tools::getValue('default_content_'.$lang['id_lang']);
                }
                // assign multilanguage data
                $tab->name        = $name;
                $tab->default_content  = $default_content;

                // assign position
                $tab->position = CustomProductTabsModel::getHighestTabPosition($this->context->shop->id) + 1;
                // save tab
                $tab->save();

            }

            /*
            * treat input in category tree
            */
            CustomProductTabsModel::clearAllowedCategories($tab->id);
            // get posted data
            $allowedCategories = Tools::getValue('categories');
            // foreach selected category
            foreach ($allowedCategories as $key => $allowedCategory) {
                // save to database
                CustomProductTabsModel::relToCategory($tab->id, $allowedCategory);
            }

            /*
            * treat input in manufacturers list
            */
            CustomProductTabsModel::clearAllowedManufacturers($tab->id);
            // get available manufacturers
            $availableManufacturers = Manufacturer::getManufacturers();
            // foreach checked box, add an entry
            foreach ($availableManufacturers as $availableManufacturer) {
                if (Tools::getValue('manufacturers_'.$availableManufacturer['id_manufacturer']) == 'on') {
                    // save to database
                    CustomProductTabsModel::relToManufacturer($tab->id, $availableManufacturer['id_manufacturer']);
                }
            }

            // redirect
            Tools::redirectAdmin($baseAdminModuleUrl.'&moduleController=tabForm&tab_id='.$tab->id.'&msg=success');

        } // tab save end

        /*
        *
        * list display
        *
        */
        if ($controller == 'tabs' || $controller == '') {
            // create and display List
            $output = $this->displayTabsList();

        /*
        *
        * tabForm display 
        *
        */
        } elseif ($controller == 'tabForm') {
            // if context is in group or all shops mode, then redirect to single shop mode ( we need this to restrict categories in categorie tree )
            if (Shop::getContext()!=Shop::CONTEXT_SHOP) {
                Tools::redirectAdmin($baseAdminModuleUrl.'&moduleController=tabForm&tab_id='.Tools::getValue('tab_id').'&setContextShop=s-'.$this->context->shop->id.'&setShopContext=s-'.$this->context->shop->id);
                die;
            }
        
            // check if employee is allowed to edit this entry
            // get posted tab id
            $tabID = (int)Tools::getValue('tab_id');
            // if in edit mode ( id given )
            if ($tabID != '') {
                // get tab
                $tab = new CustomProductTabsModel((int)$tabID);
                // get shop list ids
                $shopListIds = $this->getShopsListIds();
                // if user has no access on the shop of the block, or current shop is different than entry shop, redirect him
                if (!in_array($tab->id_store, $shopListIds) || $this->context->shop->id != $tab->id_store) {
                    // redirect , otherwise.. because employee is not allowed to edit this shop
                    Tools::redirectAdmin($baseAdminModuleUrl.'&moduleController=tabs');
                    die;
                }
            }

            // create and display blockForm ( via FormHelper )
            $output = $this->displayTabForm();

        /*
        *
        * ajaxOrder 
        *
        */
        } elseif ($controller == 'ajaxOrder') {
            // get shop list ids
            $shopListIds = $this->getShopsListIds();

            // get hook and order
            $order = explode(',', Tools::getValue('order'));

            // save order of blocks for a specific hook
            foreach ($order as $position => $tab_id) {
                // get tab
                $tab = new CustomProductTabsModel((int)$tab_id);
                // edit shop only if it user has access on it
                if (in_array($tab->id_store, $shopListIds)) {
                    // set position of a specific hook_id - block id
                    CustomProductTabsModel::setTabPosition((int)$tab_id, $position + 1);
                } else {
                    // redirect , otherwise.. because employee is not allowed to edit this shop
                    Tools::redirectAdmin($baseAdminModuleUrl.'&moduleController=tabs');
                    die;
                }
            }

            // die
            die;
            // return null
            return;

        /*
        *
        * delete Tab 
        *
        */
        } elseif ($controller == 'deleteTab') {
            // get tab id
            $tabID = (int)Tools::getValue('tab_id');

            // check if employee is allowed to edit this tab
            // get block
            $tab = new CustomProductTabsModel($tabID);
            // get shop list ids
            $shopListIds = $this->getShopsListIds();
            // edit shop only if it user has access on it
            if (in_array($tab->id_store, $shopListIds)) {
                // delete specific tab id
                CustomProductTabsModel::deleteTab($tabID);

                // redirect to list page
                Tools::redirectAdmin($baseAdminModuleUrl.'&moduleController=tabs');
                die;
            } else {
                // redirect , otherwise.. because employee is not allowed to edit this shop
                Tools::redirectAdmin($baseAdminModuleUrl.'&moduleController=tabs');
                die;
            }
        /*
        *
        * options page
        *
        */
        } elseif ($controller == 'options') {
            // get options page
            $output = $this->optionsPage();
        }

        return $this->getHeader().$output.$this->getFooter();
    }

    /*
    * getHeader in admin
    */
    public function getHeader()
    {
        // get controller
        $controller = Tools::getValue('moduleController');
        // check if store should be displayed
        if ($controller != 'generalOptions') {
            $displayCurrentStore = true;
        } else {
            $displayCurrentStore = false;
        }

        // assign to smarty
        $this->smarty->assign(array(
                                    'shop'                => $this->context->shop->id,
                                    'storeName'           => $this->context->shop->name ,
                                    'logoSrc'             => _PS_BASE_URL_.$this->_path.'/views/img/logo-white.png',
                                    'psVersion'           => $this->psVersion(),
                                    'displayCurrentStore' => $displayCurrentStore,
                                    'uri'                 => AdminController::$currentIndex.'&token='.Tools::getAdminTokenLite('AdminModules').'&configure='.$this->name.'&tab_module='.$this->tab.'&module_name='.$this->name.''
                                    ));
        // return
        return $this->display(__FILE__, '/views/templates/admin/header.tpl');
    }

    /*
    * getFooter in Admin
    */
    public function getFooter()
    {
        $this->smarty->assign(array(
                                    'moduleVersion'       => $this->version ,
                                    ));
        return $this->display(__FILE__, '/views/templates/admin/footer.tpl');
    }

    /*
    * displayTabsList in Admin
    */
    public function displayTabsList()
    {
        $this->smarty->assign(array(
                                    'shop'   => $this->context->shop->id,
                                    'uri'    => AdminController::$currentIndex.'&token='.Tools::getAdminTokenLite('AdminModules').'&configure='.$this->name.'&tab_module='.$this->tab.'&module_name='.$this->name.'',
                                    'tabs'   => CustomProductTabsModel::getShopTabs($this->context->shop->id, $this->context->language->id)
                                    ));
        return $this->display(__FILE__, '/views/templates/admin/tabsList.tpl');
    }

    /*
    * optionsPage in Admin
    */
    public function optionsPage()
    {
        /*
        * options ( info actually ) for version 1.5
        */
        if ($this->psVersion() == '1.5') {
            $this->smarty->assign(array(
                                        'shop'   => $this->context->shop->id,
                                        'shopName'   => $this->context->shop->name,
                                        'psVersion'  => $this->psVersion(),
                                        'psVersionAccurate'  => _PS_VERSION_,
                                        'uri'    => AdminController::$currentIndex.'&token='.Tools::getAdminTokenLite('AdminModules').'&configure='.$this->name.'&tab_module='.$this->tab.'&module_name='.$this->name.'',
                                        ));
            return $this->display(__FILE__, '/views/templates/admin/options.1.5.tpl');

        /*
        * options for version 1.6
        */
        } elseif ($this->psVersion() == '1.6') {

            // set success flag
            $success = false;
            if (Tools::getValue('success') == 'yes') {
                $success = true;
            }

            $this->smarty->assign(array(
                                        'token'                 => Tools::getAdminTokenLite('AdminModules'),
                                        'forceTabs'             => Configuration::get('CUSTOMPRODUCTSTABS_FORCE_TABS'),
                                        'success'              => $success
                                        ));
            return $this->display(__FILE__, '/views/templates/admin/options.1.6.tpl');
        }
    }

    /*
    * displayTabForm
    */
    public function displayTabForm()
    {
        // Get default Language
        $default_lang = (int)Configuration::get('PS_LANG_DEFAULT');

        // Get tab id
        $tabID = Tools::getValue('tab_id');


        // select switch type according to version
        if ($this->psVersion() == '1.5') {
            $switchType = 'switch_1.5';
        } else {
            $switchType = 'switch';
        }


        // Init Fields form array
        $fields_form = array();
        $fields_form[0]['form'] = array(
            'legend' => array(
                'title' => $this->l('Tab Settings'),
                'icon' => 'icon-cogs'
            ),
            'input' => array(

                array(
                    'type'     => 'hidden',
                    'name'     => 'TabFormSubmit',
                ),
                array(
                    'type'     => 'hidden',
                    'name'     => 'tab_id',
                ),
                array(
                    'type' =>  $switchType,
                    'label' => $this->l('Active'),
                    'name' => 'status',
                    'class'     => 't',
                    'is_bool'   => true,
                    'values' => array(
                                    array(
                                        'id' => 'active_on',
                                        'value' => 1,
                                        'label' => $this->l('Enabled')
                                    ),
                                    array(
                                        'id' => 'active_off',
                                        'value' => 0,
                                        'label' => $this->l('Disabled')
                                    )
                    ),
                    'desc'     => $this->l('Activate / Deactivate the Tab.'),
                ),
                array(
                    'type'     => 'text',
                    'label'    => $this->l('Name of the tab'),
                    'name'     => 'name',
                    'desc'     => $this->l('Required for all available languages'),
                    'lang'     => true
                ),
                array(
                    'type'     => 'textarea',
                    'label'    => $this->l('Tab Default Content'),
                    'name'     => 'default_content',
                    'desc'    => $this->l('Leave empty if not needed'),
                    'rows'     => 10,
                    'cols'     => 100,
                    'autoload_rte' => true,
                    'lang'     => true
                ),
                array(
                    'type' =>  $switchType,
                    'label' => $this->l('Allowed for all manufacturers'),
                    'name' => 'all_manufacturers',
                    'class'     => 't',
                    'is_bool'   => true,
                    'values' => array(
                                    array(
                                        'id' => 'active_on',
                                        'value' => 1,
                                        'label' => $this->l('Enabled')
                                    ),
                                    array(
                                        'id' => 'active_off',
                                        'value' => 0,
                                        'label' => $this->l('Disabled')
                                    )
                    ),
                    'desc'     => $this->l('If set to active ignore the following manufacturers list'),
                ),
                array(
                    'type' => 'checkbox',
                    'label' => $this->l('Allowed Manufacturers'),
                    'name' => 'manufacturers',
                    'class' => 't',
                    'multiple' => true,
                    'values' => array(
                                        'query' => Manufacturer::getManufacturers(),
                                        'id'    => 'id_manufacturer',
                                        'name'  => 'name'
                                    )
                ),
            ),
            'submit' => array(
                'title' => $this->l('Save'),
                'class' => 'button'
            )
        );

        // categories filter is not available in 1.5, actually it is always turned to on..
        if ($this->psVersion() == '1.5') {
            $fields_form[0]['form']['input'][] = array(
                                                    'type' =>  'hidden',
                                                    'name' => 'all_categories',
                                                    'is_bool'   => true ,
                                                    'value'     => 1
                                                );
        } else {
            $fields_form[0]['form']['input'][] = array(
                                                    'type' =>  $switchType,
                                                    'label' => $this->l('Allowed for all categories'),
                                                    'name' => 'all_categories',
                                                    'class'     => 't',
                                                    'is_bool'   => true,
                                                    'values' => array(
                                                                    array(
                                                                        'id' => 'active_on',
                                                                        'value' => 1,
                                                                        'label' => $this->l('Enabled')
                                                                    ),
                                                                    array(
                                                                        'id' => 'active_off',
                                                                        'value' => 0,
                                                                        'label' => $this->l('Disabled')
                                                                    )
                                                    ),
                                                    'desc'     => $this->l('If set to active ignore the following category tree'),
                                                );

            $fields_form[0]['form']['input'][] = array(
                                                   'type'  => 'categories',
                                                   'label' => $this->l('Allowed for categories'),
                                                   'name'  => 'categories',
                                                   'tree'  => array(
                                                                 'id' => 'allowed_for_categories',
                                                                 'use_checkbox'        => true,
                                                                 'selected_categories' => CustomProductTabsModel::getTabCategories($tabID)
                                                              ),
                                                   );
        }
        
        $helper = new HelperForm();
        
        // Module, token and currentIndex
        $helper->module = $this;
        $helper->name_controller = $this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->currentIndex = AdminController::$currentIndex.'&configure='.$this->name;
        
        // Language
        $helper->default_form_language = $default_lang;
        $helper->allow_employee_form_lang = $default_lang;
        

        // Toolbar
        $helper->show_toolbar = false;        // false -> remove toolbar
        $helper->toolbar_scroll = false;      // yes - > Toolbar is always visible on the top of the screen.
        $helper->submit_action = 'submit'.$this->name;
        $helper->toolbar_btn = array(
                                    'save' => array(
                                                    'desc' => $this->l('Save'),
                                                    'href' => AdminController::$currentIndex.'&configure='.$this->name.'&save'.$this->name.
                                                    '&token='.Tools::getAdminTokenLite('AdminModules'),
                                                ),
                                    'back' => array(
                                        'href' => AdminController::$currentIndex.'&token='.Tools::getAdminTokenLite('AdminModules').'&configure='.$this->name.'&tab_module='.$this->tab.'&module_name='.$this->name.'',
                                        'desc' => $this->l('Back to list')
                                    )
                                );
        // get tab info
        if ($tabID != '') {
            $block = $this->getTabSettings($tabID);
        // or set default field values
        } else {
            $block = $this->getDefaultSettings();
        }

        $helper->tpl_vars = array(
            'fields_value' =>  $block ,
            'languages' => $this->getLanguagesList(),
            'id_language' => $this->context->language->id,
        );

        /*
        * extend wysiwyg editor
        * well, tinymce has different configurations for each prestashop version, so we should check the version and load respective configuration
        */

        // Title
        if ($tabID != '') {
            $title = $this->l('Edit Tab');
        } else {
            $title = $this->l('Add Tab');
        }

        // treat errors, if they exist
        $errorsHtml = '';
        if (Tools::getValue('error') == 'emptyName') {
            $errorsHtml = $this->displayError($this->l('Please fill the tab name in all available languages. It is required!'));
        }

        return '<div class="customproducttabs-titles">'.$title.'</div>'.$errorsHtml.$helper->generateForm($fields_form);
    }

    /*
    * get default values
    */
    public function getDefaultSettings()
    {
        $settings = array(
            'TabFormSubmit'               => true,
            'tab_id'                      => '',
            'id_store'                    => $this->context->shop->id,
            'status'                      => '0',
            'name'                        => null,
            'default_content'             => null,
            'all_manufacturers'           => null
        );

        if ($this->psVersion() == '1.5') {
            $settings['all_categories'] = 1;
        } else {
            $settings['all_categories'] = null;
        }

        return $settings;
    }


    /*
    * get tab values
    */
    public function getTabSettings($tabID)
    {
        // get tab
        $tab = new CustomProductTabsModel($tabID);

        // assign values
        $settings = array(
            'TabFormSubmit'               => true,
            'tab_id'                      => $tab->tab_id,
            'id_store'                    => $tab->id_store,
            'status'                      => $tab->status,
            'name'                        => $tab->name,
            'default_content'             => $tab->default_content,
            'all_manufacturers'           => $tab->all_manufacturers,
        );


        if ($this->psVersion() == '1.5') {
            $settings['all_categories'] = 1;
        } else {
            $settings['all_categories'] = $tab->all_categories;
        }

        // get manufacturers selection
        $manufacturers = CustomProductTabsModel::getTabManufacturers($tabID);
        // assign checkbox selection
        foreach ($manufacturers as $manufacturer) {
            $settings['manufacturers_'.$manufacturer['id_manufacturer']] = 'on';
        }

        // return
        return $settings;
    }

    /*
    * getLanguagesList
    */
    public function getLanguagesList()
    {
        $languages_list = array();
        $langs = Language::getLanguages(true, $this->context->shop->id);

        foreach ($langs as $lang) {
            if ($lang['id_lang'] == $this->context->language->id) {
                $isDefault = 1;
            } else {
                $isDefault = 0;
            }
            
            $languages_list[] = array(
                                        'id_lang' => $lang['id_lang'],
                                        'name' => $lang['name'],
                                        'is_default' => $isDefault,
                                        'iso_code' => $lang['iso_code'],
                                    );
        }
    
        return $languages_list;
    }

    /*
    * getShopsList
    */
    private function getShopsList()
    {
        $shops_list = array();
        $shops = Shop::getShops();
        foreach ($shops as $shop) {
            $shops_list[] = array( 'id_shop' => $shop['id_shop'], 'name' => $shop['name']);
        }

        // return shops
        return $shops_list;
    }

    /*
    * getShopsListIds
    */
    private function getShopsListIds()
    {
        $shops_list = array();
        $shops = Shop::getShops();
        foreach ($shops as $shop) {
            $shops_list[] = $shop['id_shop'];
        }

        // return shop ids
        return $shops_list;
    }

    /*
    * psVersion
    */
    public function psVersion()
    {
        $version = _PS_VERSION_;
        $exp = explode('.', $version);
        return $exp[0].'.'.$exp[1];
    }


    /*
    * minorVersion
    */
    public static function minorVersion()
    {
        $version = _PS_VERSION_;
        $exp = explode('.', $version);
        return $exp[2];
    }

    /*
    * patchVersion
    */
    public static function patchVersion()
    {
        $version = _PS_VERSION_;
        $exp = explode('.', $version);
        return $exp[3];
    }

    /*
    * back office includes
    */
    public function hookDisplayBackOfficeHeader($params)
    {
        $this->context->controller->addJquery();
        $this->context->controller->addJqueryUI('ui.sortable');
        if ($this->psVersion() == '1.5') {
            $this->context->controller->addCSS($this->_path.'/views/css/customproducttabs-backend-1.5.css', 'all');
            $this->context->controller->addCSS($this->_path.'/views/css/font-awesome.css', 'all');
        } else if ($this->psVersion() == '1.6') {
            $this->context->controller->addCSS($this->_path.'/views/css/customproducttabs-backend-1.6.css', 'all');
        } else if ($this->psVersion() == '1.7') {
            $this->context->controller->addCSS($this->_path.'/views/css/customproducttabs-backend-1.7.css', 'all');
        }
    }


    /*
    * front office includes
    */
    public function hookDisplayHeader()
    {
        if (isset($this->context->controller->php_self) && $this->context->controller->php_self == 'product') {
            $this->context->controller->addJquery();
            $this->context->controller->addJqueryUI('ui.tabs');
            $this->context->controller->addCSS($this->_path.'/views/css/customproducttabs.css', 'all');
            // add responsive media
            $this->context->controller->addJS($this->_path.'/views/js/responsiveMedia-1.7.js', 'all');
        }
    }

    /*
    * admin product extra hook 
    */
    public function hookDisplayAdminProductsExtra($params)
    {
        if ($this->psVersion() == '1.7') {
            $productID = $params['id_product'];
        } else {
            $productID = (int)Tools::getValue('id_product');
        }    
        // if product already exists
        if ((int)$productID) {
            // if product has loaded correctly
            if (Validate::isLoadedObject($product = new Product((int)$productID))) {
                // check for additional tabs for current product
                $productTabsInfo = CustomProductTabsModel::getProductTabs($product->id, $this->context->language->id);

                // if tabs found
                if ($productTabsInfo) {
                    // get shop list ids
                    $shopListIds = $this->getShopsListIds();

                    // initialize a temp array
                    $productTab = array();
                    // initialize a stack array
                    $productTabs = array();
                    // foreach tab get content
                    foreach ($productTabsInfo as $productTabInfo) {
                        // show tab only if it user has access on the respective store
                        if (in_array($productTabInfo['id_store'], $shopListIds)) {
                            // assign tab data to temp array
                            $productTab['id'] = $productTabInfo['tab_id'] ;
                            $productTab['shop'] = $productTabInfo['id_store'] ;
                            $shopInfo = Shop::getShop((int)$productTabInfo['id_store']);
                            $productTab['shop_name'] = $shopInfo['name'] ;
                            $productTab['position'] = $productTabInfo['position'] ;
                            $productTab['name'] = $productTabInfo['name'] ;
                            $productTab['all_categories'] = $productTabInfo['all_categories'] ;
                            $productTab['all_manufacturers'] = $productTabInfo['all_manufacturers'] ;
                            // get content of the tab for this product
                            $TabContent = CustomProductTabsContentModel::getProductTabsContent($productTabInfo['tab_id'], $product->id);
                            if ($TabContent) {
                                // assign tab content data to temp array
                                $productTab['content_id'] = $TabContent['content_id'] ;
                                $productTab['content_status'] = $TabContent['status'] ;
                                $productTab['content'] = $TabContent['content'] ;
                            } else {
                                // assign empty tab content data to temp array
                                $productTab['content_id'] = '' ;
                                $productTab['content_status'] = '1' ;
                                $productTab['content'] = '' ;
                            }
                            // assign to stack
                            $productTabs[] = $productTab;
                        }
                    }

                    // if tabs available add to smarty and return template
                    if ($productTabs) {
                        // check 1.6 tinymce load method
                        if ($this->psVersion() == '1.6' AND $this->minorVersion() <= 1 AND $this->patchVersion() <= 8 ){
                            $editorLoad = 'oldWay';    
                        } else {
                            $editorLoad = 'newWay';
                        }
                        // assign to smarty
                        $this->smarty->assign(array(
                                                    'shop'   => $this->context->shop->id,
                                                    'uri'    => AdminController::$currentIndex.'&token='.Tools::getAdminTokenLite('AdminModules').'&configure='.$this->name.'&tab_module='.$this->tab.'&module_name='.$this->name.'',
                                                    'languages' => $this->getLanguagesList(),
                                                    'id_language' => $this->context->language->id,
                                                    'iso'    => $this->context->language->iso_code,
                                                    'ad'     => dirname($_SERVER["PHP_SELF"]),
                                                    'allowEmployeeFormLang' => $this->context->language->id,
                                                    'tabs'   => $productTabs,
                                                    'editorLoad' => $editorLoad
                                                    ));

                        if ($this->psVersion() == '1.5') {
                            // return
                            return $this->display(__FILE__, '/views/templates/admin/productAdditionalTabs.1.5.tpl');
                        } else if ($this->psVersion() == '1.6') {
                            // return
                            return $this->display(__FILE__, '/views/templates/admin/productAdditionalTabs-1.6.tpl');
                        } else if ($this->psVersion() == '1.7') {
                            // return
                            return $this->display(__FILE__, '/views/templates/admin/productAdditionalTabs-1.7.tpl');
                        }

                    } else {
                        // return nothing
                        return '&nbsp;';
                    }
                } else {
                    // return nothing
                    return '&nbsp;';
                }
            }
        } else {
            return '<div class="alert alert-warning">'.$this->l('You must save the product before managing your custom tabs!').'</div>';
        }
    }

    /*
    * admin product update hook
    */
    public function hookActionProductUpdate($params)
    {
        // get languages
        $langs = $this->getLanguagesList();

        // get product id
        if ($this->psVersion() == '1.7') {
            $product_id = (int)$params['id_product'];
        } else {
            $product_id = (int)Tools::getValue('id_product');
        }            
        
        // get submitted tabs ( get the ids )
        $availableTabs = Tools::getValue('customproducttabs');

        // foreach submitted tab
        if (is_array($availableTabs)){
            foreach ($availableTabs as $key => $tabID) {
                $content_id = (int)Tools::getValue('tab_'.$tabID.'_content_id');
                $status = (int)Tools::getValue('tab_'.$tabID.'_status');
                /*
                * update case
                */
                if ($content_id) {
                    // get tab content by id
                    $tabContent = new CustomProductTabsContentModel($content_id);

                    // assign tab id
                    $tabContent->tab_id = $tabID;
                    // assign status
                    $tabContent->status = $status;
                    // assign product id
                    $tabContent->product_id = $product_id;

                    $content = array();
                    // foreach shop language prepare respective data
                    foreach ($langs as $lang) {
                        $content[$lang['id_lang']] = Tools::getValue('tab_'.$tabID.'_customtabcontent_'.$lang['id_lang']);
                    }
                    
                    // assign multilanguage data
                    $tabContent->content  = $content;

                    // save tab content
                    $tabContent->save();


                /*
                * insert case
                */
                } else {
                    // create new tab content
                    $tabContent = new CustomProductTabsContentModel();

                    // assign tab id
                    $tabContent->tab_id = $tabID;
                    // assign status
                    $tabContent->status = $status;
                    // assign product id
                    $tabContent->product_id = $product_id;
                    
                    $content = array();
                    // foreach shop language prepare respective data
                    foreach ($langs as $lang) {
                        $content[$lang['id_lang']] = Tools::getValue('tab_'.$tabID.'_customtabcontent_'.$lang['id_lang']);
                    }

                    // assign multilanguage data
                    $tabContent->content  = $content;

                    // save tab content
                    $tabContent->save();
                }
            } // end foreach submitted tab
        }
    }


    /*
    * hook product tab
    */
    public function hookDisplayProductTab($params)
    {

        // assign to smarty
        $this->smarty->assign(array(
                                    'additionalTabs'                => $this->getProductActiveAdditionalTabs((int)Tools::getvalue('id_product')),
                                    'psVersion'                     => $this->psVersion(),
                                    'forceTabs'                     => Configuration::get('CUSTOMPRODUCTSTABS_FORCE_TABS'),
                                    'isMobile'                      => $this->context->getMobileDevice()
                                    ));
        // return template
        return $this->display(__FILE__, '/views/templates/front/tabTitle.tpl');
    }


    /*
    * hook product tab content
    */
    public function hookDisplayProductTabContent($params)
    {
        // assign to smarty
        $this->smarty->assign(array(
                                    'additionalTabs'                => $this->getProductActiveAdditionalTabs((int)Tools::getvalue('id_product')),
                                    'psVersion'                     => $this->psVersion(),
                                    'isMobile'                      => $this->context->getMobileDevice(),
                                    'forceTabs'                     => Configuration::get('CUSTOMPRODUCTSTABS_FORCE_TABS'),
                                    ));
        // return template
        return $this->display(__FILE__, '/views/templates/front/tabContent.tpl');
    }

    /*
    * product extra content hook (v.1.7)
    */
    public function hookDisplayProductExtraContent($params)
    {
        $array = array();
        
        $additionalTabs= $this->getProductActiveAdditionalTabs((int)Tools::getvalue('id_product'));
        
        foreach($additionalTabs as $additionalTab) {
            if ($additionalTab['content']!=''){
                $array[] = (new PrestaShop\PrestaShop\Core\Product\ProductExtraContent())
                        ->setTitle($additionalTab['name'])
                        ->setContent($additionalTab['content']);
            }
        }

        return $array;
    }

    /*
    * getProductActiveAdditionalTabs
    */
    public function getProductActiveAdditionalTabs($id_product)
    {

        // initialize a stack array
        $additionalTabs = array();

        // get active tabs for current shop-product
        $activeShopTabs = CustomProductTabsModel::getShopActiveProductTabs((int)$id_product, $this->context->shop->id, $this->context->language->id);

        // if tabs available, check if we have active content
        foreach ($activeShopTabs as $activeShopTab) {

            // init $TabContent
            $TabContent = array();
            // get content for this tab - shop - lang
            $TabContent = CustomProductTabsContentModel::getTabContent((int)$id_product, $activeShopTab['tab_id'], $this->context->language->id);


            $temp = array();
                
            
            // if tab content exists
            if ($TabContent) {
                // if tab content exists and status is set to active, assign content
                if ($TabContent['status'] == 1) {

                    // if real content exists..
                    if ($TabContent['content'] != '') {
                        // assign tab id
                        $temp['tab_id'] = $activeShopTab['tab_id'];
                        // assign name
                        $temp['name'] = $activeShopTab['name'];
                        // assign content
                        $temp['content'] = $TabContent['content'];
                        // add to result
                        $additionalTabs[] = $temp;

                    // assign default one
                    } else {
                        // assign tab id
                        $temp['tab_id'] = $activeShopTab['tab_id'];
                        // assign name
                        $temp['name'] = $activeShopTab['name'];
                        // assign content
                        $temp['content'] = $activeShopTab['default_content'];
                        // add to result
                        $additionalTabs[] = $temp;
                    }


                // if tab content exists but is set to inactive, keep inactive
                } elseif ($TabContent['status'] == 0) {
                    // do nothing actually...
                }

            } else {
                // if default content exists, display it..
                if ($activeShopTab['default_content']!='') {
                    // assign tab id
                    $temp['tab_id'] = $activeShopTab['tab_id'];
                    // assign name
                    $temp['name'] = $activeShopTab['name'];
                    // assign content
                    $temp['content'] = $activeShopTab['default_content'];
                    // add to result
                    $additionalTabs[] = $temp;
                }
            }
        }
        // return
        return $additionalTabs;
    }
}