<?php
/**
*
*
*    Custom Product Tabs
*    Copyright 2015  Inno-mods.io
*
*    @author    Inno-mods.io
*    @copyright Inno-mods.io
*    @version   1.1.0
*    Visit us at http://www.inno-mods.io
*
*
**/

class CustomProductTabsModel extends ObjectModel
{

    /*
    * definition
    */
    public $tab_id;
    public $name;
    public $status;
    public $id_store;
    public $default_content;
    public $position;
    public $all_categories;
    public $all_manufacturers;

    public static $definition = array(
                                        'table' => 'customproducttabs',
                                        'primary' => 'tab_id',
                                        'multishop' => true,
                                        'multilang' => true,
                                        'fields' => array(
                                                            'id_store' => array(
                                                                            'type' => self::TYPE_INT,
                                                                            'validate' => 'isUnsignedInt',
                                                                            'required' => true
                                                                        ),
                                                            'status' => array(
                                                                            'type' => self::TYPE_INT,
                                                                            'validate' => 'isUnsignedInt',
                                                                            'required' => true
                                                                        ),
                                                            'name' => array(
                                                                        'type' => self::TYPE_HTML,
                                                                        'lang' => true,
                                                                        'validate' => 'isString',
                                                                        'required' => true
                                                                        ),
                                                            'default_content' => array(
                                                                                'type' => self::TYPE_HTML,
                                                                                'lang' => true,
                                                                                'size' => 3999999999999
                                                                            ),
                                                            'position' => array(
                                                                            'type' => self::TYPE_INT,
                                                                            'validate' => 'isUnsignedInt',
                                                                            'required' => true
                                                                        ),
                                                            'all_categories' => array(
                                                                            'type' => self::TYPE_INT,
                                                                            'validate' => 'isUnsignedInt',
                                                                            'required' => true
                                                                        ),
                                                            'all_manufacturers' => array(
                                                                            'type' => self::TYPE_INT,
                                                                            'validate' => 'isUnsignedInt',
                                                                            'required' => true
                                                                        ),
                                                        ),
                                    );


    /*
    * createSchema for current Model
    */
    public static function createSchema()
    {
        //main table for the files
        return ( CustomProductTabsModel::createCustomProductTabsTable() && CustomProductTabsModel::createCustomProductTabsLanguageTable() && CustomProductTabsModel::createCustomProductTabsCategoriesTable() && CustomProductTabsModel::createCustomProductTabsManufacturersTable() );
    }




    /*
    * dropSchema for current Model
    */
    public static function dropSchema()
    {
        $sql = 'DROP TABLE IF EXISTS `'._DB_PREFIX_.self::$definition['table'].'`,
                                     `'._DB_PREFIX_.self::$definition['table'].'_lang`,
                                     `'._DB_PREFIX_.self::$definition['table'].'_categories`,
                                     `'._DB_PREFIX_.self::$definition['table'].'_manufacturers`';
        $result = Db::getInstance()->execute($sql);
        return $result;
    }




    /*
    * createCustomProductTabsTable
    */
    public static function createCustomProductTabsTable()
    {
        $sql = 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.self::$definition['table'].'`(
                `tab_id` int(10) unsigned NOT NULL auto_increment,
                `id_store` int(10) unsigned NOT NULL default \'1\',
                `status` int(10) unsigned NOT NULL,
                `position` int(10) unsigned NOT NULL,
                `all_categories` int(10) unsigned NOT NULL,
                `all_manufacturers` int(10) unsigned NOT NULL,
                PRIMARY KEY (`tab_id`)
                ) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=utf8';

        return Db::getInstance()->execute($sql);
    }


    /*
    * createCustomProductTabsLanguageTable
    */
    public static function createCustomProductTabsLanguageTable()
    {
        $sql = 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.self::$definition['table'].'_lang` (
                      `tab_id` int(10) unsigned NOT NULL,
                      `id_lang` int(10) unsigned NOT NULL,
                      `name` text NOT NULL,
                      `default_content` text NOT NULL,
                      PRIMARY KEY (`tab_id`,`id_lang`)
                    ) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=utf8';

        return Db::getInstance()->execute($sql);
    }


    /*
    * createCustomProductTabsCategoriesTable
    */
    public static function createCustomProductTabsCategoriesTable()
    {
        $sql = 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.self::$definition['table'].'_categories`(
                `tab_id` int(10) unsigned NOT NULL,
                `id_category` int(10) unsigned NOT NULL,
                PRIMARY KEY (`tab_id`,`id_category`)
                ) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=utf8';

        return Db::getInstance()->execute($sql);
    }


    /*
    * createCustomProductTabsManufacturersTable
    */
    public static function createCustomProductTabsManufacturersTable()
    {
        $sql = 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.self::$definition['table'].'_manufacturers`(
                `tab_id` int(10) unsigned NOT NULL,
                `id_manufacturer` int(10) unsigned NOT NULL,
                PRIMARY KEY (`tab_id`,`id_manufacturer`)
                ) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=utf8';

        return Db::getInstance()->execute($sql);
    }


    /*
    * getHighestTabPosition
    */
    public static function getHighestTabPosition($shop)
    {
        $sql = 'SELECT `position` FROM `'._DB_PREFIX_.self::$definition['table'].'`
                WHERE `id_store` = "'.(int)$shop.'" ORDER BY `position` DESC LIMIT 1';
        $res = Db::getInstance()->ExecuteS($sql);
        if ($res) {
            $row = $res[0];
            return $row['position'];
        } else {
            return 0;
        }
    }



    /*
    * getShopTabs
    */
    public static function getShopTabs($shop, $lang)
    {
        $sql = 'SELECT * FROM `'._DB_PREFIX_.self::$definition['table'].'` as `t`
                INNER JOIN `'._DB_PREFIX_.self::$definition['table'].'_lang` as `l` ON `t`.`tab_id` = `l`.`tab_id` 
                WHERE `t`.`id_store` = "'.(int)$shop.'" AND `l`.`id_lang`="'.(int)$lang.'" ORDER BY `t`.`position` ASC ';
        return Db::getInstance()->ExecuteS($sql);
    }



    /*
    * setTabPosition
    */
    public static function setTabPosition($tab_id, $position)
    {
        $sql = 'UPDATE `'._DB_PREFIX_.self::$definition['table'].'`  
                SET `position`= "'.(int)$position.'" 
                WHERE `tab_id` = "'.(int)$tab_id.'" ';
        return Db::getInstance()->Execute($sql);
    }


    /*
    * clearAllowedCategories
    */
    public static function clearAllowedCategories($tab_id)
    {
        $sql = 'DELETE FROM `'._DB_PREFIX_.self::$definition['table'].'_categories` WHERE `tab_id` = "'.(int)$tab_id.'" ';
        return Db::getInstance()->Execute($sql);
    }


    /*
    * clearAllowedManufacturers
    */
    public static function clearAllowedManufacturers($tab_id)
    {
        $sql = 'DELETE FROM `'._DB_PREFIX_.self::$definition['table'].'_manufacturers` WHERE `tab_id` = "'.(int)$tab_id.'" ';
        return Db::getInstance()->Execute($sql);
    }


    /*
    * relToCategory
    */
    public static function relToCategory($tab_id, $category_id)
    {
        $sql = 'INSERT INTO `'._DB_PREFIX_.self::$definition['table'].'_categories` ( `tab_id` , `id_category` ) VALUES ( "'.(int)$tab_id.'" , "'.(int)$category_id.'")  ';
        return Db::getInstance()->Execute($sql);
    }


    /*
    * relToManufacturer
    */
    public static function relToManufacturer($tab_id, $manufacturer_id)
    {
        $sql = 'INSERT INTO `'._DB_PREFIX_.self::$definition['table'].'_manufacturers` ( `tab_id` , `id_manufacturer` ) VALUES ( "'.(int)$tab_id.'" , "'.(int)$manufacturer_id.'")  ';
        return Db::getInstance()->Execute($sql);
    }


    /*
    * getTabManufacturers
    */
    public static function getTabManufacturers($tab_id)
    {
        $sql = 'SELECT * FROM `'._DB_PREFIX_.self::$definition['table'].'_manufacturers` WHERE `tab_id` = "'.(int)$tab_id.'" ';
        return Db::getInstance()->ExecuteS($sql);
    }


    /*
    * getTabCategories
    */
    public static function getTabCategories($tab_id)
    {
        $sql = 'SELECT * FROM `'._DB_PREFIX_.self::$definition['table'].'_categories` WHERE `tab_id` = "'.(int)$tab_id.'" ';
        $res = Db::getInstance()->ExecuteS($sql);

        // initialize return array
        $categories = array();

        // if categories found
        if ($res) {
            // foreach tab found
            foreach ($res as $row) {
                $categories[] = $row['id_category'];
            }
        }
        return $categories;
    }


    /*
    * deleteTab
    */
    public static function deleteTab($tab_id)
    {
        // delete respective content entries
        CustomProductTabsContentModel::deleteTabContent($tab_id);
    
        // delete tab lang entries
        $sql = 'DELETE FROM `'._DB_PREFIX_.self::$definition['table'].'_lang`  
                WHERE `tab_id` = "'.(int)$tab_id.'"';
        Db::getInstance()->Execute($sql);
        // delete tab
        $sql = 'DELETE FROM `'._DB_PREFIX_.self::$definition['table'].'`  
                WHERE `tab_id` = "'.(int)$tab_id.'"';
        Db::getInstance()->Execute($sql);
    }



    /*
    * getProductTabs
    */
    public static function getProductTabs($product_id, $lang)
    {
        // get shops linked to product
        $shops = Product::getShopsByProduct($product_id);

        // prepare the shop ids array
        $shopIDS = array();
        foreach ($shops as $shop) {
            $shopIDS[] = $shop['id_shop'];
        }

        // get product manufacturer
        $product = new Product($product_id);

        // get product  categories
        $categories = Product::getProductCategories($product_id);

        // get tabs for current product that are active for all categories and all manufacturers
        $sql = 'SELECT `t`.*,`l`.`name`,`l`.`default_content` FROM `'._DB_PREFIX_.self::$definition['table'].'` as `t`
                INNER JOIN `'._DB_PREFIX_.self::$definition['table'].'_lang` as `l` ON `t`.`tab_id` = `l`.`tab_id`
                WHERE 
                `t`.`id_store` IN ('.join(',', $shopIDS).') AND 
                `l`.`id_lang` = "'.(int)$lang.'" AND 
                (
                    (
                        `t`.`all_categories` = 1 AND 
                        `t`.`all_manufacturers` = 1
                    ) 
                    OR 
                    (
                        `t`.`all_categories` = 1 AND
                        `t`.`tab_id` IN ( SELECT `tab_id` FROM `'._DB_PREFIX_.self::$definition['table'].'_manufacturers` WHERE `id_manufacturer` = "'.$product->id_manufacturer.'" )
                    )
                    OR
                    (
                        `t`.`tab_id` IN ( SELECT `tab_id` FROM `'._DB_PREFIX_.self::$definition['table'].'_categories` WHERE `id_category` IN ('.join(',', $categories).') ) AND
                        `t`.`all_manufacturers` = 1
                    )
                    OR
                    (
                        `t`.`tab_id` IN ( SELECT `tab_id` FROM `'._DB_PREFIX_.self::$definition['table'].'_categories` WHERE `id_category` IN ('.join(',', $categories).') ) AND
                        `t`.`tab_id` IN ( SELECT `tab_id` FROM `'._DB_PREFIX_.self::$definition['table'].'_manufacturers` WHERE `id_manufacturer` = "'.$product->id_manufacturer.'" )
                    )
                )
                ORDER BY `position` ASC';
        return Db::getInstance()->ExecuteS($sql);
    }



    /*
    * getShopActiveProductTabs
    */
    public static function getShopActiveProductTabs($product_id, $shop, $lang)
    {
        // get product manufacturer
        $product = new Product($product_id);

        // get product  categories
        $categories = Product::getProductCategories($product_id);

        // get tabs for current product that are active for all categories and all manufacturers
        $sql = 'SELECT `t`.*,`l`.`name`,`l`.`default_content` FROM `'._DB_PREFIX_.self::$definition['table'].'` as `t`
                INNER JOIN `'._DB_PREFIX_.self::$definition['table'].'_lang` as `l` ON `t`.`tab_id` = `l`.`tab_id`
                WHERE 
                `t`.`id_store` = "'.(int)$shop.'" AND 
                `l`.`id_lang` = "'.(int)$lang.'" AND 
                (
                    (
                        `t`.`all_categories` = 1 AND 
                        `t`.`all_manufacturers` = 1
                    ) 
                    OR 
                    (
                        `t`.`all_categories` = 1 AND
                        `t`.`tab_id` IN ( SELECT `tab_id` FROM `'._DB_PREFIX_.self::$definition['table'].'_manufacturers` WHERE `id_manufacturer` = "'.$product->id_manufacturer.'" )
                    )
                    OR
                    (
                        `t`.`tab_id` IN ( SELECT `tab_id` FROM `'._DB_PREFIX_.self::$definition['table'].'_categories` WHERE `id_category` IN ('.join(',', $categories).') ) AND
                        `t`.`all_manufacturers` = 1
                    )
                    OR
                    (
                        `t`.`tab_id` IN ( SELECT `tab_id` FROM `'._DB_PREFIX_.self::$definition['table'].'_categories` WHERE `id_category` IN ('.join(',', $categories).') ) AND
                        `t`.`tab_id` IN ( SELECT `tab_id` FROM `'._DB_PREFIX_.self::$definition['table'].'_manufacturers` WHERE `id_manufacturer` = "'.$product->id_manufacturer.'" )
                    )
                )
                ORDER BY `position` ASC';
        return Db::getInstance()->ExecuteS($sql);
    }
}
