<?php
/**
*
*
*    Custom Product Tabs
*    Copyright 2015  Inno-mods.io
*
*    @author    Inno-mods.io
*    @copyright Inno-mods.io
*    @version   1.1.0
*    Visit us at http://www.inno-mods.io
*
*
**/

class CustomProductTabsContentModel extends ObjectModel
{

    /*
    * definition
    */
    public $content_id;
    public $tab_id;
    public $product_id;
    public $status;
    public $content;

    public static $definition = array(
                                        'table' => 'customproducttabs_content',
                                        'primary' => 'content_id',
                                        'multishop' => true,
                                        'multilang' => true,
                                        'fields' => array(
                                                            'tab_id' => array(
                                                                            'type' => self::TYPE_INT,
                                                                            'validate' => 'isUnsignedInt',
                                                                            'required' => true
                                                                        ),
                                                            'product_id' => array(
                                                                            'type' => self::TYPE_INT,
                                                                            'validate' => 'isUnsignedInt',
                                                                            'required' => true
                                                                        ),
                                                            'status' => array(
                                                                            'type' => self::TYPE_INT,
                                                                            'validate' => 'isUnsignedInt',
                                                                            'required' => true
                                                                        ),
                                                            'content' => array(
                                                                                'type' => self::TYPE_HTML,
                                                                                'lang' => true,
                                                                                'size' => 3999999999999
                                                                            ),
                                                        ),
                                    );


    /*
    * createSchema for current Model
    */
    public static function createSchema()
    {
        //main table for the files
        return ( CustomProductTabsContentModel::createCustomProductTabsContentTable() && CustomProductTabsContentModel::createCustomProductTabsContentLanguageTable() );
    }




    /*
    * dropSchema for current Model
    */
    public static function dropSchema()
    {
        $sql = 'DROP TABLE IF EXISTS `'._DB_PREFIX_.self::$definition['table'].'`,
                                     `'._DB_PREFIX_.self::$definition['table'].'_lang`';
        $result = Db::getInstance()->execute($sql);
        return $result;
    }




    /*
    * createCustomProductTabsContentTable
    */
    public static function createCustomProductTabsContentTable()
    {
        $sql = 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.self::$definition['table'].'`(
                `content_id` int(10) unsigned NOT NULL auto_increment,
                `tab_id` int(10) unsigned NOT NULL default \'1\',
                `product_id` int(10) unsigned NOT NULL,
                `status` int(10) unsigned NOT NULL,
                PRIMARY KEY (`content_id`)
                ) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=utf8';

        return Db::getInstance()->execute($sql);
    }


    /*
    * createCustomProductTabsContentLanguageTable
    */
    public static function createCustomProductTabsContentLanguageTable()
    {
        $sql = 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.self::$definition['table'].'_lang` (
                      `content_id` int(10) unsigned NOT NULL,
                      `id_lang` int(10) unsigned NOT NULL,
                      `content` text NOT NULL,
                      PRIMARY KEY (`content_id`,`id_lang`)
                    ) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=utf8';

        return Db::getInstance()->execute($sql);
    }




    /*
    * getProductTabsContent
    */
    public static function getProductTabsContent($tabID, $productID)
    {
        // get content id and status
        $sql = 'SELECT `c`.`content_id`,`c`.`status` FROM `'._DB_PREFIX_.self::$definition['table'].'` as `c`
                WHERE `c`.`tab_id` = "'.$tabID.'" AND `c`.`product_id` = "'.$productID.'" ';
        $content =  Db::getInstance()->getRow($sql);

        // if content exists get language data
        if ($content) {
            $sql = 'SELECT `l`.`id_lang`,`l`.`content` FROM  `'._DB_PREFIX_.self::$definition['table'].'_lang` as `l` 
                    WHERE `l`.`content_id` = "'.$content['content_id'].'" ';
            $res =  Db::getInstance()->ExecuteS($sql);
            // if content found assign to result array
            if ($res) {
                $temp = array();
                foreach ($res as $row) {
                    $temp[$row['id_lang']] = $row['content'];
                }
                $content['content'] = $temp;
            }
            return $content;
        }
            
    }



    /*
    * getTabContent
    */
    public static function getTabContent($product_id, $tab_id, $lang)
    {
        $sql = 'SELECT * FROM `'._DB_PREFIX_.self::$definition['table'].'` as `c`
                INNER JOIN `'._DB_PREFIX_.self::$definition['table'].'_lang` as `l` ON `c`.`content_id` = `l`.`content_id`
                WHERE `c`.`product_id` = "'.(int)$product_id.'" AND `c`.`tab_id` = "'.(int)$tab_id.'" AND `l`.`id_lang`="'.(int)$lang.'"  ';
        return Db::getInstance()->getRow($sql);
    }



    /*
    * deleteTabContent
    */
    public static function deleteTabContent($tab_id)
    {
        // get content ids for tab id given
        $sql = 'SELECT `content_id` FROM  `'._DB_PREFIX_.self::$definition['table'].'` 
                WHERE `tab_id` = "'.$tab_id.'" ';
        $res =  Db::getInstance()->ExecuteS($sql);
        // if content ids found
        if ($res) {
            foreach ($res as $row) {
                // delete tab content lang entries
                $sql = 'DELETE FROM `'._DB_PREFIX_.self::$definition['table'].'_lang`  
                        WHERE `content_id` = "'.(int)$row['content_id'].'"';
                Db::getInstance()->Execute($sql);
                // delete tab content
                $sql = 'DELETE FROM `'._DB_PREFIX_.self::$definition['table'].'`  
                        WHERE `content_id` = "'.(int)$row['content_id'].'"';
                Db::getInstance()->Execute($sql);
            }
        }

    
    }
}
