/**  
* 
*
*    Custom Product Tabs  
*    Copyright 2015  Inno-mods.io 
*
*    @author    Inno-mods.io 
*    @copyright Inno-mods.io
*    @version   1.1.0
*    Visit us at http://www.inno-mods.io 
*  
*  
**/
$(document).ready(function() {

  	/*
  	* Responsive images
  	*/
    $('.tabs img').css('max-width','100%');
    $('.tabs img').css('height','auto');

  	/*
  	* Responsive videos
  	*/
  	// Select all videos ( add as many video providers as you want )
    var $videos = $('iframe[src*="//www.youtube.com"],iframe[src*="//player.vimeo.com"]');
 
    // Figure out and save aspect ratio for each video
    $videos.each(function() {
        if (this.height!=0) {
            // Save the aspect ratio
            $(this).data('aspectRatio', this.height / this.width)
                   // Remove the hard coded width/height
                   .removeAttr('height')
                   .removeAttr('width');
        } else {
            $(this).data('aspectRatio', 9 / 16)
                   // Remove the hard coded width/height
                   .removeAttr('height')
                   .removeAttr('width');       
        }
    });
 
    // When the window is resized, we have to resize our videos
    $(window).resize(function() {
 
        // Resize all videos according to their aspect ratio
        $videos.each(function() {
 
            var $currentVideo = $(this);
            // Get parent element width
            var newWidth = $('#tab-content').width();
            // Assign width and height
            $currentVideo.width(newWidth)
                         .height(newWidth * $currentVideo.data('aspectRatio'));
 
      });
 
    // Trigger one resize to treat videos on page load
    }).resize();
});