/**  
* 
*
*    Custom Product Tabs 
*    Copyright 2015  Inno-mods.io 
*
*    @author    Inno-mods.io 
*    @copyright Inno-mods.io
*    @version   1.1.0
*    Visit us at http://www.inno-mods.io 
*  
*  
**/
function tinyExtendedSetup(config){
	if(!config)
		config = {};

	var editor_selector = 'rte';
	if (typeof config['editor_selector'] != 'undefined')
		config['selector'] = '.'+config['editor_selector'];

	// safari,pagebreak,style,table,advimage,advlink,inlinepopups,media,contextmenu,paste,fullscreen,xhtmlxtras,preview
	default_config = {
		selector: ".rte" ,
		plugins : "visualblocks, preview searchreplace print insertdatetime, hr charmap colorpicker anchor code link image paste pagebreak table contextmenu filemanager table code media autoresize textcolor emoticons",
        toolbar2 : "code,|,bold,italic,underline,|,alignleft,aligncenter,alignright,alignjustify,|,colorpicker,|,link,unlink,anchor,|,table,|,blockquote,|,strikethrough,superscript,subscript,|,bullist,numlist,|,outdent,indent,|,undo,redo,|,image,media",
        toolbar1 : "styleselect,|,formatselect,|,fontselect,|,fontsizeselect,", 
        toolbar3 : "",
        toolbar4 : "visualblocks,|,charmap,|,hr,|",
           
		external_filemanager_path: ad+"/filemanager/",
		filemanager_title: "File manager" ,
		external_plugins: { "filemanager" : ad+"/filemanager/plugin.min.js"},
		extended_valid_elements: 'pre[*],script[*],style[*]', 
        valid_children: "+body[meta|style|script],pre[script|div|p|br|span|img|style|h1|h2|h3|h4|h5],*[*]",
        valid_elements : '*[*]', 
        force_p_newlines : false, 
        cleanup: false,
        forced_root_block : false, 
        force_br_newlines : true,
        convert_urls:true,
        relative_urls:false,
        remove_script_host:false, 
        theme_advanced_resizing:true,
		menu: {
			edit: {title: 'Edit', items: 'undo redo | cut copy paste | selectall'},
			insert: {title: 'Insert', items: 'media image link | pagebreak'},
			view: {title: 'View', items: 'visualaid'},
			format: {title: 'Format', items: 'bold italic underline strikethrough superscript subscript | formats | removeformat'},
			table: {title: 'Table', items: 'inserttable tableprops deletetable | cell row column'},
			tools: {title: 'Tools', items: 'code'}
		}

	}

	$.each(default_config, function(index, el)
	{
		if (config[index] === undefined )
			config[index] = el;
	});

	tinyMCE.init(config);
}


$(document).ready(function() {
	tinyExtendedSetup(); 
});
