{*  
* 
*
*    Custom Product Tabs 
*    Copyright 2015  Inno-mods.io 
*
*    @author    Inno-mods.io 
*    @copyright Inno-mods.io
*    @version   1.1.0
*    Visit us at http://www.inno-mods.io 
*  
*   
*}

<div id="customproducttabs">
	<div class="alert alert-info">{l s='Note: in order to view custom tabs set for a specific manufacturer or category, you have to first configure the product respectively and save it!' mod='customproducttabs'}</div>
	<input type="hidden" name="submitted_tabs[]" value="customproducttabs" />
	{foreach from=$tabs item=tab}	
		<div id="product-customproducttabs" class="panel product-tab">
			<h3>
				<b>{$tab['name']|escape:'htmlall':'UTF-8'}</b> 
				( {l s='Shop' mod='customproducttabs'}: {$tab['shop_name']|escape:'htmlall':'UTF-8'} ) 

			</h3>
			{if ($tab['all_categories']==0 || $tab['all_manufacturers']==0)}
				<div class="form-group">
					<div class="col-lg-9 col-lg-offset-3">
						<div class="alert alert-info">
							{if ($tab['all_categories']==0)}{l s='visible for specific categories' mod='customproducttabs'}{/if} 
							{if ($tab['all_categories']==0 && $tab['all_manufacturers']==0)} - {/if}
							{if ($tab['all_manufacturers']==0)}{l s='visible for specific manufacturers' mod='customproducttabs'}{/if} 
						</div>
					</div>
				</div>
			{/if}
			<input type="hidden" name="customproducttabs[]" value="{$tab['id']|escape:'htmlall':'UTF-8'}" />
			<input type="hidden" name="tab_{$tab['id']|escape:'htmlall':'UTF-8'}_content_id" value="{$tab['content_id']|escape:'htmlall':'UTF-8'}" />
			<div class="form-group">
				<div class="col-lg-1"><span class="pull-right"></span></div>
				<label class="control-label col-lg-2">
					{l s='Active' mod='customproducttabs'}
				</label>
				<div class="col-lg-9">
					<span class="switch prestashop-switch fixed-width-lg">
						<input type="radio" name="tab_{$tab['id']|escape:'htmlall':'UTF-8'}_status" id="tab_{$tab['id']|escape:'htmlall':'UTF-8'}_status_on" value="1" {if $tab['content_status'] == 1}checked="checked"{/if}>
						<label for="tab_{$tab['id']|escape:'htmlall':'UTF-8'}_status_on">
							{l s='Yes' mod='customproducttabs'}
						</label>
						<input type="radio" name="tab_{$tab['id']|escape:'htmlall':'UTF-8'}_status" id="tab_{$tab['id']|escape:'htmlall':'UTF-8'}_status_off" value="0" {if $tab['content_status'] == 0}checked="checked"{/if}>
						<label for="tab_{$tab['id']|escape:'htmlall':'UTF-8'}_status_off">
							{l s='No' mod='customproducttabs'}
						</label>
						<a class="slide-button btn"></a>
					</span>
				</div>
			</div>

			<div class="form-group">
				<div class="col-lg-1"><span class="pull-right"></span></div>
				<label class="control-label col-lg-2" for="description_short_2">
					<span>
						{l s='Content' mod='customproducttabs'}
					</span>
				</label>

				<div class="col-lg-9">
					{include file="controllers/products/textarea_lang.tpl"
		                languages=$languages
		                input_name="tab_{$tab.id|escape:'htmlall':'UTF-8'}_customtabcontent" 
		                class="rte"
		                input_value=$tab['content']
		               }	
				</div>
						
			</div>
			<div class="panel-footer">
				<a href="{$link->getAdminLink('AdminProducts')|escape:'html':'UTF-8'}" class="btn btn-default"><i class="process-icon-cancel"></i> {l s='Cancel' mod='customproducttabs'}</a>
				<button type="submit" name="submitAddproduct" class="btn btn-default pull-right"><i class="process-icon-save"></i> {l s='Save' mod='customproducttabs'}</button>
				<button type="submit" name="submitAddproductAndStay" class="btn btn-default pull-right"><i class="process-icon-save"></i> {l s='Save and stay' mod='customproducttabs'}</button>
			</div>

		</div>
	{/foreach}
</div>

{if $editorLoad == 'newWay'}
	<script language="javascript" type="text/javascript">
		$(document).ready(function() {

			var id_language = {$id_language|escape:'htmlall':'UTF-8'};
			var languages = new Array();
			// Multilang field setup must happen before document is ready so that calls to displayFlags() to avoid
			// precedence conflicts with other document.ready() blocks
			{foreach $languages as $k => $language}
				languages[{$k}] = {
					id_lang: {$language.id_lang},
					iso_code: '{$language.iso_code}',
					name: '{$language.name}',
					is_default: '{$language.is_default}'
				};
			{/foreach}
			// we need allowEmployeeFormLang var in ajax request
			allowEmployeeFormLang = {$allowEmployeeFormLang|escape:'htmlall':'UTF-8'};
			displayFlags(languages, id_language, allowEmployeeFormLang);

			// init editor		
			tinySetup({
					editor_selector :"rte"
				});

		});
	</script>
{/if}

{if $editorLoad == 'oldWay'}
	<script type="text/javascript" src="../modules/customproducttabs/views/js/tinymceExtend.js"></script>
{/if}

