{*  
* 
*
*    Custom Product Tabs 
*    Copyright 2015  Inno-mods.io 
*
*    @author    Inno-mods.io 
*    @copyright Inno-mods.io
*    @version   1.1.0
*    Visit us at http://www.inno-mods.io 
*  
*   
*}

<div id="customproducttabs">
	<div class="alert alert-info">{l s='Note: in order to view custom tabs set for a specific manufacturer or category, you have to first configure the product respectively and save it!' mod='customproducttabs'}</div>
	<input type="hidden" name="submitted_tabs[]" value="customproducttabs" />
	{foreach from=$tabs item=tab}	
		<div id="product-customproducttabs" class="panel product-tab">
			<h3>
				<b>{$tab['name']|escape:'htmlall':'UTF-8'}</b> 
				( {l s='Shop' mod='customproducttabs'}: {$tab['shop_name']|escape:'htmlall':'UTF-8'} ) 

			</h3>
			{if ($tab['all_categories']==0 || $tab['all_manufacturers']==0)}
				<div class="form-group">
					<div class="col-lg-10 col-lg-offset-3">
						<div class="alert alert-info">
							{if ($tab['all_categories']==0)}{l s='visible for specific categories' mod='customproducttabs'}{/if} 
							{if ($tab['all_categories']==0 && $tab['all_manufacturers']==0)} - {/if}
							{if ($tab['all_manufacturers']==0)}{l s='visible for specific manufacturers' mod='customproducttabs'}{/if} 
						</div>
					</div>
				</div>
			{/if}
			<input type="hidden" name="customproducttabs[]" value="{$tab['id']|escape:'htmlall':'UTF-8'}" />
			<input type="hidden" name="tab_{$tab['id']|escape:'htmlall':'UTF-8'}_content_id" value="{$tab['content_id']|escape:'htmlall':'UTF-8'}" />
			<div class="form-group">
				<div class="col-xl-2">
					{l s='Active' mod='customproducttabs'}
				</div>
				<div class="col-xl-10">
					<span class="switch prestashop-switch fixed-width-lg">
						<input type="radio" name="tab_{$tab['id']|escape:'htmlall':'UTF-8'}_status" id="tab_{$tab['id']|escape:'htmlall':'UTF-8'}_status_on" value="1" {if $tab['content_status'] == 1}checked="checked"{/if}>
						<label for="tab_{$tab['id']|escape:'htmlall':'UTF-8'}_status_on">
							{l s='Yes' mod='customproducttabs'}
						</label>
						<input type="radio" name="tab_{$tab['id']|escape:'htmlall':'UTF-8'}_status" id="tab_{$tab['id']|escape:'htmlall':'UTF-8'}_status_off" value="0" {if $tab['content_status'] == 0}checked="checked"{/if}>
						<label for="tab_{$tab['id']|escape:'htmlall':'UTF-8'}_status_off">
							{l s='No' mod='customproducttabs'}
						</label>
						<a class="slide-button btn"></a>
					</span>
				</div>
			</div>

			<div class="form-group">
				<div class="col-xl-2" for="description_short_2">
					<span>
						{l s='Content' mod='customproducttabs'}
					</span>
				</div>

				<div class="col-xl-9"> 
					{assign var=use_textarea_autosize value=true}
					{if $languages|count > 0}
						{foreach $languages as $language}
						
						
							{if $languages|count > 1}
								<div class="form-group translatable-field lang-{$language.id_lang}"{if $language.id_lang != $id_language} style="display:none;"{/if}>
									<div class="col-lg-10">
							{/if}
										
											
										<textarea name="tab_{$tab.id|escape:'htmlall':'UTF-8'}_customtabcontent_{$language.id_lang}" id="tab_{$tab.id|escape:'htmlall':'UTF-8'}_customtabcontent_{$language.id_lang}" class="rte autoload_rte">{$tab['content'][$language.id_lang]}</textarea>
											
							{if $languages|count > 1}
									</div>
									<div class="col-lg-2">
										<button type="button" class="btn btn-primary dropdown-toggle" tabindex="-1" data-toggle="dropdown">
											{$language.iso_code}
											<span class="caret"></span>
										</button>
										<ul class="dropdown-menu">
											{foreach from=$languages item=language}
												<li>
													<a href="javascript:hideOtherLanguage({$language.id_lang});" tabindex="-1">{$language.name}</a>
												</li>
											{/foreach}
										</ul>
									</div>
								</div>
							{/if}
							
							
						{/foreach}				
					{/if}	               
		               		               
				</div>			
			</div>
			<div style="clear:both;"></div>
		</div>
	{/foreach}
</div>

