{*  
* 
*
*    Custom Product Tabs 
*    Copyright 2015  Inno-mods.io 
*
*    @author    Inno-mods.io 
*    @copyright Inno-mods.io
*    @version   1.1.0
*    Visit us at http://www.inno-mods.io 
*  
*   
*}

<div id="customproducttabs">
	<div class="alert alert-info">{l s='Note: in order to view custom tabs set for a specific manufacturer or category, you have to first configure the product respectively and save it!' mod='customproducttabs'}</div>
	<input type="hidden" name="submitted_tabs[]" value="customproducttabs" />
	{foreach from=$tabs item=tab}	
		<div id="product-customproducttabs" class="panel product-tab">
			<fieldset>
				<legend>
					<b>{$tab['name']|escape:'htmlall':'UTF-8'}</b> 
					( {l s='Shop' mod='customproducttabs'}: {$tab['shop_name']|escape:'htmlall':'UTF-8'} ) 
				</legend>
				{if ($tab['all_categories']==0 || $tab['all_manufacturers']==0)}
					<div class="form-group">
						<div class="col-lg-9 col-lg-offset-3">
							<div class="alert alert-info">
								{if ($tab['all_categories']==0)}{l s='visible for specific categories' mod='customproducttabs'}{/if} 
								{if ($tab['all_categories']==0 && $tab['all_manufacturers']==0)} - {/if}
								{if ($tab['all_manufacturers']==0)}{l s='visible for specific manufacturers' mod='customproducttabs'}{/if} 
							</div>
						</div>
					</div>
				{/if}
				<input type="hidden" name="customproducttabs[]" value="{$tab['id']|escape:'htmlall':'UTF-8'}" />
				<input type="hidden" name="tab_{$tab['id']|escape:'htmlall':'UTF-8'}_content_id" value="{$tab['content_id']|escape:'htmlall':'UTF-8'}" />

				<label class="control-label">
					{l s='Active' mod='customproducttabs'}
				</label>
				<div class="margin-form">
					<div class="form-group">
						<div class="radio-wrapper">
							<input type="radio" name="tab_{$tab['id']|escape:'htmlall':'UTF-8'}_status" id="tab_{$tab['id']|escape:'htmlall':'UTF-8'}_status_on" value="1" {if $tab['content_status'] == 1}checked="checked"{/if}>
							<label class="t" for="active_on">
								<img src="../img/admin/enabled.gif" alt="{l s='Yes' mod='customproducttabs'}" title="{l s='Yes' mod='customproducttabs'}">
							</label>
							<input type="radio" name="tab_{$tab['id']|escape:'htmlall':'UTF-8'}_status" id="tab_{$tab['id']|escape:'htmlall':'UTF-8'}_status_off" value="0" {if $tab['content_status'] == 0}checked="checked"{/if}>
							<label class="t" for="active_off">
								<img src="../img/admin/disabled.gif" alt="{l s='No' mod='customproducttabs'}" title="{l s='No' mod='customproducttabs'}">
							</label>
						</div>	
					</div>
				</div>

				<div class="clear"></div>



				<label class="control-label">
					{l s='Content' mod='customproducttabs'}
				</label>
				<div class="margin-form">
					<div class="form-group">
						<div >
							{include file="controllers/products/textarea_lang.tpl"
				                languages=$languages
				                id_language=$id_language
				                input_name="tab_{$tab.id|escape:'htmlall':'UTF-8'}_customtabcontent" 
				                class="autoload_rte"
				                input_value=$tab['content']
				                iso_tiny_mce = $iso
				                ad = $ad
				                allowEmployeeFormLang = $allowEmployeeFormLang
				               }	
						</div>
								
					</div>
				</div>
			</fieldset>
		</div>
	{/foreach}
</div>
<script language="javascript" type="text/javascript">
	$(document).ready(function() {

		var id_language = {$id_language|escape:'htmlall':'UTF-8'};
		var languages = new Array();
		// Multilang field setup must happen before document is ready so that calls to displayFlags() to avoid
		// precedence conflicts with other document.ready() blocks
		{foreach $languages as $k => $language}
			languages[{$k|escape:'htmlall':'UTF-8'}] = {
				id_lang: {$language.id_lang|escape:'htmlall':'UTF-8'},
				iso_code: '{$language.iso_code|escape:'htmlall':'UTF-8'}',
				name: '{$language.name|escape:'htmlall':'UTF-8'}',
				is_default: '{$language.is_default|escape:'htmlall':'UTF-8'}'
			};
		{/foreach}
		// we need allowEmployeeFormLang var in ajax request
		allowEmployeeFormLang = {$allowEmployeeFormLang|escape:'htmlall':'UTF-8'};
		displayFlags(languages, id_language, allowEmployeeFormLang);

		// init editor		
		tinySetup({
				editor_selector :"autoload_rte"
			});

	});
</script>



