{*
*
*
*    Custom Product Tabs
*    Copyright 2015  Inno-mods.io
*
*    @author    Inno-mods.io
*    @copyright Inno-mods.io
*    @version   1.1.0
*    Visit us at http://www.inno-mods.io
*
*
*}

{if count($tabs) == 0 && count($tabs) == 0}
	<div class="alert alert-info">
		{l s='Start by creating your first custom tab!' mod='customproducttabs'}
	</div>
{else}
	<div class="alert alert-info">
		{l s='Drad and Drop to rearrange the order of the tabs!' mod='customproducttabs'}
	</div>
{/if}

<div class="customproducttabs-tabslist">
	<div class="tabslist-wrapper">
		<ul class="ui-sortable">
			{foreach from=$tabs item=tab}
			    <li id="{$tab['tab_id']|escape:'htmlall':'UTF-8'}" class="{if $tab['status'] == 1}active{else}inactive{/if}">
			    	{$tab['name']|escape:'htmlall':'UTF-8'}

			    	<a href="{$uri|escape:'htmlall':'UTF-8'}&moduleController=deleteTab&tab_id={$tab['tab_id']|escape:'htmlall':'UTF-8'}" class="deleteSubmit pull-right space-bothsides"> <i class="icon-trash"></i> {l s='delete' mod='customproducttabs'} </a>
			    	<a href="{$uri|escape:'htmlall':'UTF-8'}&moduleController=tabForm&tab_id={$tab['tab_id']|escape:'htmlall':'UTF-8'}&setShopContext=s-{$shop|escape:'htmlall':'UTF-8'}" class="pull-right space-bothsides"><i class="icon-pencil"></i> {l s='Edit' d='Shop.Theme.Actions'}</a>

			    </li>
			{/foreach}
		</ul>
	</div>
</div>

<script>
    $(document).ready(function(){
    	// initiate sortables
	    $( ".ui-sortable" ).sortable({
	    	// add a palceholder
	    	placeholder: "customproducttabs-sortables-placeholder",
	    	// on update action
			update: function (event, ui) {
											// assign data to a var
									        var order = $(this).sortable('toArray').toString();
									        // POST to server using $.ajax
									        $.ajax({
									            data: {
									            		'order': order
									            	  },
									            type: 'POST',
									            url: '{$uri}&moduleController=ajaxOrder'
									        });
									     }
	    }).disableSelection();
    });
</script>


<!-- we should use only one modal for all delete buttons -->
<div id="DeleteModal" class="modal fade text-left">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                <h4 class="modal-title">{l s='Delete confirmation' mod='customproducttabs'}</h4>
            </div>
            <div class="modal-body">
                <p>{l s='Are you sure you want to delete this tab?' mod='customproducttabs'}</p>
                <p class="text-warning"><small>{l s='All product content for this tab will also be deleted permanently.' mod='customproducttabs'}</small></p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">{l s='Cancel' mod='customproducttabs'}</button>
                <button type="button" class="btn btn-primary" id="deletePermanently">{l s='Delete Permanently' mod='customproducttabs'}</button>
            </div>
        </div>
    </div>
</div>

<script>
	$(document).ready(function(){
		// delete warning prompt
		$('.deleteSubmit').on('click', function(e){
			// action url
			uri = $(this).attr('href');
			// prevent default
		    e.preventDefault();
		    // init modal on request
		    $('#DeleteModal').modal({ backdrop: 'static', keyboard: false })
		        .one('click', '#deletePermanently', function() { // (one. is not a typo of on.)
		        	// submit the link
		            window.location = uri ;
		        });
		});
	});
</script>
<!-- we should use only one modal for all delete buttons -->
