<?php
/**
* 2011-2019 Promokit
*
* @package   pk_amp
* @version   1.0
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2019 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
*/

if (file_exists(_PS_MODULE_DIR_.'ps_currencyselector/ps_currencyselector.php')) {
  include_once _PS_MODULE_DIR_.'ps_currencyselector/ps_currencyselector.php';
}
if (file_exists(_PS_MODULE_DIR_.'ps_languageselector/ps_languageselector.php')) {
  include_once _PS_MODULE_DIR_.'ps_languageselector/ps_languageselector.php';
}
if (file_exists(_PS_MODULE_DIR_.'ps_mainmenu/ps_mainmenu.php')) {
  include_once _PS_MODULE_DIR_.'ps_mainmenu/ps_mainmenu.php';
}
if (file_exists(_PS_MODULE_DIR_.'pk_themesettings/pk_themesettings.php')) {
  include_once _PS_MODULE_DIR_.'pk_themesettings/pk_themesettings.php';
}
if (file_exists(_PS_MODULE_DIR_.'ps_linklist/ps_linklist.php')) {
  include_once _PS_MODULE_DIR_.'ps_linklist/ps_linklist.php';
}

include_once _PS_MODULE_DIR_.'pk_amp/controllers/front/cart.php';
use PrestaShop\PrestaShop\Adapter\Cart\CartPresenter;

class Amp extends Module
{
  public function __construct()
  {
    $context = Context::getContext();
    $currentLink = $context->shop->getBaseURL(true, false).$_SERVER['REQUEST_URI'];

    // redirect back to canonical link
    if (isset($context->smarty->tpl_vars['canonical']->value)) {
      $canonical = $context->smarty->tpl_vars['canonical']->value;
      str_replace('pk_amp', '', $currentLink, $count);
      if ( (Context::getContext()->getDevice() == 1) && ($count != 0) ) {
        //Tools::redirect($canonical);
      }
    }
  }

  public function getAmpConfiguration($front = false)
  {
      $amp_config_serialized = Configuration::get('AMP_CONFIG');
      $config = unserialize($amp_config_serialized);
      $confOrdered = array();
      if ($front) {

        foreach ($config as $param => $value) {
          $temp = &$confOrdered;
          $paramParts = explode("_", $param);
          foreach ($paramParts as $key => $v) {
            $temp =& $temp[$v];
          }
          $temp = $value;
        }
        $config = $confOrdered;
      }
      return $config;
  }

  public function getThemeVars($meta)
  {
    if (!isset($meta['id'])) $meta['id'] = '';
    if (!isset($meta['title'])) $meta['title'] = '';

    $cache_id = 'AmpClass'.$meta['name'].$meta['id'];

    if (!Cache::isStored($cache_id)) {

      $vars = array();
      $context = Context::getContext();

      if (file_exists(_PS_IMG_DIR_.Configuration::get('PS_LOGO'))) {
        $size = getimagesize(_PS_IMG_DIR_.Configuration::get('PS_LOGO'));
      }

      $vars['header']['logo']['width'] = isset($size[0]) ? $size[0] : '100';
      $vars['header']['logo']['height'] = isset($size[1]) ? $size[1] : '30';

      if (class_exists('Ps_Currencyselector')) {
        $currencies = new Ps_Currencyselector();
        $vars['header']['curr'] = $currencies->getWidgetVariables(null, array());
      }

      if (class_exists('Ps_Languageselector')) {
        $languages = new Ps_Languageselector();
        $vars['header']['langs'] = $languages->getWidgetVariables(null, array());
      }

      if (class_exists('Ps_MainMenu')) {
        // TODO: generate direct AMP links
        $menu = new Ps_MainMenu();
        $vars['menu'] = $menu->getWidgetVariables('menu', array());

        // Ampify menu links
        //print_r($vars['menu']['children']);
        $vars['menu']['children'] = $this->menuHandler($vars['menu']['children']);

      }
      if (class_exists('Ps_Linklist')) {
        // TODO: generate direct AMP links
        $hook = 'displayAmpFooter';
        $links = new Ps_Linklist();
        $allLinks = $links->getWidgetVariables($hook, array());

        $vars['footer'] = $this->ampifyCMSlinks($allLinks);     
      }

      $cartCtrl = new Pk_AmpCartModuleFrontController();
      $vars['global']['cartState'] = $cartCtrl->cartState();

      //['items'] = array();//json_encode($cartState['products']);
      //$vars['global']['cartState']['info'] = array();
      //$vars['global']['cartState']['products_count'] = 0;//json_encode($cartState['products_count']);

      $vars['global']['base_url'] = Context::getContext()->shop->getBaseURL(true, true);
      $vars['global']['assets'] = rtrim($vars['global']['base_url'],'/')._PS_THEME_URI_.'templates/mobile/assets/';
      $vars['global']['images']['large']['size'] = Image::getSize(ImageType::getFormattedName('large'));
      $vars['global']['images']['home']['size'] = Image::getSize(ImageType::getFormattedName('home'));
      $vars['global']['images']['cart']['size'] = Image::getSize(ImageType::getFormattedName('cart'));
      $vars['global']['images']['small']['size'] = Image::getSize(ImageType::getFormattedName('small'));
      $vars['global']['images']['category']['size'] = Image::getSize(ImageType::getFormattedName('category'));
      $vars['global']['images']['medium']['size'] = Image::getSize(ImageType::getFormattedName('medium'));
      $vars['global']['images']['brand']['size'] = Image::getSize(ImageType::getFormattedName('brand'));
      $vars['global']['images']['stores']['size'] = Image::getSize(ImageType::getFormattedName('stores'));

      $vars['global']['meta'] = Meta::getMetaTags($context->language->id, $meta['name'], $meta['title']);
      $vars['global']['urls'] = $this->getAmpPagesLinks($meta['name']);

      if (class_exists('Pk_Themesettings')) {
        $ts = new Pk_Themesettings();
        $ts_opts = $ts->getOptions("amp");
        $vars['footer']['payment'] = $ts->getPaymentIcons($ts_opts);
        $vars['footer']['social'] = $ts->getSocialAccouts($ts_opts);
      }

      $vars['cms']['tos_page'] = CMS::getCMSContent(Configuration::get('PS_CONDITIONS_CMS_ID'));
      $vars['global']['vars']['nextPageToLoad'] = 2; // for "Load more" button, next page number
      //$vars['listing']['products_per_page'][0] = round(Configuration::get('PS_PRODUCTS_PER_PAGE')/2);
      $vars['listing']['products_per_page'][1] = Configuration::get('PS_PRODUCTS_PER_PAGE');
      $vars['listing']['products_per_page'][2] = Configuration::get('PS_PRODUCTS_PER_PAGE')*2;
      $vars['listing']['products_per_page'][3] = Configuration::get('PS_PRODUCTS_PER_PAGE')*4;

      $vars['cart'] = (new CartPresenter)->present($context->cart);

      $front = true;
      $vars['config'] = $this->getAmpConfiguration($front);

      Cache::store($cache_id, $vars);

    }

    return Cache::retrieve($cache_id);
  }

  public function menuHandler($menu)
  {
    foreach ($menu as $key => $item) {
      $menu[$key] = $this->ampifyLink($item);
      if (!empty($item['children'])) {
        $menu[$key]['children'] = $this->menuHandler($item['children']);
      }
    }
    return $menu;
  }

  public function ampifyLink($item)
  {
    if ($item['type'] == 'category') {
      $identifier = explode('-', $item['page_identifier']);
      $item['url'] = Context::getContext()->link->getModuleLink('pk_amp', 'category', array('id_category' => (int)$identifier[1]), true, Context::getContext()->language->id, Context::getContext()->shop->id, false);
    }
    return $item;
  }

  public function setHeaders($success = true, $redirect = false)
  {
    header("access-control-allow-credentials:true");
    header("access-control-allow-headers:Content-Type, Content-Length, Accept-Encoding, X-CSRF-Token");
    header("access-control-allow-methods:GET,POST");
    header("amp-access-control-allow-source-origin: https://".$_SERVER['HTTP_HOST']);
    header("access-control-allow-origin: https://".$_SERVER['HTTP_HOST']);
    header("Content-Type: application/json");

    if ($success) {
      header("access-control-expose-headers:AMP-Access-Control-Allow-Source-Origin");
    } else {
      header("HTTP/1.1 401 Unauthorized");
    }

    if ($redirect != false) {
      header("AMP-Redirect-To:".$redirect);
    }
  }

  public function injectCSS($files = array())
  {
    $styles = null;
    $compress = true;
    $path = _PS_MODULE_DIR_.'pk_amp/views/css/';

    // always add "global" and "fonts" styles
    array_unshift($files, 'fonts', 'global');
    // always add dynamically generated styles
    $files[] = 'dynamic/generated-s'.Context::getContext()->shop->id;

    foreach ($files as $file) {
      $styles .= Tools::file_get_contents($path.$file.'.css');
    }

    if ($compress) {
      $styles = Media::minifyCSS($styles);
    }

    Context::getContext()->smarty->assign('css', $styles);
  }

  public function ampifyImg($html)
  {
    preg_match_all("#<img(.*?)\\/?>#", $html, $matches);

    foreach ($matches[1] as $key => $m) {
      preg_match_all('/(alt|src|width|height)=("[^"]*")/i', $m, $matches2);
      $amp_tag = '<amp-img ';
      foreach ($matches2[1] as $key2 => $val) {
        $amp_tag .= $val .'='. $matches2[2][$key2] .' ';
      }
      $amp_tag .= 'layout="responsive"';
      $amp_tag .= '>';
      $amp_tag .= '</amp-img>';
      $html = str_replace($matches[0][$key], $amp_tag, $html);
    }

    return $html;
  }

  public function ampifyVideo($html)
  {
    $ampified = null;
    preg_match('/embed\/([\w+\-+]+)[\"\?]/', $html,$match);
    if (!empty($match[1])) {
      $ampified = '<amp-youtube
      data-videoid="'.$match[1].'"
      layout="responsive"
      width="480" height="270"></amp-youtube>';
    }

    return $ampified;
  }

  public function ampifyContent($html)
  {
    $html = $this->ampifyImg($html);
    $html = $this->ampifyVideo($html);

    return $html;
  }
  
  public function ampifyManufacturersLinks($links)
  {
    $context = Context::getContext();
    if (is_array($links) && !empty($links)) {
      foreach ($links as $key => $link) {
        if (strpos($link['id'], 'manufacturer-page-') !== false) {
          $brandID = str_replace('manufacturer-page-', '', $link['id']);
          $links[$key]['url'] = $context->link->getModuleLink('pk_amp', 'manufacturer', array('id_manufacturer' => $brandID), true, $context->language->id, $context->shop->id, false);

        }
      }
    }
    return $links;
  }

  public function ampifySuppliersLinks($links)
  {
    $context = Context::getContext();
    if (is_array($links) && !empty($links)) {
      foreach ($links as $key => $link) {
        if (strpos($link['id'], 'supplier-page-') !== false) {
          $supplierID = str_replace('supplier-page-', '', $link['id']);
          $links[$key]['url'] = $context->link->getModuleLink('pk_amp', 'supplier', array('id_supplier' => $supplierID), true, $context->language->id, $context->shop->id, false);

        }
      }
    }
    return $links;
  }

  public function ampifySupliersLinks($links)
  {
    return $links;
  }

  public function ampifyCMSlinks($links)
  {
    $context = Context::getContext();
    $pages = $this->getAmpPagesLinks();
    if (is_array($links['linkBlocks']) && !empty($links['linkBlocks'])) {
      foreach ($links['linkBlocks'] as $blockID => $block) {
        if (is_array($block['links']) && !empty($block['links'])) {
          foreach ($block['links'] as $linkID => $link) {

            if (strpos($link['id'], 'link-cms-page-') !== false) {
              $cmsID = str_replace("link-cms-page-", "", $link['id']);
              $links['linkBlocks'][$blockID]['links'][$linkID]['id'] = $cmsID;
              $links['linkBlocks'][$blockID]['links'][$linkID]['isCMS'] = 1;
              $links['linkBlocks'][$blockID]['links'][$linkID]['url'] = $context->link->getModuleLink('pk_amp', 'cms', array('id_cms' => $cmsID), true, $context->language->id, $context->shop->id, false);
            } elseif (strpos($link['id'], 'link-static-page-') !== false) {

              $cmsID = str_replace("link-static-page-", "", $link['id']);
              $cmsID = str_replace("-", "", $cmsID);
              $links['linkBlocks'][$blockID]['links'][$linkID]['url'] = $pages[$cmsID];

            } elseif (strpos($link['id'], 'link-product-page-') !== false) {

              $cmsID = str_replace("link-product-page-", "", $link['id']);
              $cmsID = str_replace("-", "_", $cmsID);
              $links['linkBlocks'][$blockID]['links'][$linkID]['url'] = $pages[$cmsID];

            } else {
              $links['linkBlocks'][$blockID]['links'][$linkID]['isCMS'] = 0;
            }

          }
        } else {
          $links['linkBlocks'][$blockID] = $block;
        }
      }
    }
    return $links;
  }

  public function ampifyCategories($categories)
  {
    foreach ($categories as $key => $value) {
      
    }
  }

  public function getAmpPagesLinks($who = '')
  {
    $params = array();
    $params['id_category'] = null;
    $params['id_product'] = null;
    $params['id_manufacturer'] = null;

    if ($who == 'search') {
      $params['searchstr'] = Tools::getValue('searchstr');
    } elseif ($who == 'category') {
      $params['id_category'] = Tools::getValue('id_category');
    } elseif ($who == 'manufacturer') {
      $params['id_manufacturer'] = Tools::getValue('id_manufacturer');
    } else {
      $params[$who] = 1;
    }

    $pages = array(
    'address' => $this->getAmpPageLink('address'),
    'addresses' => $this->getAmpPageLink('addresses'),
    'authentication' => $this->getAmpPageLink('authentication'),
    'login' => $this->getAmpPageLink('login'),
    'cart' => $this->getAmpPageLink('cart'),
    'category' => $this->getAmpPageLink('category', array('id_category' => $params['id_category'])),
    'cms' => $this->getAmpPageLink('cms'),
    'contact' => $this->getAmpPageLink('contact'),
    'discount' => $this->getAmpPageLink('discount'),
    'guest_tracking' => $this->getAmpPageLink('guest_tracking'),
    'history' => $this->getAmpPageLink('history'),
    'identity' => $this->getAmpPageLink('identity'),
    'index' => $this->getAmpPageLink('index'),
    'myaccount' => $this->getAmpPageLink('myaccount'),
    'order_confirmation' => $this->getAmpPageLink('order_confirmation'),
    'order_detail' => $this->getAmpPageLink('order_detail'),
    'order_follow' => $this->getAmpPageLink('order-follow'),
    'order' => $this->getAmpPageLink('order'),
    'order_return' => $this->getAmpPageLink('order_return'),
    'order_slip' => $this->getAmpPageLink('order-slip'),
    'pagenotfound' => $this->getAmpPageLink('pagenotfound'),
    'password' => $this->getAmpPageLink('password'),
    'pdf_invoice' => $this->getAmpPageLink('pdf_invoice'),
    'pdf_order_return' => $this->getAmpPageLink('pdf_order_return'),
    'pdf_order_slip' => $this->getAmpPageLink('pdf_order_slip'),
    'product' => $this->getAmpPageLink('product', array('id_product' => $params['id_product'])),
    'search' => $this->getAmpPageLink('search'),
    'sitemap' => $this->getAmpPageLink('sitemap'),
    'stores' => $this->getAmpPageLink('stores'),
    'supplier' => $this->getAmpPageLink('supplier'),
    'register' => $this->getAmpPageLink('register'),
    'order_login' => $this->getAmpPageLink('order_login'),
    'new_products' => $this->getAmpPageLink('new-products'),
    'best_sales' => $this->getAmpPageLink('best-sales'),
    'prices_drop' => $this->getAmpPageLink('prices-drop'),
    'manufacturer' => $this->getAmpPageLink('manufacturer', array('id_manufacturer' => $params['id_manufacturer'])),
    'supplier' => $this->getAmpPageLink('supplier'),
    'productListSource' => $this->getAmpPageLink('ajaxFilter', $params),
    'cartURL' => $this->getAmpPageLink('ajaxFilter', array('who'=>$who))
    );
    
    return $pages;
  }

  public function getAmpPageLink($page, $params = array())
  {
    $link = Context::getContext()->link;
    $shop = Context::getContext()->shop->id;
    $lang = Context::getContext()->language->id;

    $pageLink = $link->getModuleLink('pk_amp', $page, $params, true, $lang, $shop, false);

    return $pageLink;
  }

}