<?php
/**
* 2011-2019 Promokit
*
* @package   pk_amp
* @version   1.0
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2019 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
*/

class adminHelper extends Module
{
    public function updateAmpConfiguration($clearConfig = null)
    {
      if ($clearConfig == null) return false;

      foreach ($clearConfig as $key => $value) {
        if (strpos($key, 'lang') !== false) {
          $exploded_key = explode('_', $key);
          $clear_key = preg_split('/_\d$/', $key);

          if (empty($clear_key[0]) || empty(end($exploded_key)))
              continue;

          $lang_id = end($exploded_key);
          $clearConfig[$clear_key[0]][$lang_id] = htmlspecialchars($value);
          unset($clearConfig[$key]);
        }
      }
      
      return Configuration::updateValue('AMP_CONFIG', serialize($clearConfig));
    }
    public function writeFile($data = '', $file)
    {
        if (!$fileHolder = @fopen($file, 'w')) {

          return $this->displayError('Unable to open file '.$file);

        } else {
            if ($data == '') {
                unlink($file);
            } else {
                if (fwrite($fileHolder, $data) === FALSE) {
                    fclose($fileHolder);
                    return $this->displayError('Unable to save CSS file '.$file);
                }
                fclose($fileHolder);
            }
        }
        return $this->displayConfirmation('CSS successfully regenerated');

    }

    public function generateCSS($ampConfig, $form)
    {
        $css = '';
        foreach ($form as $option) {

            if (isset($option['selector'])) {

                $unit = $this->addUnitsforCSSRule($option['css_property']);
                $css .= $option['selector']."{".$option['css_property'].":".$ampConfig[$option['name']].$unit."}\n";

            }
        }

        $css = Media::minifyCSS($css);

        return $css;
    }

    public function addUnitsforCSSRule($rule)
    {
        $rules_with_units_px = array('font-size', 'height', 'max-width', 'width');
        $rules_with_units_em = array('letter-spacing', 'line-height');

        $unit = '';
        if (in_array($rule, $rules_with_units_px)) {
          $unit = 'px';
        }
        if (in_array($rule, $rules_with_units_em)) {
          $unit = 'em';
        }

        return $unit;
    }

    public function getLiveConfigValues()
    {
      $allValues = Tools::getAllValues();
      $exclude = array('controllerUri' => '', 'isolang' => '', 'token' => '', 'module_name' => '', 'configure' => '', 'controller' => '', 'tab' => '', 'tab_module' => '', 'submitAmpConfiguration' => '');
      
      $clearConfig = array_diff_key($allValues, $exclude);
      return $clearConfig;
    }
}