<?php
/**
* Promokit Amp
*
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2019 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
* @version   1.0.2
* @package   Promokit AMP
*/

use PrestaShop\PrestaShop\Adapter\Product\PriceFormatter;
use PrestaShop\PrestaShop\Adapter\Image\ImageRetriever;
use PrestaShop\PrestaShop\Core\Product\ProductListingPresenter;
use PrestaShop\PrestaShop\Adapter\Product\ProductColorsRetriever;
use PrestaShop\PrestaShop\Core\Product\Search\ProductSearchContext;
use PrestaShop\PrestaShop\Core\Product\Search\ProductSearchQuery;
use PrestaShop\PrestaShop\Adapter\PricesDrop\PricesDropProductSearchProvider;
use PrestaShop\PrestaShop\Adapter\NewProducts\NewProductsProductSearchProvider;
use PrestaShop\PrestaShop\Adapter\BestSales\BestSalesProductSearchProvider;
use PrestaShop\PrestaShop\Adapter\Category\CategoryProductSearchProvider;
use PrestaShop\PrestaShop\Adapter\Manufacturer\ManufacturerProductSearchProvider;
use PrestaShop\PrestaShop\Adapter\Supplier\SupplierProductSearchProvider;
use PrestaShop\PrestaShop\Adapter\Search\SearchProductSearchProvider;
use PrestaShop\PrestaShop\Core\Product\Search\SortOrder;
use PrestaShop\PrestaShop\Core\Product\Search\ProductSearchProviderInterface;
use PrestaShop\PrestaShop\Core\Product\Search\FacetsRendererInterface;

class ampProductHelper
{
    public function makeQuery($params)
    {
        $this->context = Context::getContext();

        $so = Tools::getValue('sortOrder');
        $sortOrder = !empty($so) ? $so : 'position.asc';
        $sortOrder = explode('.', $sortOrder);

        $params['sortOrder']['field'] = $sortOrder[0];
        $params['sortOrder']['direction'] = $sortOrder[1];
        $params['pageNumber'] = !empty($params['pageNumber']) ? $params['pageNumber'] : 1;

        $query = new ProductSearchQuery();

        $query
            ->setResultsPerPage($params['productsPerPage'])
            ->setPage($params['pageNumber'])
            ->setSortOrder(
                new SortOrder(
                    'product',
                    $params['sortOrder']['field'],
                    $params['sortOrder']['direction']
                )
            )
        ;

        $context = $this->getProductSearchContext();

        if (!empty($params['id_category'])) {
            $idCategory = new Category($params['id_category']);

            $searchProvider = new CategoryProductSearchProvider(
                $this->context->getTranslator(),
                $idCategory
            );

            $query->setIdCategory($idCategory);

            // run filter on category page only
            if (!empty($params['attributes'])) {

                //1.
                $context = $this->getProductSearchContext();

                //2. 
                $query = new ProductSearchQuery();
                $query->setIdCategory($params['id_category']); 
                $searchProvider = $this->getProductSearchProviderFromModules($query);

                //3.
                $encodedFacets = $this->generateQueryString($params['attributes']);
                $query
                    ->setEncodedFacets($encodedFacets)
                    ->setResultsPerPage($params['productsPerPage'])
                    ->setPage($params['pageNumber'])
                    ->setSortOrder(
                        new SortOrder(
                            'product',
                            $params['sortOrder']['field'],
                            $params['sortOrder']['direction']
                        )
                    )
                ;
                if (!empty($params['id_manufacturer'])) {
                    $query->setIdManufacturer($params['id_manufacturer']);
                }

            }
        }

        if (!empty($params['id_manufacturer'])) {
            $manufacturer = new Manufacturer($params['id_manufacturer']);

            $searchProvider = new ManufacturerProductSearchProvider(
                $this->context->getTranslator(),
                $manufacturer
            );

            $query->setIdManufacturer($manufacturer->id);
        }

        if (!empty($params['id_supplier'])) {
            $supplier = new Supplier($params['id_supplier']);

            $searchProvider = new SupplierProductSearchProvider(
                $this->context->getTranslator(),
                $supplier
            );

            $query->setIdSupplier($supplier->id);
        }

        if (!empty($params['prices-drop'])) {

            $searchProvider = new PricesDropProductSearchProvider(
                $this->context->getTranslator()
            );

            $query->setQueryType('prices-drop');
        }

        if (!empty($params['new-products'])) {

            $searchProvider = new NewProductsProductSearchProvider(
                $this->context->getTranslator()
            );

            $query->setQueryType('new-products');
        }

        if (!empty($params['best-sales'])) {

            $searchProvider = new BestSalesProductSearchProvider(
                $this->context->getTranslator()
            );

            $query
                ->setQueryType('best-sales')
                ->setSortOrder(new SortOrder('product','name','asc'));

        }

        if (!empty($params['searchstr'])) {

            $searchProvider = new SearchProductSearchProvider(
                $this->context->getTranslator()
            );

            $query->setSearchString($params['searchstr']);
        }

        if (isset($searchProvider)) {
            $result = $searchProvider->runQuery(
                $context,
                $query
            );

            return $result->getProducts();
        }

        return array();
    }


    public function getProductSearchProviderFromModules($query)
    {
        $providers = Hook::exec(
            'productSearchProvider',
            array('query' => $query),
            null,
            true
        );

        if (!is_array($providers)) {
            $providers = array();
        }

        foreach ($providers as $provider) {
            if ($provider instanceof ProductSearchProviderInterface) {
                return $provider;
            }
        }

        return;
    }

    public function getProductSearchContext()
    {
        return (new ProductSearchContext())
            ->setIdShop($this->context->shop->id)
            ->setIdLang($this->context->language->id)
            ->setIdCurrency($this->context->currency->id)
            ->setIdCustomer(
                $this->context->customer ?
                    $this->context->customer->id :
                    null
            )
        ;
    }

    public function generateQueryString($params)
    {
        $queryStr = '';

        if (is_array($params)) {
            foreach ($params as $label => $value) {
                $queryStr .= $label.'-'.implode('-', $value).'/';
            }
            $queryStr = rtrim($queryStr, '/');
        }
        return $queryStr;

    }

    public function assembler($products)
    {
        $this->context = Context::getContext();
        $products_for_template = array();
        $assembler = new ProductAssembler($this->context);

        $presenterFactory = new ProductPresenterFactory($this->context);
        $presentationSettings = $presenterFactory->getPresentationSettings();
        $presenter = new ProductListingPresenter(
            new ImageRetriever(
                $this->context->link
            ),
            $this->context->link,
            new PriceFormatter(),
            new ProductColorsRetriever(),
            $this->context->getTranslator()
        );
        
        foreach ($products as $rawProduct) {
            $assembledProducts = $presenter->present(
                $presentationSettings,
                $assembler->assembleProduct($rawProduct),
                $this->context->language
            );
            $products_for_template[] = $assembledProducts;
            //$products_for_template[$rawProduct['id_product']] = $this->optimizeProductObj($assembledProducts);
        }

        foreach ($products_for_template as $key => $product) {
            $products_for_template[$key]['amp_link'] = $this->context->link->getModuleLink('pk_amp', 'product', array('id_product' => $product['id_product']), true, $this->context->language->id, $this->context->shop->id, false);
        }

        return $products_for_template;

    }

    public function optimizeProductObj($product)
    {
        if (is_array($product)) {
            unset(
                $product['embedded_attributes'],
                $product['main_variants'],
                $product['add_to_cart_url'],
                $product['canonical_url'],
                $product['features'],
                $product['description'],
                $product['description_short'],
                $product['ecotax'],
                $product['id_supplier'],
                $product['id_tax_rules_group'],
                $product['date_add'],
                $product['date_upd'],
                $product['quantity_all_versions'],
                $product['customization_required']
            );
        }
        return $product;
    }

}