<?php
/**
* 2011-2019 Promokit
*
* @package   pk_amp
* @version   1.0
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2019 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
*/

require_once(_PS_MODULE_DIR_.'pk_amp/classes/Amp.php');

class Pk_AmpAddressModuleFrontController extends ModuleFrontController
{

  public $ajax = true;
  public $ssl = true;
  public $auth = false;
  public $guestAllowed = true;
  public $name = 'address';
  public $authRedirection = 'addresses';

  private $address_form;
  private $should_redirect = false;

  public function init()
  {
    parent::init();
    $this->address_form = $this->makeAddressForm();
    $this->context->smarty->assign('address_form', $this->address_form->getProxy());
  }
  
  public function initContent()
  {

    /*
    if (!$this->ajax && $this->should_redirect) {
      if (($back = Tools::getValue('back')) && Tools::urlBelongsToShop($back)) {
        $mod = Tools::getValue('mod');
        $this->redirectWithNotifications('index.php?controller=' . $back . ($mod ? '&back=' . $mod : ''));
      } else {
        $this->redirectWithNotifications('index.php?controller=addresses');
      }
    }
    */

    $ampClass = new Amp();
    $ampClass->injectCSS();
    $addressForm = $this->makeAddressForm();

    if (Tools::getIsset('id_address') && ($id_address = (int) Tools::getValue('id_address'))) {
        $addressForm->loadAddressById($id_address);
    }

    if (Tools::getIsset('id_country')) {
        $addressForm->fillWith(array('id_country' => Tools::getValue('id_country')));
    }

    ob_end_clean();

    $form = array(
        'address_form' => $this->render(
            'mobile/customer/_partials/address-form',
            $addressForm->getTemplateVariables()
        ),
    );
    
    $this->context->smarty->assign(array(
      'addressForm' => $form,
      'canonical' => $this->context->link->getPageLink($this->name),
      'amp' => $ampClass->getThemeVars(array('name' => $this->name))
    ));

    parent::initContent();
    $this->setTemplate('mobile/customer/'.$this->name, array('entity' => 'module', 'name' => 'pk_amp', 'controller' => 'addresss', 'id' => Tools::getValue('id_address')));
  }

  public function postProcess()
  {
    $c = $this->context;
    $c->smarty->assign('editing', false);
    $this->address_form->fillWith(Tools::getAllValues());

    if (Tools::isSubmit('submitAddress')) {

        if (!$this->address_form->submit()) {
            $this->errors[] = $this->trans('Please fix the error below.', array(), 'Shop.Notifications.Error');
        } else {
          if (Tools::getValue('id_address')) {
            $this->success[] = $this->trans('Address successfully updated!', array(), 'Shop.Notifications.Success');
            $link = $c->link->getModuleLink('pk_amp', 'address', array('id_address' => Tools::getValue('id_address')), true, $c->language->id, $c->shop->id);
          } else {
            $this->success[] = $this->trans('Address successfully added!', array(), 'Shop.Notifications.Success');
            $link = $c->link->getModuleLink('pk_amp', 'addresses', array(), true, $c->language->id, $c->shop->id);
          }
          $this->should_redirect = true;
        }

    } elseif (($id_address = (int)Tools::getValue('id_address'))) {
        $this->address_form->loadAddressById($id_address);

        if (Tools::getValue('delete')) {

          $ampClass = new Amp();
          $ok = $this->makeAddressPersister()->delete(
              new Address($id_address, $c->language->id),
              Tools::getValue('token')
          );

          if ($ok) {
            $ampClass->setHeaders(true);
              $this->success[] = $this->trans('Address successfully deleted!', array(), 'Shop.Notifications.Success');
              $this->should_redirect = true;
          } else {
            $ampClass->setHeaders(false);
              $this->errors[] = $this->trans('Could not delete address.', array(), 'Shop.Notifications.Error');
          }

          $link = $c->link->getModuleLink('pk_amp', 'addresses', array(), true, $c->language->id, $c->shop->id);

        } else {
            $c->smarty->assign('editing', true);
        }
    }

    $c->smarty->assign(array(
      'errors' => $this->errors,
      'success' => $this->success
    ));

    header("access-control-allow-credentials:true");
    header("access-control-allow-headers:Content-Type, Content-Length, Accept-Encoding, X-CSRF-Token");
    header("access-control-allow-methods:GET,POST");
    header("amp-access-control-allow-source-origin: https://".$_SERVER['HTTP_HOST']);
    header("access-control-allow-origin: https://".$_SERVER['HTTP_HOST']);
    header("AMP-Redirect-To:".$link);
    
  }

}