<?php
/**
* 2011-2019 Promokit
*
* @package   pk_amp
* @version   1.0
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2019 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
*/

require_once(_PS_MODULE_DIR_.'pk_amp/classes/Amp.php');

class Pk_AmpAddressesModuleFrontController extends ModuleFrontController
{
  public $ssl = true;
  public $auth = true;
  public $name = 'addresses';
  public $authRedirection = 'addresses';

  public function init()
  {
    parent::init();
    if (!Validate::isLoadedObject($this->context->customer)) {
      die($this->trans('The customer could not be found.', array(), 'Shop.Notifications.Error'));
    }
  }
  
  public function initContent()
  {
    $ampClass = new Amp();
    $ampClass->injectCSS();

    if (count($this->context->customer->getSimpleAddresses()) <= 0) {
      $link = '<a href="' . $this->context->link->getPageLink('address', true) . '">' . $this->trans('Add a new address', array(), 'Shop.Theme.Actions') . '</a>';
      $this->warning[] = $this->trans('No addresses are available. %s', array($link), 'Shop.Notifications.Success');
    }
    
    $this->context->smarty->assign(array(
      'canonical' => $this->context->link->getPageLink($this->name),
      'amp' => $ampClass->getThemeVars(array('name' => $this->name))
    ));

    parent::initContent();
    $this->setTemplate('mobile/customer/'.$this->name);
  }

}