<?php
/**
* 2011-2019 Promokit
*
* @package   pk_amp
* @version   1.0
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2019 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
*/

use PrestaShop\PrestaShop\Adapter\Cart\CartPresenter;
require_once (_PS_MODULE_DIR_.'pk_amp/classes/Amp.php');

class Pk_AmpAjaxCartModuleFrontController extends ModuleFrontController
{
    public $ssl = true;

    public function initContent()
    {
        parent::initContent();
        $this->errors = array();

        $ampClass = new Amp();
        $presenter = new CartPresenter();
        $ctx = $this->context;
        $ctx->updateCustomer($ctx->customer);
        $cartItems = null;
        $do = Tools::getValue('do');
        $prod_ID = (int)Tools::getValue('id_product');
        $prod_ID_attr = (int)Tools::getValue('id_product_attribute');
        $action = (string)Tools::getValue('act');

        if ($do === 'cartUpdate') {

            $qty = (Tools::getValue('qty') ? Tools::getValue('qty') : 1);

            $productRaw = new Product(
                $prod_ID, false, $ctx->language->id
            );

            if (Tools::getValue('cartPage')) {
                $cartQty = $ctx->cart->containsProduct($prod_ID, $prod_ID_attr);
                if ($cartQty['quantity'] > $qty) {
                    $action = 'down';
                    $qty = $cartQty['quantity'] - $qty;
                } else {
                    $action = 'up';
                    $qty = $qty - $cartQty['quantity'];
                }
            }

            $availalble = $productRaw->checkQty((int)$qty);

            if ($availalble) {

                $doResponse = $ctx->cart->updateQty(
                    (int)$qty,
                    $prod_ID,
                    $prod_ID_attr,
                    0,
                    $action
                );

                if (!$doResponse) {
                    $this->errors['cart'][] = $this->trans(
                        'Unable to add product to cart',array(),'Shop.Theme.Amp'
                    );
                }
            } else {
                $this->errors['cart'][] = $this->trans(
                    'There are no enough products in stock',array(),'Shop.Theme.Amp'
                );
            }
        }

        if ($do === 'deleteProduct') {
            $doResponse = $ctx->cart->deleteProduct(
                $prod_ID,
                $prod_ID_attr
            );

            if (!$doResponse) {
                $this->errors['cart'][] = $this->trans(
                    'Unable to remove product from cart',array(),'Shop.Theme.Amp'
                );
            }
        }

        if ($do === 'addDiscount') {
            if (CartRule::isFeatureActive()) {
                if (!($code = trim(Tools::getValue('discount_name')))) {
                    $this->errors['voucher'][] = $this->trans(
                        'You must enter a voucher code',array(),'Shop.Theme.Amp'
                    );
                } elseif (!Validate::isCleanHtml($code)) {
                    $this->errors['voucher'][] = $this->trans(
                        'The voucher code is invalid',array(),'Shop.Theme.Amp'
                    );
                } else {
                    if (($cartRule = new CartRule(CartRule::getIdByCode($code)))
                        && Validate::isLoadedObject($cartRule)
                    ) {
                        if ($error = $cartRule->checkValidity($ctx, false, true)) {
                            $this->errors['voucher'][] = $error;
                        } else {
                            $ctx->cart->addCartRule($cartRule->id);
                        }
                    } else {
                        $this->errors['voucher'][] = $this->trans(
                            'This voucher does not exist.',array(),'Shop.Theme.Amp'
                        );
                    }
                }
            }
        }

        if ($do === 'removeDiscount') {
            if (($id_rule = (int)Tools::getValue('id_rule')) && Validate::isUnsignedId($id_rule)) {
                $ctx->cart->removeCartRule($id_rule);
                CartRule::autoAddToCart($ctx);
            } else {
                $this->errors['voucher'][] = $this->trans(
                    'Unable to remove voucher',array(),'Shop.Theme.Amp'
                );
            }
        }

        if (!empty($this->errors['voucher']) || !empty($this->errors['cart'])) {
            $ampClass->setHeaders(false);
        } else {
            $ampClass->setHeaders(true);
        }

        $presented_cart = $presenter->present($ctx->cart);
        $productsInCart = $this->context->cart->getProducts();
        
        die(json_encode([
            'items' => $this->prepareProductsSection($productsInCart, $ctx),
            'info' => $this->prepareInfoSection($presented_cart),
            'vouchers' => $this->prepareVouchers($presented_cart),
            'price' => Tools::getValue('price'),
            'id_product_attribute' => (int)Tools::getValue('id_product_attribute'),
            'errors' => $this->errors,
            'products_count' => $presented_cart['products_count']
        ]));

    }

    public function prepareInfoSection($presented_cart)
    {
        $cart_info = array();
        $num = $presented_cart['products_count'];
        $cart_info['products'] = $cart_info['discount'] = $cart_info['shipping'] = $cart_info['tax'] = $cart_info['total'] = "–";

        if (($num > 0)) {
            $cart_info['total'] = $presented_cart['totals']['total']['value'];
        }

        if (isset($presented_cart['subtotals']['products']['value']) && ($num > 0)) {
            $cart_info['products'] = $presented_cart['subtotals']['products']['value'];
        }
        if (isset($presented_cart['subtotals']['discounts']['value']) && ($num > 0)) {
            $cart_info['discount'] = $presented_cart['subtotals']['discounts']['value'];
        }
        if (isset($presented_cart['subtotals']['shipping']['value']) && ($num > 0)) {
            $cart_info['shipping'] = $presented_cart['subtotals']['shipping']['value'];
        }
        if (isset($presented_cart['subtotals']['tax']['value']) && ($num > 0)) {
            $cart_info['tax'] = $presented_cart['subtotals']['tax']['value'];
        }
        //$cart_info['all'] = $presented_cart;
        //$cart_info['vouchers'] = $presented_cart['vouchers'];
        $cart_info['products_count'] = $num;

        return array($cart_info);
    }

    public function prepareProductsSection($productsInCart, $ctx)
    {
        $cartItems = null;
        if (!empty($productsInCart)) {
            foreach ($productsInCart as $key => $product) {
                $productsInCart[$key]['attr_str'] = (isset($product['attributes']) ? $product['attributes'] : '');
                $productsInCart[$key]['amp_link'] = $ctx->link->getModuleLink('pk_amp', 'product', array('id_product' => $product['id_product']), true, $ctx->language->id, $ctx->shop->id, false);
                $cover = Image::getCover($product['id_product']);
                $productsInCart[$key]['cover']['medium'] = Image::getSize(ImageType::getFormattedName('medium'));
                $productsInCart[$key]['cover']['medium']['url'] = $ctx->link->getImageLink($product['link_rewrite'], $cover['id_image']);
                $productsInCart[$key]['price'] = Tools::displayPrice($product['price'], $ctx->currency);
                $productsInCart[$key]['total'] = Tools::displayPrice($product['total'], $ctx->currency);
            }
        }

        if (!empty($productsInCart)) {
            $cartItems = $productsInCart;
        }
        return $cartItems;
    }

    public function prepareVouchers($presented_cart)
    {
        $vouchers = array();
        foreach ($presented_cart['vouchers']['added'] as $key => $voucher) {
            $vouchers[] = array(
                "name" => $voucher['name'],
                "reduction_formatted" => $voucher['reduction_formatted'],
                "id_cart_rule" => $voucher['id_cart_rule']
            );
        }

        return $vouchers;
    }

}