<?php
/**
* 2011-2019 Promokit
*
* @package   pk_amp
* @version   1.0
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2019 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
*/

use PrestaShop\PrestaShop\Adapter\ServiceLocator;
require_once (_PS_MODULE_DIR_.'pk_amp/classes/Amp.php');

class Pk_AmpAjaxCustomerModuleFrontController extends ModuleFrontController
{

	public function initContent()
	{
		$ctx = Context::getContext();
		$action = Tools::getValue('action');
		$response = array('messages' => array('error' => null, 'success' => null));
		$ampClass = new Amp();
		$crypto = ServiceLocator::get('\\PrestaShop\\PrestaShop\\Core\\Crypto\\Hashing');

		if ($action == 'identity') {

			if (Tools::getValue('id_gender')) {
				$ctx->customer->id_gender = Tools::getValue('id_gender');
			}
			if (Tools::getValue('firstname')) {
				$ctx->customer->firstname = Tools::getValue('firstname');
			}
			if (Tools::getValue('lastname')) {
				$ctx->customer->lastname = Tools::getValue('lastname');
			}
			if (Tools::getValue('email')) {
				$ctx->customer->email = Tools::getValue('email');
			}
			if (Tools::getValue('password')) {
				$ctx->customer->passwd = $crypto->hash(Tools::getValue('password'));
			}
			if (Tools::getValue('birthday')) {
				$ctx->customer->birthday = Tools::getValue('birthday');
			}
			if (Tools::getValue('newsletter')) {
				$ctx->customer->newsletter = Tools::getValue('newsletter');
			}
			if (Tools::getValue('optin')) {
				$ctx->customer->optin = Tools::getValue('optin');
			}

			$save = $ctx->customer->save();

      if ($save) {

				$ctx->cookie->update();
				$ctx->updateCustomer($ctx->customer);
				Hook::exec('actionCustomerAccountUpdate', [
	          'customer' => $ctx->customer,
	      ]);
	      $ampClass->setHeaders();
	      $response['messages']['success'] = 1;

			} else {

				$ampClass->setHeaders(false);
				$response['messages']['error'] = 1;

			}

		}

		die(json_encode($response));

	}
}