<?php
/**
* Promokit Amp
*
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2019 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
* @version   1.0.2
* @package   Promokit AMP
*/

require_once (_PS_MODULE_DIR_.'pk_amp/classes/Amp.php');
require_once(_PS_MODULE_DIR_.'pk_amp/classes/ampProductHelper.php');

class Pk_AmpAjaxFilterModuleFrontController extends ModuleFrontController
{
    public $ssl = true;

    /**
    * @see FrontController::initContent()
    */
    public function initContent()
    {
        $debug = true;
        $ampClass = new Amp();
        $ampClass->setHeaders();

        $products = array();
        $params = array();
        $params['pageNumber'] = Tools::getValue('moreItemsPageIndex');
        $params['attributes'] = Tools::getValue('attr');
        $params['id_category'] = Tools::getValue('id_category');
        $params['id_manufacturer'] = Tools::getValue('id_manufacturer');
        $params['id_supplier'] = Tools::getValue('id_supplier');
        $params['prices-drop'] = Tools::getValue('prices-drop');
        $params['new-products'] = Tools::getValue('new-products');
        $params['best-sales'] = Tools::getValue('best-sales');
        $params['searchstr'] = Tools::getValue('searchstr');
        $params['productsPerPage'] = (Tools::getValue('productsPerPage')) ? (int)Tools::getValue('productsPerPage') : (int)Configuration::get('PS_PRODUCTS_PER_PAGE');

        if ($debug) {
            $products['params'] = $params;
        }

        $products['hasMorePages'] = 1; 
        $products['static_token'] = Tools::getToken(false);
        $products['items'] = $this->getProducts($params);

        $productsOnPage = count($products['items']);

        if ($productsOnPage != $params['productsPerPage']) {
            $products['hasMorePages'] = 0;
        }
        $products['productsOnPage'] = $productsOnPage;
        $products['productsPerPage'] = $params['productsPerPage'];
        die(Tools::jsonEncode($products));

    }

    public function getProducts($params)
    {
        $ampProdAssembl = new ampProductHelper();
        $requestedProducts = $ampProdAssembl->makeQuery($params);     
        $products_for_template = $ampProdAssembl->assembler($requestedProducts);
        return $products_for_template;
    }

}