<?php
/**
* 2011-2019 Promokit
*
* @package   pk_amp
* @version   1.0
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2019 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
*/

require_once (_PS_MODULE_DIR_.'pk_amp/classes/Amp.php');
//require_once (_PS_MODULE_DIR_.'pk_amp/classes/ampRegister.php');

class Pk_AmpAjaxLoginModuleFrontController extends ModuleFrontController
{

	public function initContent()
	{
		$action = Tools::getValue('action');
		$response = array(
			'items' => array(
				'data' => null, 
				'messages' => array('error' => null, 'send' => null),
				'is_logged' => false
			)
		);

		if ($action == 'login') {

			Hook::exec('actionBeforeAuthentication');

			$customer = $this->context->customer;	
			$authentication = $customer->getByEmail(Tools::getValue('email'), Tools::getValue('password'));

			if (!$authentication or !$customer->id) {

          $response['items']['messages']['error'] = 'Authentication failed';

      } elseif (isset($authentication->active) && !$authentication->active) {

          $response['items']['messages']['error'] = 'Your account isn\'t available at this time, please contact us';

      } else {

      	$ampClass = new Amp();
    		$ampClass->setHeaders();

				$this->context->updateCustomer($customer);

        Hook::exec('actionAuthentication', ['customer' => $customer]);

        // Login information have changed, so we check if the cart rules still apply
        CartRule::autoRemoveFromCart($this->context);
        CartRule::autoAddToCart($this->context);

	      if (!empty($customer->firstname)) {
		      $response['items']['data']['firstname'] = $customer->firstname;
		      $response['items']['data']['lastname'] = $customer->lastname;
		      $response['items']['is_logged'] = $customer->isLogged(true);
		    }

		  }

			die(json_encode($response));

		} elseif ($action == 'logout') {

			$this->context->customer->mylogout();
			$response['items']['messages']['success'] = 'logout';
			$ampClass = new Amp();
    	$ampClass->setHeaders(true, Tools::getValue('redirect'));
    	//$response['url'] = $this->context->shop->getBaseURL(true, false).$_SERVER['REQUEST_URI'];
			die(json_encode($response));

		} elseif ($action == 'register') {

				Hook::exec('actionBeforeSubmitAccount');
				$customer = $this->context->customer;
				$context = Context::getContext();
				$customer->getByEmail(Tools::getValue('email'));

				if (!$customer->id) {

					$customer->firstname = Tools::getValue('firstname');
					$customer->lastname = Tools::getValue('lastname');
					$customer->email = Tools::getValue('email');
					$password = Tools::passwdGen();
					$customer->passwd = md5(pSQL(_COOKIE_KEY_.$password));

					//$customer->id_gender = $id_gender;
					//$customer->birthday = $newDate;
					$customer->is_guest = 0;
					$customer->active = 1;
					$response['items']['messages']['add'] = $customer->add();

					$context = Context::getContext();
					$context->customer = $customer;
					$context->cookie->id_customer = (int)$customer->id;
					$context->cookie->customer_lastname = $customer->lastname;
					$context->cookie->customer_firstname = $customer->firstname;
					$context->cookie->passwd = $customer->passwd;
					$context->cookie->logged = 1;
					$customer->logged = 1;
					$context->cookie->email = $customer->email;
					$context->cookie->is_guest = $customer->is_guest;
					$context->cart->secure_key = $customer->secure_key;
					$context->cookie->update();
					$context->cart->update();

					if ($response['items']['messages']['add']) {
						$ampClass = new Amp();
	    			$ampClass->setHeaders();
					}

					if (!empty($customer->firstname)) {
						$response['items']['data']['firstname'] = $customer->firstname;
			      $response['items']['data']['lastname'] = $customer->lastname;
			    }
					$response['items']['messages']['send'] = Mail::Send(
						$this->context->language->id,
						'account-password',
						Mail::l('Welcome!'),
						array(
							'{firstname}' => $customer->firstname,
							'{lastname}' => $customer->lastname,
							'{email}' => $customer->email,
							'{password}' => $password
						),
						$customer->email,
						$customer->firstname.' '.$customer->lastname
					);
					$response['items']['is_logged'] = $customer->isLogged(true);

				} else {
					$response['items']['messages']['error'] = 'Already registered';
				}

				header("Content-Type: application/json");
				die(json_encode($response));

		} else {
			header("Content-Type: application/json");
			die(json_encode($response));
		}
	}
}