<?php
/**
* 2011-2019 Promokit
*
* @package   pk_amp
* @version   1.0
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2019 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
*/

require_once (_PS_MODULE_DIR_.'pk_amp/classes/Amp.php');
require_once (_PS_CLASS_DIR_.'checkout/CheckoutProcess.php');
use PrestaShop\PrestaShop\Adapter\Presenter\Order\OrderPresenter;
use PrestaShop\PrestaShop\Core\Foundation\Templating\RenderableProxy;
use PrestaShop\PrestaShop\Adapter\Product\PriceFormatter;

class Pk_AmpAjaxOrderModuleFrontController extends ModuleFrontController
{
    public $ssl = true;
    protected $checkoutProcess;
    protected $cartChecksum;

    public function __construct()
    {
        parent::__construct();
        $this->context = Context::getContext();
    }

    public function init()
    {
        parent::init();
        $this->cartChecksum = new CartChecksum(new AddressChecksum());
    }

    public function initContent()
    {
        if (Configuration::isCatalogMode()) {
            Tools::redirect('index.php');
        }

        $ampClass = new Amp();
        $this->bootstrap();

        $this->checkoutProcess->handleRequest(
            Tools::getAllValues()
        );

        $presentedCart = $this->cart_presenter->present($this->context->cart);

        if (count($presentedCart['products']) <= 0 || $presentedCart['minimalPurchaseRequired']) {
            // if there is no product in current cart, redirect to cart page
            $cartLink = $this->context->link->getPageLink('cart');
            Tools::redirect($cartLink);
        }

        $product = $this->context->cart->checkQuantities(true);
        if (is_array($product)) {
            // if there is an issue with product quantities, redirect to cart page
            $cartLink = $this->context->link->getPageLink('cart', null, null, array('action' => 'show'));
            Tools::redirect($cartLink);
        }

        $this->checkoutProcess
            ->setNextStepReachable()
            ->markCurrentStep()
            ->invalidateAllStepsAfterCurrent();

        $this->saveDataToPersist($this->checkoutProcess);

        parent::initContent();

        if ( (Tools::getValue('submitReorder') == 1) && $id_order = (int) Tools::getValue('id_order')) {
            $oldCart = new Cart(Order::getCartIdStatic($id_order, $this->context->customer->id));
            $duplication = $oldCart->duplicate();
            if (!$duplication || !Validate::isLoadedObject($duplication['cart'])) {
                $this->errors[] = $this->trans('Sorry. We cannot renew your order.', array(), 'Shop.Notifications.Error');
            } elseif (!$duplication['success']) {
                $this->errors[] = $this->trans(
                    'Some items are no longer available, and we are unable to renew your order.', array(), 'Shop.Notifications.Error'
                );
            } else {
                $this->context->cookie->id_cart = $duplication['cart']->id;
                $context = $this->context;
                $context->cart = $duplication['cart'];
                CartRule::autoAddToCart($context);
                $this->context->cookie->write();
                //Tools::redirect('index.php?controller=order');
            }
        }


        if (Tools::getValue('submitMessage') == 1) {
            $idOrder = (int)Tools::getValue('id_order');
            $msgText = Tools::getValue('msgText');

            if (!$idOrder || !Validate::isUnsignedId($idOrder)) {
                $this->errors[] = $this->trans('The order is no longer valid.', array(), 'Shop.Notifications.Error');
            } elseif (empty($msgText)) {
                $this->errors[] = $this->trans('The message cannot be blank.', array(), 'Shop.Notifications.Error');
            } elseif (!Validate::isMessage($msgText)) {
                $this->errors[] = $this->trans('This message is invalid (HTML is not allowed).', array(), 'Shop.Notifications.Error');
            }

            
            if (!count($this->errors)) {
            
                $order = new Order($idOrder);
                if (Validate::isLoadedObject($order) && $order->id_customer == $this->context->customer->id) {

                    //check if a thread already exist
                    $id_customer_thread = CustomerThread::getIdCustomerThreadByEmailAndIdOrder($this->context->customer->email, $order->id);
                    $id_product = (int) Tools::getValue('id_product');
                    $cm = new CustomerMessage();
                    if (!$id_customer_thread) {
                        $ct = new CustomerThread();
                        $ct->id_contact = 0;
                        $ct->id_customer = (int) $order->id_customer;
                        $ct->id_shop = (int) $this->context->shop->id;
                        if ($id_product && $order->orderContainProduct($id_product)) {
                            $ct->id_product = $id_product;
                        }
                        $ct->id_order = (int) $order->id;
                        $ct->id_lang = (int) $this->context->language->id;
                        $ct->email = $this->context->customer->email;
                        $ct->status = 'open';
                        $ct->token = Tools::passwdGen(12);
                        $ct->add();
                    } else {
                        $ct = new CustomerThread((int) $id_customer_thread);
                        $ct->status = 'open';
                        $ct->update();
                    }

                    $cm->id_customer_thread = $ct->id;
                    $cm->message = $msgText;
                    $client_ip_address = Tools::getRemoteAddr();
                    $cm->ip_address = (int) ip2long($client_ip_address);
                    $cm->add();
                    
                    if (!Configuration::get('PS_MAIL_EMAIL_MESSAGE')) {
                        $to = strval(Configuration::get('PS_SHOP_EMAIL'));
                    } else {
                        $to = new Contact((int) Configuration::get('PS_MAIL_EMAIL_MESSAGE'));
                        $to = strval($to->email);
                    }
                    $toName = strval(Configuration::get('PS_SHOP_NAME'));
                    $customer = $this->context->customer;

                    $product = new Product($id_product);
                    $product_name = '';
                    if (Validate::isLoadedObject($product) && isset($product->name[(int) $this->context->language->id])) {
                        $product_name = $product->name[(int) $this->context->language->id];
                    }

                    if (Validate::isLoadedObject($customer)) {
                        Mail::Send(
                            $this->context->language->id,
                            'order_customer_comment',
                            $this->trans(
                                'Message from a customer',
                                array(),
                                'Emails.Subject'
                            ),
                            array(
                                '{lastname}' => $customer->lastname,
                                '{firstname}' => $customer->firstname,
                                '{email}' => $customer->email,
                                '{id_order}' => (int) $order->id,
                                '{order_name}' => $order->getUniqReference(),
                                '{message}' => Tools::nl2br($msgText),
                                '{product_name}' => $product_name,
                            ),
                            $to,
                            $toName,
                            strval(Configuration::get('PS_SHOP_EMAIL')),
                            $customer->firstname . ' ' . $customer->lastname,
                            null,
                            null,
                            _PS_MAIL_DIR_,
                            false,
                            null,
                            null,
                            $customer->email
                        );
                    }
                    $ampClass->setHeaders();
                    die(json_encode(array('success' => $this->trans('Your message has been sent to our staff', array(), 'Shop.Notifications.Error'))));
                } else {
                    $ampClass->setHeaders(false);
                    die(json_encode(array('errors' => $this->trans('Wrong Order ID', array(), 'Shop.Notifications.Error'))));
                }
            }
            $ampClass->setHeaders(false);
            die(json_encode(array('errors' => $this->errors)));
        }
        // end submitMessage

        if (Tools::getValue('confirm-addresses') == 1) {

            $addressForm = $this->makeAddressForm();

            if (Tools::getIsset('id_address') && ($id_address = (int)Tools::getValue('id_address'))) {
                $addressForm->loadAddressById($id_address);
            }

            if (Tools::getIsset('id_country')) {
                $addressForm->fillWith(array('id_country' => Tools::getValue('id_country')));
            }
            
            $stepTemplateParameters = array();
            
            foreach ($this->checkoutProcess->getSteps() as $step) {
                if ($step instanceof CheckoutAddressesStep) {
                    $stepTemplateParameters = $step->getTemplateParameters();
                }
            }

            $templateParams = array_merge(
                $addressForm->getTemplateVariables(),
                $stepTemplateParameters,
                array('type' => 'delivery')
            );
            
            ob_end_clean();

            $link = $this->context->link->getModuleLink('pk_amp', 'checkout', array(), true, $this->context->language->id, $this->context->shop->id);

            header("access-control-allow-credentials:true");
            header("access-control-allow-headers:Content-Type, Content-Length, Accept-Encoding, X-CSRF-Token");
            header("access-control-allow-methods:GET,POST");
            header("amp-access-control-allow-source-origin: https://".$_SERVER['HTTP_HOST']);
            header("access-control-allow-origin: https://".$_SERVER['HTTP_HOST']);
            header("AMP-Redirect-To:".$link);

        }

        if (Tools::getValue('confirmDeliveryOption') == 1) {

            $cart = $this->cart_presenter->present(
                $this->context->cart
            );

            $this->restorePersistedData($this->checkoutProcess);
            $this->checkoutProcess->handleRequest(
                Tools::getAllValues()
            );

            $presentedCart = $this->cart_presenter->present($this->context->cart);

            if (count($presentedCart['products']) <= 0 || $presentedCart['minimalPurchaseRequired']) {
                Tools::redirect('index.php?controller=cart');
            }

            $this->checkoutProcess->setNextStepReachable();
            $this->checkoutProcess->markCurrentStep();
            $this->checkoutProcess->invalidateAllStepsAfterCurrent();        

            $this->saveDataToPersist($this->checkoutProcess);

            if (!$this->checkoutProcess->hasErrors()) {
                if ($_SERVER['REQUEST_METHOD'] !== 'GET' && !$this->ajax) {
                    return $this->redirectWithNotifications(
                        $this->checkoutProcess->getCheckoutSession()->getCheckoutURL()
                    );
                }
            }

            $cp = new RenderableProxy($this->checkoutProcess);
        
            $this->context->smarty->assign(array(
                'checkout_process' => $cp
            ));

            ob_end_clean();

            $link = $this->context->link->getModuleLink('pk_amp', 'checkout', array(), true, $this->context->language->id, $this->context->shop->id);

            header("access-control-allow-credentials:true");
            header("access-control-allow-headers:Content-Type, Content-Length, Accept-Encoding, X-CSRF-Token");
            header("access-control-allow-methods:GET,POST");
            header("amp-access-control-allow-source-origin: https://".$_SERVER['HTTP_HOST']);
            header("access-control-allow-origin: https://".$_SERVER['HTTP_HOST']);
            header("AMP-Redirect-To:".$link);

        }
    }

    protected function getCheckoutSession()
    {
        $deliveryOptionsFinder = new DeliveryOptionsFinder(
            $this->context,
            $this->getTranslator(),
            $this->objectPresenter,
            new PriceFormatter()
        );

        $session = new CheckoutSession(
            $this->context,
            $deliveryOptionsFinder
        );

        return $session;
    }

    private function saveDataToPersist(CheckoutProcess $process)
    {
        $data = $process->getDataToPersist();
        $data['checksum'] = $this->cartChecksum->generateChecksum($this->context->cart);

        Db::getInstance()->execute(
            'UPDATE '._DB_PREFIX_.'cart SET checkout_session_data = "'.pSQL(json_encode($data)).'"
                WHERE id_cart = '.(int) $this->context->cart->id
        );
    }

    private function restorePersistedData(CheckoutProcess $process)
    {
        $rawData = Db::getInstance()->getValue(
            'SELECT checkout_session_data FROM '._DB_PREFIX_.'cart WHERE id_cart = '.(int) $this->context->cart->id
        );
        $data = json_decode($rawData, true);
        if (!is_array($data)) {
            $data = [];
        }

        $checksum = $this->cartChecksum->generateChecksum($this->context->cart);
        if (isset($data['checksum']) && $data['checksum'] === $checksum) {
            $process->restorePersistedData($data);
        }
    }

    public function bootstrap()
    {
        $translator = $this->getTranslator();

        $session = $this->getCheckoutSession();

        $this->checkoutProcess = new CheckoutProcess(
            $this->context,
            $session
        );

        $this->checkoutProcess
            ->addStep(new CheckoutPersonalInformationStep(
                $this->context,
                $translator,
                $this->makeLoginForm(),
                $this->makeCustomerForm()
            ))
            ->addStep(new CheckoutAddressesStep(
                $this->context,
                $translator,
                $this->makeAddressForm()
            ));

        if (!$this->context->cart->isVirtualCart()) {
            $checkoutDeliveryStep = new CheckoutDeliveryStep(
                $this->context,
                $translator
            );

            $checkoutDeliveryStep
                ->setRecyclablePackAllowed((bool) Configuration::get('PS_RECYCLABLE_PACK'))
                ->setGiftAllowed((bool) Configuration::get('PS_GIFT_WRAPPING'))
                ->setIncludeTaxes(
                    !Product::getTaxCalculationMethod((int) $this->context->cart->id_customer)
                    && (int) Configuration::get('PS_TAX')
                )
                ->setDisplayTaxesLabel((Configuration::get('PS_TAX') && !Configuration::get('AEUC_LABEL_TAX_INC_EXC')))
                ->setGiftCost(
                    $this->context->cart->getGiftWrappingPrice(
                        $checkoutDeliveryStep->getIncludeTaxes()
                    )
                );

            $this->checkoutProcess->addStep($checkoutDeliveryStep);
        }

        $this->checkoutProcess
            ->addStep(new CheckoutPaymentStep(
                $this->context,
                $translator,
                new PaymentOptionsFinder(),
                new ConditionsToApproveFinder(
                    $this->context,
                    $translator
                )
            ))
        ;
    }

    public function ajaxProcessUpdateAddress()
    {
        $ampClass = new Amp();
        $ampClass->setHeaders(false);
        die(Tools::jsonEncode(array('method' => 'ajaxProcessUpdateAddress')));
    }
}