<?php
/**
* 2011-2019 Promokit
*
* @package   pk_amp
* @version   1.0
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2019 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
*/

require_once(_PS_MODULE_DIR_.'pk_amp/controllers/front/ampProductController.php');
require_once(_PS_MODULE_DIR_.'pk_amp/classes/ampProductHelper.php');
require_once(_PS_MODULE_DIR_.'pk_amp/classes/Amp.php');

class Pk_AmpAjaxProductModuleFrontController extends ModuleFrontController
{
    public $ssl = true;

    public function initContent()
    {
        $ampClass = new Amp();
        $ampClass->setHeaders();
        $ctx = $this->context;
        $id_product_attribute = null;
        $combinations = $images = array();
        $apc = new Pk_AmpProductController();
        
        if (Tools::getIsset('group')) {
            $id_product = (int)Tools::getValue('id_product');
            $id_product_attribute = (int)Product::getIdProductAttributesByIdAttributes(
                $id_product,
                Tools::getValue('group')
            );

            $productRaw = new Product(
                $id_product, false, $ctx->language->id
            );
            //$ampProdAssembl = new ampProductHelper();
            //$products_for_template = $ampProdAssembl->assembler($productRaw);
            //$combinations = $productRaw->getAttributeCombinationsById($id_product_attribute, $ctx->language->id);
            $price = $productRaw->getPrice(Configuration::get('PS_TAX') && !Configuration::get('AEUC_LABEL_TAX_INC_EXC'), $id_product_attribute);
            $regular_price_row = $productRaw->getPriceStatic($id_product, true, $id_product_attribute, 2, null, false, false);
            $formattedPrice = Tools::displayPrice($price, $ctx->currency);
            $regular_price = Tools::displayPrice($regular_price_row, $ctx->currency);
            $quantity = Product::getQuantity((int)$id_product, $id_product_attribute, null, $ctx->cart);
            //$convertedPrice = $productRaw->convertAndFormatPrice((int)Tools::getValue('id_product'));
        }

        if (Tools::getValue('submitCustomizedData') == 1) {
            // If cart has not been saved, we need to do it so that customization fields can have an id_cart
            // We check that the cookie exists first to avoid ghost carts
            if (!$ctx->cart->id && isset($_COOKIE[$ctx->cookie->getName()])) {
                $ctx->cart->add();
                $ctx->cookie->id_cart = (int) $ctx->cart->id;
            }
            $productRaw = new Product(
                (int)Tools::getValue('id_product'), false, $ctx->language->id
            );
            $apc->pictureUpload();
            $apc->textRecord();

            $ampClass->setHeaders(true, Tools::getValue('current_url'));
        }
        if (Tools::getIsset('deletePicture')) {
            if (!$ctx->cart->deleteCustomizationToProduct(Tools::getValue('id_product'), Tools::getValue('deletePicture'))) {
                $this->errors[] = $this->trans('An error occurred while deleting the selected picture.', array(), 'Shop.Notifications.Error');
            }
        }
        
        //$prices = $apc->ampAssignPriceAndTax();

        die(json_encode(array(
            'id_product_attribute' => $id_product_attribute,
            'price' => $formattedPrice,
            'regular_price' => $regular_price,
            'quantity' => $quantity
        )));

    }

}