<?php
/**
* 2011-2019 Promokit
*
* @package   pk_amp
* @version   1.0
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2019 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
*/

use PrestaShop\PrestaShop\Core\Product\Search\ProductSearchQuery;
use PrestaShop\PrestaShop\Core\Product\Search\SortOrder;
use PrestaShop\PrestaShop\Adapter\Search\SearchProductSearchProvider; 
use PrestaShop\PrestaShop\Core\Product\Search\ProductSearchContext;
require_once (_PS_MODULE_DIR_.'pk_amp/classes/Amp.php');

class Pk_AmpAjaxSearchModuleFrontController extends ModuleFrontController
{
    public $ssl = true;

    /**
    * @see FrontController::initContent()
    */
    public function initContent()
    {
        $ampClass = new Amp();
        $ampClass->setHeaders();

        $productsList = $pList = array();
        $query = new ProductSearchQuery();
        $link = new Link();

        $globContext = Context::getContext();
        $context = new ProductSearchContext($globContext);
        $searchProvider = new SearchProductSearchProvider($globContext->getTranslator());

        $qName = 'searchstring';
        $q = Tools::getValue($qName);

        $sortOrder = (
            !empty(Tools::getValue('sortOrder')) ? Tools::getValue('sortOrder') : 'position.asc'
        );
        $sortOrder = explode('.', $sortOrder);

        $query
            ->setSortOrder(new SortOrder('product', $sortOrder[0], $sortOrder[1]))
            ->setSearchString($q)
            ->setResultsPerPage(6)
            ->setPage(1);

        $result = $searchProvider->runQuery(
            $context,
            $query
        );

        $productsListRaw = $result->getProducts();

        if (!empty($productsListRaw)) {
          foreach ($productsListRaw as $k => $product) {

            $pList[$k]['id_product'] = $product['id_product'];
            $pList[$k]['price'] = Tools::displayPrice(Product::getPriceStatic((int)$product['id_product']));
            $pList[$k]['link_rewrite'] = $product['link_rewrite'];
            $pList[$k]['name'] = $product['name'];
            $pList[$k]['link'] = $globContext->link->getModuleLink('pk_amp', 'product', array('id_product' => (int)$product['id_product']), true, $globContext->language->id, $globContext->shop->id, false);
            $pList[$k]['image'] = 'no-cover';

            $cover = Product::getCover($product['id_product']);
            if ($cover) {
                $pList[$k]['image'] = Tools::getShopProtocol().$link->getImageLink($product['link_rewrite'], $cover['id_image'], 'small_default');
            }

          }
          $productsList['emptyAndInitialTemplateJson']['results'] = $pList;
        }

        $productsList['emptyAndInitialTemplateJson']['query'] = $q;
        $productsList['endpoint'] = $link->getModuleLink('pk_amp', 'ajaxSearch').'?'.$qName.'=';
        
        ob_end_clean();
        die(json_encode($productsList));
        
    }

}