<?php
/**
* 2011-2019 Promokit
*
* @package   pk_amp
* @version   1.0
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2019 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
*/

require_once(_PS_MODULE_DIR_.'pk_amp/classes/Amp.php');
use PrestaShop\PrestaShop\Adapter\Cart\CartPresenter;

class Pk_AmpCartModuleFrontController extends ModuleFrontController
{
  public $name = 'cart';
  public $checkoutWarning = false;
  
  public function initContent()
  {
    $ampClass = new Amp();
    $ampClass->injectCSS(array('cart'));
    
    $this->context->smarty->assign(array(
      'canonical' => $this->context->link->getPageLink($this->name),
      'amp' => $ampClass->getThemeVars(array('name' => $this->name))
    ));

    parent::initContent();
    $this->setTemplate('mobile/checkout/'.$this->name);
  }

  public function cartState()
  {
    $productsInCart = $this->context->cart->getProducts();
    if (!empty($productsInCart)) {
      foreach ($productsInCart as $key => $product) {
        $productsInCart[$key]['attr_str'] = (isset($product['attributes']) ? $product['attributes'] : '');
        $productsInCart[$key]['amp_link'] = $this->context->link->getModuleLink('pk_amp', 'product', array('id_product' => $product['id_product']), true, $this->context->language->id, $this->context->shop->id, false);
        
      }
    }
    $state = json_encode(array(
      'items' => $productsInCart,
      'info' => $this->prepareInfoSection(),
      'vouchers' => $this->prepareVouchers(),
      'price' => Tools::getValue('price'),
      'id_product_attribute' => (int)Tools::getValue('id_product_attribute'),
      'error' => array()
    ));

    return $state;
  }

  public function prepareInfoSection()
  {
    $cart_info = array();
    $num = 0;
    $cart_info['products'] = $cart_info['discount'] = $cart_info['shipping'] = $cart_info['tax'] = $cart_info['total'] = "–";

    if (($num > 0)) {
        $cart_info['total'] = $presented_cart['totals']['total']['value'];
    }

    if (isset($presented_cart['subtotals']['products']['value']) && ($num > 0)) {
        $cart_info['products'] = $presented_cart['subtotals']['products']['value'];
    }
    if (isset($presented_cart['subtotals']['discounts']['value']) && ($num > 0)) {
        $cart_info['discount'] = $presented_cart['subtotals']['discounts']['value'];
    }
    if (isset($presented_cart['subtotals']['shipping']['value']) && ($num > 0)) {
        $cart_info['shipping'] = $presented_cart['subtotals']['shipping']['value'];
    }
    if (isset($presented_cart['subtotals']['tax']['value']) && ($num > 0)) {
        $cart_info['tax'] = $presented_cart['subtotals']['tax']['value'];
    }
    //$cart_info['all'] = $presented_cart;
    //$cart_info['vouchers'] = $presented_cart['vouchers'];
    $cart_info['products_count'] = $num;

    return array($cart_info);
  }

  public function prepareVouchers()
  {
      $vouchers = array();
      if (!empty($presented_cart['vouchers']['added'])) {
          foreach ($presented_cart['vouchers']['added'] as $key => $voucher) {
              $vouchers[] = array(
                  "name" => $voucher['name'],
                  "reduction_formatted" => $voucher['reduction_formatted'],
                  "id_cart_rule" => $voucher['id_cart_rule']
              );
          }
      }

      return $vouchers;
  }

  public function setMedia($isNewTheme = false)
  {
      return false;
  }
  public function getTemplateVarProduct()
  {
    $product = array();
    $product['attributes'] = array();
    $product['name'] = null;
    $product['id_product'] = null;
    $product['price_amount'] = null;
    return $product;
  }
}