<?php
/**
* Promokit Amp
*
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2019 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
* @version   1.0.2
* @package   Promokit AMP
*/

use PrestaShop\PrestaShop\Core\Product\Search\ProductSearchContext;
use PrestaShop\PrestaShop\Core\Product\Search\ProductSearchQuery;
use PrestaShop\PrestaShop\Adapter\Category\CategoryProductSearchProvider;
use PrestaShop\PrestaShop\Adapter\Product\PriceFormatter;
use PrestaShop\PrestaShop\Core\Product\ProductListingPresenter;
use PrestaShop\PrestaShop\Adapter\Product\ProductColorsRetriever;
use PrestaShop\PrestaShop\Core\Product\Search\SortOrder;
use PrestaShop\PrestaShop\Adapter\Image\ImageRetriever;
require_once(_PS_MODULE_DIR_.'pk_amp/classes/Amp.php');

class Pk_AmpCategoryModuleFrontController extends ModuleFrontController
{
    /**
     * @throws PrestaShopDatabaseException
     * @throws PrestaShopException
     */
    public function initContent()
    { 
        $idLang = $this->context->language->id;
        $link = $this->context->link;
        $idShop = $this->context->shop->id;
        $idCategory = Tools::getValue('id_category');
        $page = Tools::getValue('p', 1);

        $this->category = new Category($idCategory, $idLang, $idShop);

        if (!Validate::isLoadedObject($this->category)) {
            Controller::getController('PageNotFoundController')->run();
        }

        $searchProvider = new CategoryProductSearchProvider(
            $this->context->getTranslator(),
            $this->category
        );

        $ProductSearchContext = new ProductSearchContext($this->context);
        
        $resultsPerPage = (int)Tools::getValue('resultsPerPage');
        if ($resultsPerPage <= 0 || $resultsPerPage > 36) {
            $resultsPerPage = Configuration::get('PS_PRODUCTS_PER_PAGE');
        }

        $query = new ProductSearchQuery();
        $query
            ->setResultsPerPage($resultsPerPage)
            ->setPage(1)
            ->setSortOrder(
                new SortOrder(
                    'product',
                    Tools::getProductsOrder('by'),
                    Tools::getProductsOrder('way')
                )
            )
        ;

        $result = $searchProvider->runQuery(
            $ProductSearchContext,
            $query
        );
        
        $assembler = new ProductAssembler($this->context);

        $presenterFactory = new ProductPresenterFactory($this->context);
        $presentationSettings = $presenterFactory->getPresentationSettings();
        $presenter = new ProductListingPresenter(
            new ImageRetriever(
                $this->context->link
            ),
            $this->context->link,
            new PriceFormatter(),
            new ProductColorsRetriever(),
            $this->context->getTranslator()
        );
        
        $products_for_template = array();
        
        foreach ($result->getProducts() as $rawProduct) {
            $products_for_template[] = $presenter->present(
                $presentationSettings,
                $assembler->assembleProduct($rawProduct),
                $this->context->language
            );
        }
        foreach ($products_for_template as $key => $product) {
            $products_for_template[$key]['amp_link'] = $link->getModuleLink('pk_amp', 'product', array('id_product' => $product['id_product']), true, $idLang, $idShop, false);
        }

        $this->cat_products = $products_for_template;

        $filterMdl = 'ps_facetedsearch';
        if (Module::isInstalled($filterMdl) && Module::isEnabled($filterMdl)) {
            require_once _PS_MODULE_DIR_.$filterMdl.'/src/Ps_FacetedsearchProductSearchProvider.php';
            $mInstance = Module::getInstanceByName($filterMdl);
            $ProductSearchProvider = new Ps_FacetedsearchProductSearchProvider($mInstance);
            $ProductSearchResultsRaw = $ProductSearchProvider->runQuery($ProductSearchContext, $query);
            $ProductSearchResults = $this->recursive_cast_to_array($ProductSearchResultsRaw);
            $this->context->smarty->assign('facets', $ProductSearchResults['facetCollection']['facets']);
        }

        $this->p = $page;
        $list = array(0 => 'name', 1 => 'price', 2 => 'date_add', 3 => 'date_upd', 4 => 'position', 5 => 'manufacturer_name', 6 => 'quantity', 7 => 'reference');
        $this->orderBy = $list[Configuration::get('PS_PRODUCTS_ORDER_BY')];
        if (Configuration::get('PS_PRODUCTS_ORDER_WAY') == 0) {
            $this->orderWay = 'asc';
        } else {
            $this->orderWay = 'desc';
        }
        $this->n = Configuration::get('PS_PRODUCTS_PER_PAGE');

        $this->nbProducts = $this->category->getProducts(null, null, null, $this->orderBy, $this->orderWay, true);
      
        $smartyVars = array();
        $smartyVars['idLang'] = $idLang;
        $smartyVars['idShop'] = $idShop;
        $smartyVars['link'] = $link;
        $smartyVars['noOfPages'] = $this->nbProducts/$this->n;
        $smartyVars['currentPage'] = $this->p;
        $smartyVars['contactUrl'] = 'contact';
        $smartyVars['id_category'] = $idCategory;
        $smartyVars['static_token'] = Tools::getToken(false);
        $smartyVars['module_dir'] = _MODULE_DIR_;
        $smartyVars['category'] = $this->category;
        $smartyVars['nbProducts'] = $this->nbProducts;
        $smartyVars['catProducts'] = $this->cat_products;
        $smartyVars['orderBy'] =  $this->orderBy;
        $smartyVars['orderWay'] =  $this->orderWay;
        $smartyVars['categoryLink'] = $link->getCategoryLink($this->category, null, $idLang, null, $idShop);
        if (Configuration::get('PS_REWRITING_SETTINGS')) {
            $smartyVars['categoryLink'] .= '?p='.$this->p;
        } else {
            $smartyVars['categoryLink'] .= '&p='.$this->p;
        }
        $smartyVars['subcategories'] = $this->getTemplateVarSubCategories();

        $smartyVars['homePageLink'] = $link->getPageLink('index', true, $idLang, null, false, $smartyVars['idShop']);
        $this->context->smarty->assign($smartyVars);
        $this->context->smarty->assign('canonical', $smartyVars['categoryLink']);

        $ampClass = new Amp();
        $ampClass->injectCSS(array('category'));

        $metaData = array(
            'name' => 'category',
            'id' => $idCategory,
            'title' => false
        );
        
        $this->context->smarty->assign('amp', $ampClass->getThemeVars($metaData));

        $this->setTemplate('mobile/catalog/listing/category');

        parent::initContent();
    }

    public function recursive_cast_to_array($o) {
        if (is_object($o)) {
            $a = (array)$o;
        } else {
            $a = $o;
        }

        foreach ($a as &$value) {
            if (is_object($value)) {
                $value = $this->recursive_cast_to_array($value);
            } elseif (is_array($value)) {
                $value = $this->recursive_cast_to_array($value);
            }
        }

        $a = $this->clearKeys($a);

        return $a;
    }

    public function clearKeys($arr) {
        $keys = array_keys($arr);
        foreach ($keys as $key => $value) {
            $patterns = array(
                'PrestaShop\PrestaShop\Core\Product\Search\ProductSearchResult',
                'PrestaShop\PrestaShop\Core\Product\Search\FacetCollection',
                'PrestaShop\PrestaShop\Core\Product\Search\Facet',
                'PrestaShop\PrestaShop\Core\Product\Search\Filter'
            );
            $clearKey = str_replace($patterns, '', $value);
            if ($clearKey == $value) {
                $keys[$key] = $value;
            } else {
                $keys[$key] = Tools::substr($clearKey, 2);
            }
        }
        $clear = array_combine($keys, $arr);
        return $clear;
    }

    protected function getTemplateVarSubCategories()
    {
        return array_map(function (array $category) {
            $object = new Category(
                $category['id_category'],
                $this->context->language->id
            );

            $category['image'] = $this->getImage(
                $object,
                $object->id_image
            );

            $category['url'] = $this->context->link->getCategoryLink(
                $category['id_category'],
                $category['link_rewrite']
            );
            $category['amp_url'] = $this->context->link->getModuleLink('pk_amp', 'category', array('id_category' => $category['id_category']), true, $this->context->language->id, $this->context->shop->id, false);

            return $category;
        }, $this->category->getSubCategories($this->context->language->id));
    }

    protected function getImage($object, $id_image)
    {
        $retriever = new ImageRetriever(
            $this->context->link
        );

        return $retriever->getImage($object, $id_image);
    }

}