<?php
/**
* 2011-2019 Promokit
*
* @package   pk_amp
* @version   1.0
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2019 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
*/

require_once(_PS_MODULE_DIR_.'pk_amp/classes/Amp.php');

class Pk_AmpCmsModuleFrontController extends ModuleFrontController
{
    public function initContent()
    { 
        $ctx = $this->context;
        $idLang = $ctx->language->id;
        $link = $ctx->link;
        $idShop = $ctx->shop->id;
        $ampClass = new Amp();
               
        $smartyVars = array();
        $smartyVars['id_cms'] = Tools::getValue('id_cms');
        $smartyVars['static_token'] = Tools::getToken(false);

        $cmsPageContent = CMS::getCMSContent($smartyVars['id_cms'], $idLang, $idShop);
        $cmsPageContent = $ampClass->ampifyImg($cmsPageContent['content']);

        $smartyVars['cms'] = $cmsPageContent;

        $this->context->smarty->assign($smartyVars);
        $this->context->smarty->assign('canonical', $link->getPageLink('cms', array('id_cms' => 2), $idLang, null, false, $idShop, false));
        $this->context->smarty->assign('meta_datas', null);

        $ampClass->injectCSS();
        $metaData = array(
            'name' => 'cms',
            'id' => $smartyVars['id_cms'],
            'title' => false
        );
        $this->context->smarty->assign('amp', $ampClass->getThemeVars($metaData));

        $this->setTemplate('mobile/cms/page');

        parent::initContent();
    }

    public function setMedia($isNewTheme = false)
    {
        return false;
    }
}