<?php
/**
* 2011-2019 Promokit
*
* @package   pk_amp
* @version   1.0
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2019 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
*/

require_once(_PS_MODULE_DIR_.'pk_amp/classes/Amp.php');
use PrestaShop\PrestaShop\Adapter\Order\OrderPresenter;

class Pk_AmpHistoryModuleFrontController extends ModuleFrontController
{
    public $name = 'history';
    public $order_presenter;
    public $auth = true;
    public $guestAllowed = false;
    
    public function initContent()
    {
        $ampClass = new Amp();
        $ampClass->injectCSS();

        $orders = $this->getTemplateVarOrders();

        $this->context->smarty->assign(array(
            'orders' => $orders,
            'canonical' => $this->context->link->getPageLink($this->name),
            'amp' => $ampClass->getThemeVars(array('name' => $this->name))
        ));

        parent::initContent();
        $this->setTemplate('mobile/customer/'.$this->name);
    }

    public function getTemplateVarOrders()
    {
        $orders = array();
        $this->order_presenter = new OrderPresenter();
        $customer_orders = Order::getCustomerOrders($this->context->customer->id);
        foreach ($customer_orders as $customer_order) {
            $order = new Order((int) $customer_order['id_order']);
            $orders[$customer_order['id_order']] = $this->order_presenter->present($order);
        }

        return $orders;
    }

    public function setMedia($isNewTheme = false)
    {
        return false;
    }

}