<?php
/**
* 2011-2019 Promokit
*
* @package   pk_amp
* @version   1.0
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2019 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
*/

class Pk_AmpHomeModuleFrontController extends ModuleFrontController
{
    public function __construct()
    {
        parent::__construct();
        $this->context = Context::getContext();
        require_once(_PS_MODULE_DIR_.'pk_amp/classes/Amp.php');
    }

    public function initContent()
    {
        parent::initContent();

        if (Module::isInstalled('pspagebuilder') && Module::isEnabled('pspagebuilder')) {

            $ctx = Context::getContext();
            $ampClass = new Amp();
            $ampConfig = $ampClass->getAmpConfiguration();

            if ($ampConfig['general_force_canonical'] && !$ctx->isMobile()) {
                Tools::redirect($ctx->shop->getBaseURL(true, true));
            }

            $ampClass->injectCSS(array('home'));

            $smt = $ctx->smarty;
            $metaData = array(
                'name' => 'index',
                'id' => false,
                'title' => false
            );
            $smt->assign('amp', $ampClass->getThemeVars($metaData));
            $smt->assign('canonical', $ctx->shop->getBaseURL(true, true));

            $this->setTemplate('mobile/home');

        } else {
            $this->context->smarty->assign(
                array('page_error' => 'Please make sure the module "Page Builder" is installed and enabled')
            );    
        }
    }

}