<?php
/**
* 2011-2019 Promokit
*
* @package   pk_amp
* @version   1.0
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2019 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
*/

require_once(_PS_MODULE_DIR_.'pk_amp/classes/Amp.php');

class Pk_AmpLoginModuleFrontController extends ModuleFrontController
{
    public $ssl = true;
    public $auth = false;
    public $name = 'login';

    public function checkAccess()
    {
        if ($this->context->customer->isLogged() && !$this->ajax) {
            $this->redirect_after = ($this->authRedirection) ? urlencode($this->authRedirection) : 'my-account';
            $this->redirect();
        }

        return parent::checkAccess();
    }

    public function initContent()
    {
        $ampClass = new Amp();
        $ampClass->injectCSS();

        parent::initContent();

        $this->context->smarty->assign(array(
            'canonical' => $this->context->link->getPageLink($this->name),
            'amp' => $ampClass->getThemeVars(array('name' => $this->name))
        ));

    }

    public function postProcess()
    {
        $c = $this->context;
        $ampClass = new Amp();
        $should_redirect = false;
        $link = false;
        $error = false;

        if (Tools::getIsset('submitCreate') || Tools::getIsset('create_account')) {
            $register_form = $this
                ->makeCustomerForm()
                ->setGuestAllowed(false)
                ->fillWith(Tools::getAllValues())
            ;

            if (Tools::getIsset('submitCreate')) {
                $hookResult = array_reduce(
                    Hook::exec('actionSubmitAccountBefore', array(), null, true),
                    function ($carry, $item) {
                        return $carry && $item;
                    },
                    true
                );
                if ($hookResult && $register_form->submit()) {
                    $should_redirect = true;
                    $link = $c->link->getModuleLink('pk_amp', 'myaccount', array(), true, $c->language->id, $c->shop->id);
                } else {
                    $link = $c->link->getModuleLink('pk_amp', 'login', array('create_account' => 1,'register' => 'failed'), true, $c->language->id, $c->shop->id);
                }
            }

            if (Tools::getIsset('register')) {
                $error = $this->trans('Registration failed', array(), 'Shop.Notifications.Success');
            }

            $c->smarty->assign([
                'register_form' => $register_form->getProxy(),
                'hook_create_account_top' => Hook::exec('displayCustomerAccountFormTop'),
                'error' => $error
            ]);
            $this->setTemplate('mobile/customer/registration');
            

        } else {

            $login_form = $this->makeLoginForm()->fillWith(
                Tools::getAllValues()
            );

            if (Tools::getIsset('submitLogin')) {
                if ($login_form->submit()) {
                    $should_redirect = true;
                    $link = $c->link->getModuleLink('pk_amp', 'myaccount', array(), true, $c->language->id, $c->shop->id);
                } else {
                    $link = $c->link->getModuleLink('pk_amp', 'login', array('login' => 'failed'), true, $c->language->id, $c->shop->id);
                    
                }
            }
            if (Tools::getIsset('login')) {
                $error = $this->trans('Authentication failed', array(), 'Shop.Notifications.Success');
            }

            $c->smarty->assign([
                'login_form' => $login_form->getProxy(),
                'error' => $error
            ]);

            $this->setTemplate('mobile/customer/login');
        }

        if ($link) {

            header("access-control-allow-credentials:true");
            header("access-control-allow-headers:Content-Type, Content-Length, Accept-Encoding, X-CSRF-Token");
            header("access-control-allow-methods:GET,POST");
            header("amp-access-control-allow-source-origin: https://".$_SERVER['HTTP_HOST']);
            header("access-control-allow-origin: https://".$_SERVER['HTTP_HOST']);
            header("AMP-Redirect-To:".$link);

        }
    }
}