<?php
/**
* 2011-2019 Promokit
*
* @package   pk_amp
* @version   1.0
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2019 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
*/

require_once(_PS_MODULE_DIR_.'pk_amp/classes/Amp.php');
require_once(_PS_FRONT_CONTROLLER_DIR_.'listing/ManufacturerController.php');

class Pk_AmpManufacturerModuleFrontController extends ModuleFrontController
{
    public function initContent()
    { 
        $ctx = $this->context;
        $idLang = $ctx->language->id;
        $link = $ctx->link;
        $idShop = $ctx->shop->id;
        $page = Tools::getValue('p', 1);

        if ($id_manufacturer = Tools::getValue('id_manufacturer')) {
            $this->manufacturer = new Manufacturer((int) $id_manufacturer, $idLang);

            if (!Validate::isLoadedObject($this->manufacturer) || !$this->manufacturer->active || !$this->manufacturer->isAssociatedToShop()) {

                Controller::getController('PageNotFoundController')->run();

            } else {

                $this->manufacturer->logo = $this->context->link->getManufacturerImageLink($this->manufacturer->id);
               
                $smartyVars = array();
                $smartyVars['idShop'] = $idShop;
                $smartyVars['static_token'] = Tools::getToken(false);
                $smartyVars['manufacturer'] = $this->manufacturer;

                $this->context->smarty->assign($smartyVars);
                $this->context->smarty->assign('canonical', $this->context->link->getManufacturerLink($this->manufacturer->id));

                $ampClass = new Amp();
                $ampClass->injectCSS();

                $metaData = array(
                    'name' => 'manufacturer',
                    'id' => $id_manufacturer,
                    'title' => false
                );
                
                $this->context->smarty->assign('amp', $ampClass->getThemeVars($metaData));

                $this->setTemplate('mobile/catalog/listing/manufacturer');
            }
        } else {

            $ampClass = new Amp();
            $ampClass->injectCSS();
            $brand = new ManufacturerController();
            $brands = $brand->getTemplateVarManufacturers();
            foreach ($brands as $key => $brand) {
                $brands[$key]['image'] = $link->getManufacturerImageLink($brand['id_manufacturer']);
                $brands[$key]['url'] = $link->getModuleLink('pk_amp', 'manufacturer', array('id_manufacturer' => $brand['id_manufacturer']), true, $idLang, $idShop, false);
            }
            $this->context->smarty->assign('canonical', $link->getPageLink('manufacturer'));
            $this->context->smarty->assign(array(
                'brands' => $brands,
                'amp' => $ampClass->getThemeVars(array('name' => 'manufacturers'))
            ));
            $this->setTemplate('mobile/catalog/listing/manufacturers');

        }

        parent::initContent();
    }

    public function setMedia($isNewTheme = false)
    {
        return false;
    }
}