<?php
/**
* 2011-2019 Promokit
*
* @package   pk_amp
* @version   1.0
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2019 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
*/

require_once(_PS_MODULE_DIR_.'pk_amp/classes/Amp.php');

class Pk_AmpMyaccountModuleFrontController extends ModuleFrontController
{
    public $ssl = true;
    public $name = 'myaccount';

    public function initContent()
    { 
        $context = Context::getContext();
        $redirect_to = $context->link->getModuleLink('pk_amp', 'login', array(), true, $context->language->id, $context->shop->id);
        if (!$context->customer->isLogged())
            Tools::redirect($redirect_to);

        $ampClass = new Amp();
        $ampClass->injectCSS();

        $this->context->smarty->assign(array(
            'canonical' => $this->context->link->getPageLink($this->name),
            'amp' => $ampClass->getThemeVars(array('name' => $this->name))
        ));

        parent::initContent();
        $this->setTemplate('mobile/customer/myaccount');

    }

    public function setMedia($isNewTheme = false)
    {
        return false;
    }

}