<?php
/**
* 2011-2019 Promokit
*
* @package   pk_amp
* @version   1.0
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2019 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
*/

require_once(_PS_MODULE_DIR_.'pk_amp/classes/Amp.php');
require_once(_PS_MODULE_DIR_.'pk_amp/classes/ampProductHelper.php');

class Pk_AmpNewProductsModuleFrontController extends ModuleFrontController
{
    public $name = 'new-products';
    
    public function initContent()
    { 
        $params = array(
            'new-products' => true,
            'pageNumber' => Tools::getValue('moreItemsPageIndex'),
            'productsPerPage' => Configuration::get('PS_PRODUCTS_PER_PAGE')
        );

        $ampProdAssembl = new ampProductHelper();

        $requestedProducts = $ampProdAssembl->makeQuery($params);        
        $products_for_template = $ampProdAssembl->assembler($requestedProducts);
        $productsOnPage = count($products_for_template);

        $products['hasMorePages'] = 1;
        $products['static_token'] = Tools::getToken(false);
        $products['items'] = json_encode($products_for_template);

        if ($productsOnPage < $params['productsPerPage']) {
            $products['hasMorePages'] = 0;
        }

        $ampClass = new Amp();
        $ampClass->injectCSS();
        
        $this->context->smarty->assign(array(
            'products' => $products,
            'canonical' => $this->context->link->getPageLink($this->name),
            'amp' => $ampClass->getThemeVars(array('name' => $this->name))
        ));

        parent::initContent();
        $this->setTemplate('mobile/catalog/listing/'.$this->name);
    }

    public function setMedia($isNewTheme = false)
    {
        return false;
    }

}