<?php
/**
* 2011-2019 Promokit
*
* @package   pk_amp
* @version   1.0
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2019 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
*/

require_once(_PS_MODULE_DIR_.'pk_amp/classes/Amp.php');
use PrestaShop\PrestaShop\Adapter\Presenter\Order\OrderReturnPresenter;

class Pk_AmpOrderFollowModuleFrontController extends ModuleFrontController
{
    public $auth = true;
    public $ssl = true;
    public $name = 'order-follow';
    
    public function initContent()
    {
        $ampClass = new Amp();
        $ampClass->injectCSS();

        if (Tools::isSubmit('submitReturnMerchandise') == 1) {
            $customizationQtyInput = Tools::getValue('customization_qty_input');
            $order_qte_input = Tools::getValue('order_qte_input');
            $customizationIds = Tools::getValue('customization_ids');
            $error = array();

            if (!$id_order = (int) Tools::getValue('id_order')) {
                $error[] = 'Wrong order ID';
                //Tools::redirect('index.php?controller=history');
            }
            if (!($ids_order_detail = Tools::getValue('ids_order_detail')) && !$customizationQtyInput && !$customizationIds) {
                $error[] = 'Wrong order IDs';
                //Tools::redirect('index.php?controller=order-detail&id_order=' . $id_order . '&errorDetail1');
            }
            if (!$customizationIds && !$order_qte_input) {
                $error[] = 'Wrong customizationIds';
                //Tools::redirect('index.php?controller=order-detail&id_order=' . $id_order . '&errorDetail2');
            }

            $order = new Order((int) $id_order);
            if (!$order->isReturnable()) {
                $error[] = 'The product is not returnable';
                //Tools::redirect('index.php?controller=order-detail&id_order=' . $id_order . '&errorNotReturnable');
            }
            if ($order->id_customer != $this->context->customer->id) {
                $error[] = 'You are not order owner';
                //die(Tools::displayError());
            }
            $orderReturn = new OrderReturn();
            $orderReturn->id_customer = (int) $this->context->customer->id;
            $orderReturn->id_order = $id_order;
            $orderReturn->question = htmlspecialchars(Tools::getValue('returnText'));
            if (empty($orderReturn->question)) {
                $error[] = 'The question is empty';
                /*
                Tools::redirect('index.php?controller=order-detail&id_order=' . $id_order . '&errorMsg&' .
                    http_build_query(array(
                        'ids_order_detail' => $ids_order_detail,
                        'order_qte_input' => $order_qte_input,
                        'id_order' => Tools::getValue('id_order'),
                    )));
                    */
            }

            if (!$orderReturn->checkEnoughProduct($ids_order_detail, $order_qte_input, $customizationIds, $customizationQtyInput)) {
                $error[] = 'Not enoght products';
                //Tools::redirect('index.php?controller=order-detail&id_order=' . $id_order . '&errorQuantity');
            }

            if (empty($error)) {
                $orderReturn->state = 1;
                $orderReturn->add();
                $add = $orderReturn->addReturnDetail($ids_order_detail, $order_qte_input, $customizationIds, $customizationQtyInput);
                $ampClass->setHeaders();
                die(json_encode(array('orderReturn' => $orderReturn)));
            } else {
                $ampClass->setHeaders(false);
                die(json_encode(array('error' => $error)));
            }

        }

        $ordersReturn = $this->getTemplateVarOrdersReturns();
        if (count($ordersReturn) <= 0) {
            $warning = $this->trans(
                'You have no merchandise return authorizations.', array(), 'Shop.Notifications.Error'
            );
        }

        $this->context->smarty->assign(array(
            'ordersReturn' => $ordersReturn,
            'canonical' => $this->context->link->getPageLink($this->name),
            'amp' => $ampClass->getThemeVars(array('name' => $this->name))
        ));

        parent::initContent();
        $this->setTemplate('mobile/customer/'.$this->name);

    }

    public function getTemplateVarOrdersReturns()
    {
        $orders_returns = array();
        $orders_return = OrderReturn::getOrdersReturn($this->context->customer->id);

        $orderReturnPresenter = new OrderReturnPresenter(
            Configuration::get('PS_RETURN_PREFIX', $this->context->language->id),
            $this->context->link
        );

        foreach ($orders_return as $id_order_return => $order_return) {
            $orders_returns[$id_order_return] = $orderReturnPresenter->present($order_return);
        }

        return $orders_returns;
    }

}