<?php
/**
* 2011-2019 Promokit
*
* @package   pk_amp
* @version   1.0
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2019 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
*/

require_once(_PS_MODULE_DIR_.'pk_amp/classes/Amp.php');

class Pk_AmpOrderSlipModuleFrontController extends ModuleFrontController
{
    public $ssl = true;
    public $name = 'order-slip';
    public $auth = true;
    public $guestAllowed = false;
    
    public function initContent()
    {
        $ampClass = new Amp();
        $ampClass->injectCSS();

        $credit_slips = $this->getTemplateVarCreditSlips();

        $this->context->smarty->assign(array(
            'canonical' => $this->context->link->getPageLink($this->name),
            'amp' => $ampClass->getThemeVars(array('name' => $this->name)),
            'credit_slips' => $credit_slips,
        ));

        parent::initContent();
        $this->setTemplate('mobile/customer/'.$this->name);


        if (Configuration::isCatalogMode()) {
            Tools::redirect('index.php');
        }

        if (count($credit_slips) <= 0) {
            $this->warning[] = $this->trans('You have not received any credit slips.', array(), 'Shop.Notifications.Warning');
        }

    }

    public function getTemplateVarCreditSlips()
    {
        $credit_slips = [];
        $orders_slip = OrderSlip::getOrdersSlip(((int) $this->context->cookie->id_customer));

        foreach ($orders_slip as $order_slip) {
            $order = new Order($order_slip['id_order']);
            $credit_slips[$order_slip['id_order_slip']] = $order_slip;
            $credit_slips[$order_slip['id_order_slip']]['credit_slip_number'] = $this->trans('#%id%', array('%id%' => $order_slip['id_order_slip']), 'Shop.Theme.Customeraccount');
            $credit_slips[$order_slip['id_order_slip']]['order_number'] = $this->trans('#%id%', array('%id%' => $order_slip['id_order']), 'Shop.Theme.Customeraccount');
            $credit_slips[$order_slip['id_order_slip']]['order_reference'] = $order->reference;
            $credit_slips[$order_slip['id_order_slip']]['credit_slip_date'] = Tools::displayDate($order_slip['date_add'], null, false);
            $credit_slips[$order_slip['id_order_slip']]['url'] = $this->context->link->getPageLink('pdf-order-slip', true, null, 'id_order_slip=' . (int) $order_slip['id_order_slip']);
            $credit_slips[$order_slip['id_order_slip']]['order_url_details'] = $this->context->link->getPageLink('order-detail', true, null, 'id_order=' . (int) $order_slip['id_order']);
        }

        return $credit_slips;
    }

}