<?php
/**
* 2011-2019 Promokit
*
* @package   pk_amp
* @version   1.0
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2019 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
*/

require_once(_PS_MODULE_DIR_.'pk_amp/classes/Amp.php');

class Pk_AmpPasswordModuleFrontController extends ModuleFrontController
{

    public function initContent()
    { 
        $ampClass = new Amp();
        $ampClass->injectCSS();

        $this->context->smarty->assign(array(
            'amp' => $ampClass->getThemeVars(array('name' => 'password')),
            'canonical' => $this->context->link->getPageLink('password-recovery')
        ));

        parent::initContent();

        $token = Tools::getValue('token');
        $id_customer = (int)Tools::getValue('id_customer');
        if ($email = Db::getInstance()->getValue('SELECT `email` FROM '._DB_PREFIX_.'customer c WHERE c.`secure_key` = \''.pSQL($token).'\' AND c.id_customer = '.$id_customer)) {
            $customer = new Customer();
            $customer->getByEmail($email);

            if (!Validate::isLoadedObject($customer)) {
                $this->errors[] = $this->trans('Customer account not found', array(), 'Shop.Notifications.Error');
            } elseif (!$customer->active) {
                $this->errors[] = $this->trans('You cannot regenerate the password for this account.', array(), 'Shop.Notifications.Error');
            }

            if (Tools::getValue('reset_token')) {
                $this->context->smarty->assign([
                    'customer_email' => $customer->email,
                    'customer_token' => $token,
                    'id_customer' => $id_customer,
                    'reset_token' => Tools::getValue('reset_token'),
                ]);
                $this->setTemplate('mobile/customer/password-new');
            } else {
                $this->setTemplate('mobile/customer/password');
            }

        } else {
            $this->errors[] = $this->trans('We cannot regenerate your password with the data you\'ve submitted', array(), 'Shop.Notifications.Error');
            $this->setTemplate('mobile/customer/password');
        }

    }

    public function setMedia($isNewTheme = false)
    {
        return false;
    }

}