<?php
/**
* Promokit Amp
*
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2019 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
* @version   1.0.2
* @package   Promokit AMP
*/

use PrestaShop\PrestaShop\Adapter\Product\PriceFormatter;
use PrestaShop\PrestaShop\Core\Product\ProductListingPresenter;
use PrestaShop\PrestaShop\Adapter\Product\ProductColorsRetriever;
use PrestaShop\PrestaShop\Adapter\Image\ImageRetriever;
require_once(_PS_MODULE_DIR_.'pk_amp/classes/Amp.php');
require_once(_PS_MODULE_DIR_.'pk_amp/controllers/front/ampProductController.php');

if (file_exists(_PS_MODULE_DIR_.'productcomments/ProductComment.php')) {
  include_once _PS_MODULE_DIR_.'productcomments/ProductComment.php';
}
if (file_exists(_PS_MODULE_DIR_.'pk_sizeguide/pk_sizeguide.php')) {
  include_once _PS_MODULE_DIR_.'pk_sizeguide/pk_sizeguide.php';
}
if (file_exists(_PS_MODULE_DIR_.'blockreassurance/blockreassurance.php')) {
  include_once _PS_MODULE_DIR_.'blockreassurance/blockreassurance.php';
}

class Pk_AmpProductModuleFrontController extends ModuleFrontController
{
    public $ssl = true;
    public $name = 'product';
    /**
     * @throws PrestaShopException
     */
    public function initContent()
    {
        $ctx = $this->context;

        $productRaw = new Product(
            (int)Tools::getValue('id_product'), false, $ctx->language->id
        );
            
        if (!Validate::isLoadedObject($productRaw)) {
            Controller::getController('PageNotFoundController')->run();
        }

        $link = new Link();        
        $ampClass = new Amp();
        
        $assembler = new ProductAssembler($ctx);
        $presenterFactory = new ProductPresenterFactory($ctx);
        $presentationSettings = $presenterFactory->getPresentationSettings();
        $presenter = new ProductListingPresenter(
            new ImageRetriever(
                $ctx->link
            ),
            $ctx->link,
            new PriceFormatter(),
            new ProductColorsRetriever(),
            $ctx->getTranslator()
        );

        $productRaw->id_product = $productRaw->id;
        $product = $presenter->present(
            $presentationSettings,
            $assembler->assembleProduct((array)$productRaw),
            $ctx->language
        );

        // get product attributes and combinations
        $attributes = new Pk_AmpProductController();
        $attributes->ampAssignAttributesGroups($productRaw, $product);
        $product = $attributes->getCustomizations();

        // get missed manufacturer name
        $product['manufacturer_name'] = Manufacturer::getNameById($product['id_manufacturer']);
        $product['manufacturer_link'] = $ctx->link->getModuleLink('pk_amp', 'manufacturer', array('id_manufacturer' => $product['id_manufacturer']), true, $ctx->language->id, $ctx->shop->id, false);
        
        // get product accessories
        $accessories = $productRaw->getAccessories($ctx->language->id, $product['id']);
        
        foreach ($accessories as $key => $p) {
            $cover = Image::getCover($p['id_product']);
            if ($cover) {
                $accessories[$key]['cover']['medium']['url'] = $ctx->link->getImageLink($p['link_rewrite'], $cover["id_image"], ImageType::getFormattedName('home'));
            }
            $accessories[$key]['price'] = Tools::displayPrice($p['price'], $ctx->currency);
        }

        if (class_exists('ProductComment')) {
            $rating = ProductComment::getAverageGrade($product['id_product']);
            $rating['reviewCount'] = ProductComment::getCommentNumber($product['id_product']);
        }

        if (class_exists('pk_sizeguide')) {
            $guide = $this->getSizeGuide($product['id']);
            $ctx->smarty->assign('sizeGuide', $guide);
        }

        if (class_exists('blockreassurance')) {
            $reassurance = new Blockreassurance();
            $elements = $reassurance->getWidgetVariables();
            $ctx->smarty->assign('reassurance', $elements);
        }

        $ctx->smarty->assign('meta_datas', Meta::getProductMetas($product['id'], $ctx->language->id, 'product'));
        $ctx->smarty->assign('canonical', $link->getProductLink($product['id'], $product['link_rewrite']));
        $ctx->smarty->assign('product', $product);
        $ctx->smarty->assign('accessories', $accessories);
        $ctx->smarty->assign('rating', $rating);
        $ctx->smarty->assign('link', $link);
        $ctx->smarty->assign('customTabs', $this->getCustomTabs($product['id']));
        $metaData = array(
            'name' => 'product',
            'id' => $product['id_product'],
            'title' => false
        );
        $ctx->smarty->assign('amp', $ampClass->getThemeVars($metaData));
        $ampClass->injectCSS(array('product'));

        $this->setTemplate('mobile/catalog/product');

        parent::initContent();
    }

    public function getSizeGuide($product_id)
    {
        $sizeGuide = array();
        $id_guide = SizeGuide::getProductGuide($product_id);
        $show_global = Configuration::get('PKSG_show_global');
        $lid = $this->context->language->id;

        if ($id_guide || $show_global) {
            $sizeGuide['guide'] = new SizeGuide((int)$id_guide, $lid);
            $sizeGuide['howto'] = Configuration::get('PKSG_content', $lid);
            $sizeGuide['show_measure'] = Configuration::get('PKSG_show_measure');
            $sizeGuide['show_global'] = $show_global;
            $sizeGuide['global'] = Configuration::get('PKSG_global', $lid);
        }
        return $sizeGuide;
    }

    public function getCustomTabs($product_id)
    {
        $tabs = array();
        $tabs = $this->getCustomTabsFromModule($product_id);
        /*
        $modules = array('customproducttabs');
        foreach ($modules as $key => $module) {
            $mInstance = Module::getInstanceByName($module);
            if (Validate::isLoadedObject($mInstance)) {
                $tabs[$key]['tab'] = Hook::exec('displayProductTab', array(), (int)$mInstance->id);
                $tabs[$key]['content'] = Hook::exec('displayProductTabContent', array(), (int)$mInstance->id);
            }
        }
        */
        return $tabs;
    }

    public function getCustomTabsFromModule($product_id)
    {
        $ampClass = new Amp();
        $tabs = array();
        $mInstance = Module::getInstanceByName('customproducttabs');
        if (Validate::isLoadedObject($mInstance)) {
            require_once _PS_MODULE_DIR_.'customproducttabs/models/CustomProductTabs.php';
            require_once _PS_MODULE_DIR_.'customproducttabs/models/CustomProductTabsContent.php';
            $tabsmodel = new CustomProductTabsModel();
            //$tabscontentmodel = new CustomProductTabsContentModel();

            $tabs = $tabsmodel->getProductTabs($product_id, $this->context->language->id);
            foreach ($tabs as $key => $tab) {
                if ($tab['id_store'] != $this->context->shop->id || $tab['status'] != 1) {
                    unset($tabs[$key]);
                } else {
                    $tabs[$key]['default_content'] = $ampClass->ampifyContent($tab['default_content']);
                }
            }
        }
        return $tabs;
    }

}