<?php
/**
* 2011-2019 Promokit
*
* @package   pk_amp
* @version   1.0
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2019 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
*/

require_once(_PS_MODULE_DIR_.'pk_amp/classes/Amp.php');

class Pk_AmpSearchModuleFrontController extends ModuleFrontController
{
    public $ssl = true;
    
    public function initContent()
    { 
        $ctx = $this->context;
        $idLang = $ctx->language->id;
        $link = $ctx->link;
        $idShop = $ctx->shop->id;

        $ampClass = new Amp();
        $ampClass->injectCSS();
               
        $smartyVars = array(
            'static_token' => Tools::getToken(false),
            'searchStr' => Tools::getValue('searchstr')
        );

        $ctx->smarty->assign($smartyVars);
        $ctx->smarty->assign('canonical', $link->getPageLink('search', null, $idLang, array('s' => $smartyVars['searchStr']), false, $idShop, false));
        $ctx->smarty->assign('amp', $ampClass->getThemeVars(array('name' => 'search')));

        parent::initContent();
        $this->setTemplate('mobile/catalog/listing/search');
    }

    public function setMedia($isNewTheme = false)
    {
        return false;
    }
}