<?php
/**
* 2011-2019 Promokit
*
* @package   pk_amp
* @version   1.0
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2019 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
*/

require_once(_PS_MODULE_DIR_.'pk_amp/classes/Amp.php');

class Pk_AmpSitemapModuleFrontController extends ModuleFrontController
{
    public $ssl = true;
    
    public function initContent()
    { 
        $this->context->smarty->assign('canonical', $this->context->link->getPageLink('sitemap'));

        $ampClass = new Amp();
        $ampClass->injectCSS();
        $pages = $ampClass->getAmpPagesLinks();
        
        $this->context->smarty->assign('amp', $ampClass->getThemeVars(array('name' => 'sitemap')));
        $this->context->smarty->assign(
            array(
                'our_offers' => $this->trans('Our Offers', array(), 'Shop.Theme.Global'),
                'categories' => $this->trans('Categories', array(), 'Shop.Theme.Catalog'),
                'your_account' => $this->trans('Your account', array(), 'Shop.Theme.Customeraccount'),
                'pages' => $this->trans('Pages', array(), 'Shop.Theme.Catalog'),
                'links' => array(
                    'offers' => $this->getOffersLinks($pages),
                    'pages' => $this->getPagesLinks($pages),
                    //'user_account' => $this->getUserAccountLinks($pages),
                    'categories' => $this->getCategoriesLinks(),
                )
            )
        );

        parent::initContent();
        $this->setTemplate('mobile/cms/sitemap');

    }

    public function setMedia($isNewTheme = false)
    {
        return false;
    }

    public function getCategoriesLinks()
    {
        $ampClass = new Amp();
        $categories = Category::getRootCategory()->recurseLiteCategTree(0, 0, null, null, 'sitemap');
        $categories['children'] = $this->fixCategoriesItem($categories['children']);
        $categories['children'] = $ampClass->menuHandler($categories['children']);
        // ampify root category
        $categories['url'] = Context::getContext()->link->getModuleLink('pk_amp', 'category', array('id_category' => str_replace('category-page-', '', $categories['id'])), true, Context::getContext()->language->id, Context::getContext()->shop->id, false);
        return array($categories);
    }

    public function fixCategoriesItem($cats)
    {
      foreach ($cats as $key => $item) {
        $cats[$key]['type'] = 'category';
        $cats[$key]['page_identifier'] = str_replace('-page', '', $item['id']);
        if (!empty($item['children'])) {
          $cats[$key]['children'] = $this->fixCategoriesItem($item['children']);
        }
      }
      return $cats;
    }

    /**
     * @return array
     */
    protected function getPagesLinks($pages)
    {
        $cms = CMSCategory::getRecurseCategory($this->context->language->id, 1, 1, 1);
        $links = $this->getCmsTree($cms);
        $links = $this->ampifyLinks($links);

        $links[] = array(
            'id' => 'stores-page',
            'label' => $this->trans('Our stores', array(), 'Shop.Theme.Global'),
            'url' => $pages['stores'],
        );

        $links[] = array(
            'id' => 'contact-page',
            'label' => $this->trans('Contact us', array(), 'Shop.Theme.Global'),
            'url' => $pages['contact'],
        );

        $links[] = array(
            'id' => 'sitemap-page',
            'label' => $this->trans('Sitemap', array(), 'Shop.Theme.Global'),
            'url' => $pages['sitemap'],
        );

        return $links;
    }

    protected function ampifyLinks($links)
    {
        if (is_array($links) && !empty($links)) {
          foreach ($links as $key => $link) {

            if (strpos($link['id'], 'cms-page-') !== false) {
              $cmsID = str_replace("cms-page-", "", $link['id']);
              $links[$key]['id'] = $cmsID;
              $links[$key]['url'] = $this->context->link->getModuleLink('pk_amp', 'cms', array('id_cms' => $cmsID), true, $this->context->language->id, $this->context->shop->id, false);
            }

          }
        }
        return $links;
    }

    /**
     * @return array
     */
    protected function getCmsTree($cms)
    {
        $links = array();

        foreach ($cms['cms'] as $p) {
            $links[] = array(
                'id' => 'cms-page-' . $p['id_cms'],
                'label' => $p['meta_title'],
                'url' => $p['link'],
            );
        }

        if (isset($cms['children'])) {
            foreach ($cms['children'] as $c) {
                $links[] = array(
                    'id' => 'cms-category-' . $c['id_cms_category'],
                    'label' => $c['name'],
                    'url' => $c['link'],
                    'children' => $this->getCmsTree($c),
                );
            }
        }

        return $links;
    }

    /**
     * @return array
     */
    protected function getUserAccountLinks($pages)
    {
        $links = array();

        $links[] = array(
            'id' => 'login-page',
            'label' => $this->trans('Log in', array(), 'Shop.Theme.Global'),
            'url' => $pages['authentication'],
        );

        $links[] = array(
            'id' => 'register-page',
            'label' => $this->trans('Create new account', array(), 'Shop.Theme.Global'),
            'url' => $pages['authentication'],
        );

        return $links;
    }

    /**
     * @return array
     */
    protected function getOffersLinks($pages)
    {
        $ampClass = new Amp();
        $links = array(
            array(
                'id' => 'new-product-page',
                'label' => $this->trans('New products', array(), 'Shop.Theme.Catalog'),
                'url' => $pages['new_products'],
            ),
        );

        if (Configuration::isCatalogMode() && Configuration::get('PS_DISPLAY_BEST_SELLERS')) {
            $links[] = array(
                'id' => 'best-sales-page',
                'label' => $this->trans('Best sellers', array(), 'Shop.Theme.Catalog'),
                'url' => $pages['best_sales'],
            );
            $links[] = array(
                'id' => 'prices-drop-page',
                'label' => $this->trans('Price drop', array(), 'Shop.Theme.Catalog'),
                'url' => $pages['prices_drop'],
            );
        }

        if (Configuration::get('PS_DISPLAY_SUPPLIERS')) {

            $manufacturers = Manufacturer::getLiteManufacturersList($this->context->language->id, 'sitemap');
            $manufacturers = $ampClass->ampifyManufacturersLinks($manufacturers);

            $links[] = array(
                'id' => 'manufacturer-page',
                'label' => $this->trans('Brands', array(), 'Shop.Theme.Catalog'),
                'url' => $pages['manufacturer'],
                'children' => $manufacturers,
            );

            $suppliers = Supplier::getLiteSuppliersList($this->context->language->id, 'sitemap');
            $suppliers = $ampClass->ampifySuppliersLinks($suppliers);
            $links[] = array(
                'id' => 'supplier-page',
                'label' => $this->trans('Suppliers', array(), 'Shop.Theme.Catalog'),
                'url' => $pages['supplier'],
                'children' => $suppliers,
            );
        }

        return $links;
    }
}