<?php
/**
* 2011-2019 Promokit
*
* @package   pk_amp
* @version   1.0
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2019 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
*/

require_once(_PS_MODULE_DIR_.'pk_amp/classes/Amp.php');
require_once(_PS_FRONT_CONTROLLER_DIR_.'StoresController.php');

class Pk_AmpStoresModuleFrontController extends ModuleFrontController
{
    public $ssl = true;
    
    public function initContent()
    { 
        $stores = new StoresController();
        $this->context->smarty->assign('canonical', $this->context->link->getPageLink('stores'));

        $ampClass = new Amp();
        $ampClass->injectCSS();
        
        $distance_unit = Configuration::get('PS_DISTANCE_UNIT');
        if (!in_array($distance_unit, array('km', 'mi'))) {
            $distance_unit = 'km';
        }

        $metaData = array(
            'name' => 'stores',
            'id' => null,
            'title' => null
        );
        $this->context->smarty->assign('amp', $ampClass->getThemeVars($metaData));
        $this->context->smarty->assign(array(
            'mediumSize' => Image::getSize(ImageType::getFormattedName('medium')),
            'searchUrl' => $this->context->link->getPageLink('stores'),
            'distance_unit' => $distance_unit,
            'stores' => $stores->getTemplateVarStores(),
        ));

        parent::initContent();
        $this->setTemplate('mobile/cms/stores');

    }

    public function setMedia($isNewTheme = false)
    {
        return false;
    }

}