<?php
/**
* 2011-2019 Promokit
*
* @package   pk_amp
* @version   1.0
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2019 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
*/

require_once(_PS_MODULE_DIR_.'pk_amp/classes/Amp.php');
require_once(_PS_FRONT_CONTROLLER_DIR_.'listing/SupplierController.php');

class Pk_AmpSupplierModuleFrontController extends ModuleFrontController
{
    public $ssl = true;
    
    public function initContent()
    { 
        $ctx = $this->context;
        $idLang = $ctx->language->id;
        $link = $ctx->link;
        $idShop = $ctx->shop->id;
        $page = Tools::getValue('p', 1);

        if ($id_supplier = Tools::getValue('id_supplier')) {
            $this->supplier = new Supplier((int) $id_supplier, $idLang);

            if (!Validate::isLoadedObject($this->supplier) || !$this->supplier->active || !$this->supplier->isAssociatedToShop()) {

                Controller::getController('PageNotFoundController')->run();

            } else {

                $this->supplier->logo = $this->context->link->getSupplierImageLink($this->supplier->id);
               
                $smartyVars = array();
                $smartyVars['idShop'] = $idShop;
                $smartyVars['static_token'] = Tools::getToken(false);
                $smartyVars['supplier'] = $this->supplier;

                $this->context->smarty->assign($smartyVars);
                $this->context->smarty->assign('canonical', $this->context->link->getSupplierLink($this->supplier->id));

                $ampClass = new Amp();
                $ampClass->injectCSS();

                $metaData = array(
                    'name' => 'supplier',
                    'id' => $id_supplier,
                    'title' => false
                );
                
                $this->context->smarty->assign('amp', $ampClass->getThemeVars($metaData));

                $this->setTemplate('mobile/catalog/listing/supplier');
            }
        } else {

            $ampClass = new Amp();
            $ampClass->injectCSS();

            $supplier = new SupplierController();
            $suppliers = $supplier->getTemplateVarSuppliers();
            
            foreach ($suppliers as $key => $supplier) {
                $suppliers[$key]['image'] = $link->getSupplierImageLink($supplier['id_supplier'], ImageType::getFormattedName('medium'));
                $suppliers[$key]['url'] = $link->getModuleLink('pk_amp', 'supplier', array('id_supplier' => $supplier['id_supplier']), true, $idLang, $idShop, false);
            }
            
            $this->context->smarty->assign('canonical', $link->getPageLink('supplier'));
            $this->context->smarty->assign(array(
                'suppliers' => $suppliers,
                'amp' => $ampClass->getThemeVars(array('name' => 'supplier'))
            ));
            $this->setTemplate('mobile/catalog/listing/suppliers');

        }

        parent::initContent();
    }

    public function setMedia($isNewTheme = false)
    {
        return false;
    }
}