<?php
/**
* Promokit Amp
*
* @package   Promokit AMP
* @version   1.0.3
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2019 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
*/

if (!defined('_PS_VERSION_'))
    exit;

require_once(_PS_MODULE_DIR_.'pk_amp/classes/Amp.php');
require_once(_PS_MODULE_DIR_.'pk_amp/classes/adminHelper.php');

class Pk_Amp extends Module
{
    public function __construct()
    {
        $this->name                   = 'pk_amp';
        $this->version                = '1.0.3';
        $this->author                 = 'promokit.eu';
        $this->need_instance          = 0;
        $this->bootstrap              = true;
        $this->ps_versions_compliancy = array('min' => '1.7', 'max' => _PS_VERSION_);
        $this->tab                    = 'front_office_features';

        parent::__construct();
        $this->controllers            = array('home', 'category', 'product');
        $this->displayName            = 'Promokit AMP';
        $this->description            = $this->l('The module makes your theme AMP compatible');
        $this->genCssFile = _PS_MODULE_DIR_.'pk_amp/views/css/dynamic/generated-s'.$this->context->shop->id.'.css';
        $this->config_file = _PS_MODULE_DIR_.$this->name."/config.json";
    }

    /**
     * @return bool
     * @throws PrestaShopException
     */
    public function install()
    {
        return 
            parent::install() && 
            $this->registerHook('displayHeader') && 
            $this->registerHook('displayAmpFooter') && 
            $this->registerHook('moduleRoutes') &&
            $this->setDefaultConfig() &&
            //$this->copyTemplates() && necessary to install for any other theme then Alysum
            $this->addTab()
        ;
    }

    /**
     * @return bool
     */
    public function uninstall()
    {
        return 
            parent::uninstall() && 
            $this->unregisterHook('displayHeader') && 
            $this->unregisterHook('displayAmpFooter') && 
            $this->unregisterHook('moduleRoutes') &&
            $this->removeTab()
        ;
    }

    public function addTab()
    {
        // First check for parent tab
        $parentTabID = Tab::getIdFromClassName('AdminParentThemes');
        $className = 'AdminPkAmp';

        // Check for subtab
        $tab = new Tab();
        $tab->name = array();
        $tab->active = 1;
        $tab->class_name = $className;
        $tab->id_parent = $parentTabID;
        $tab->module = $this->name;
        foreach (Language::getLanguages() as $lang) {
          $tab->name[$lang['id_lang']] = "AMP Settings";
        }

        $response = $tab->add();

        return $response;
    }
    
    private function removeTab()
    {
        $tab_class = 'AdminPkAmp';
        $id_tab = Tab::getIdFromClassName($tab_class);
        if ($id_tab != 0) {
            $tab = new Tab($id_tab);
            $tab->delete();
            return true;
        }
        return false;
    }

    public function setDefaultConfig()
    {
        if (!$f = @fopen($this->config_file, 'r'))
            return false;

        $adminHelper = new adminHelper();
        $json_config = fread($f, filesize($this->config_file));

        if ($configObj = Tools::jsonDecode($json_config)) {
            return $adminHelper->updateAmpConfiguration((array)$configObj);
        }

        return false;
    }

    public function copyTemplates()
    {
        $templatesArchive = _PS_MODULE_DIR_.$this->name."/templates/mobile.zip";

        if (!file_exists($templatesArchive))
            return false;
            //return $this->displayError("There is no templates archive!");

        if (!Tools::ZipTest($templatesArchive))
            return false;
            //return $this->displayError("Zip file seems broken");

        $zip = new ZipArchive;
        $openedZip = $zip->open($templatesArchive);

        if (!$openedZip)
            return false;
            //return $this->displayError("Unable to open templates archive");

        $extract = $zip->extractTo($this->context->shop->getTheme().'templates/');
        $zip->close();

        if (!$extract)
            return false;
            //return $this->displayError("Unable to extract files");

        return true;
        //return $this->displayConfirmation("Templates has been successfully copied to current theme");
    }

    // TODO Friendly URLs 
    public function hookModuleRoutes($params)
    {
        $amp_slug = 'mobile';

        return array(
            // Home
            'module-pk_amp-home' => array(
                'controller' => 'home',
                'rule' => $amp_slug,
                'keywords' => array(),
                'params' => array(
                    'fc' => 'module',
                    'module' => 'pk_amp',
                ),
            ),

            // Category
            'module-pk_amp-category' => array(
                'controller' => 'category',
                'rule' => $amp_slug.'/category/{id_category}',
                'keywords' => array(
                    'id_category' => array(
                        'regexp' => '[_a-zA-Z0-9-\pL]*',
                        'param' => 'id_category'
                    ),
                ),
                'params' => array(
                    'fc' => 'module',
                    'module' => $this->name,
                ),
            ),

            // Product
            'module-pk_amp-product' => array(
                'controller' => 'product',
                'rule' => $amp_slug.'/product/{id_product}',
                'keywords' => array(
                    'id_product' => array(
                        'regexp' => '[_a-zA-Z0-9-\pL]*',
                        'param' => 'id_product',
                    ),
                ),
                'params' => array(
                    'fc' => 'module',
                    'module' => $this->name,
                ),
            ),

            // Brand
            'module-pk_amp-manufacturer' => array(
                'controller' => 'manufacturer',
                'rule' => $amp_slug.'/brand/{id_manufacturer}',
                'keywords' => array(
                    'id_manufacturer' => array(
                        'regexp' => '[_a-zA-Z0-9-\pL]*',
                        'param' => 'id_manufacturer',
                    ),
                ),
                'params' => array(
                    'fc' => 'module',
                    'module' => $this->name,
                ),
            ),
        );
    }

    /**
     * @return string
     */
    public function hookDisplayHeader()
    {
        if (!isset($this->context->controller->php_self)) {
            return;
        }

        $ampClass = new Amp();
        $ctx = $this->context;
        $link = $ctx->link;
        $shop_id = $ctx->shop->id;
        $lang_id = $ctx->language->id;
        $controller = $ctx->controller;
        $ampConfig = $ampClass->getAmpConfiguration();

        $params = Tools::getAllValues();
        unset($params['controller']);
        unset($params['id_lang']);
        unset($params['isolang']);
        unset($params['token']);

        switch ($controller->php_self) {

            case 'index':

                $cacheId = 'amp_header|index';
                $ampLink = $link->getModuleLink($this->name, 'home', array(), true, $lang_id, $shop_id, false);

                break;

            case 'product':
                $product = $controller->getProduct();

                if (!Validate::isLoadedObject($product)) {
                    return '';
                }

                $cacheId = 'amp_header|product|'.$product->id;
                $ampLink = $link->getModuleLink($this->name, 'product', array('id_product' => $product->id), true, $lang_id, $shop_id, false);

                break;

            case 'category':
                $category = $controller->getCategory();

                if (!Validate::isLoadedObject($category)) {
                    return '';
                }

                $cacheId = 'amp_header|category|'.$category->id;
                $ampLink = $link->getModuleLink($this->name, 'category', array('id_category' => $category->id), true, $lang_id, $shop_id, false);

                break;
            case 'manufacturer':
                $manufacturer = new Manufacturer((int)Tools::getValue('id_manufacturer'), $lang_id);

                if (!Validate::isLoadedObject($manufacturer)) {
                    return '';
                }

                $cacheId = 'amp_header|manufacturer|'.$manufacturer->id;
                $ampLink = $link->getModuleLink($this->name, 'manufacturer', array('id_manufacturer' => $manufacturer->id), true, $lang_id, $shop_id, false);

                break;

            case 'supplier':
                $supplier = new Supplier((int)Tools::getValue('id_supplier'), $lang_id);

                if (!Validate::isLoadedObject($supplier)) {
                    return '';
                }

                $cacheId = 'amp_header|supplier|'.$supplier->id;
                $ampLink = $link->getModuleLink($this->name, 'supplier', array('id_supplier' => $supplier->id), true, $lang_id, $shop_id, false);

                break;

            case 'search':
            
                $cacheId = null;
                $ampLink = $link->getModuleLink($this->name, 'search', array('str' => ''), true, $lang_id, $shop_id, false);

                break;

            case 'cms':

                $cms_id = (int)Tools::getValue('id_cms');

                $cacheId = 'amp_header|cms|'.$cms_id;
                $ampLink = $link->getModuleLink($this->name, 'cms', array('id_cms' => $cms_id), true, $lang_id, $shop_id, false);

                break;

            case 'sitemap':

                $cacheId = 'amp_header|sitemap';
                $ampLink = $link->getModuleLink($this->name, 'sitemap', array(), true, $lang_id, $shop_id, false);

                break;

            case 'stores':

                $cacheId = 'amp_header|stores';
                $ampLink = $link->getModuleLink($this->name, 'stores', array(), true, $lang_id, $shop_id, false);

                break;

            case 'new-products':

                $cacheId = 'amp_header|new-products';
                $ampLink = $link->getModuleLink($this->name, 'new-products', array(), true, $lang_id, $shop_id, false);

                break;

             case 'best-sales':

                $cacheId = 'amp_header|best-sales';
                $ampLink = $link->getModuleLink($this->name, 'best-sales', array(), true, $lang_id, $shop_id, false);

                break;

             case 'prices-drop':

                $cacheId = 'amp_header|prices-drop';
                $ampLink = $link->getModuleLink($this->name, 'prices-drop', array(), true, $lang_id, $shop_id, false);

                break;

            case 'my-account':

                $cacheId = 'amp_header|my-account';
                $ampLink = $link->getModuleLink($this->name, 'my-account', array(), true, $lang_id, $shop_id, false);

                break;

            case 'password':

                $cacheId = 'amp_header|password';
                $ampLink = $link->getModuleLink($this->name, 'password', array(), true, $lang_id, $shop_id, false);

                break;

            case 'checkout':

                $cacheId = 'amp_header|checkout';
                $ampLink = $this->getPageLink('checkout');

                break;

            case 'order':

                $cacheId = 'amp_header|checkout';
                $ampLink = $this->getPageLink('checkout', $params);

                break;

            case 'order-details':

                $cacheId = 'amp_header|order-details';
                $ampLink = $this->getPageLink('order-details');

                break;

            case 'order-follow':

                $cacheId = 'amp_header|order-follow';
                $ampLink = $this->getPageLink('order-follow');

                break;

            case 'order-confirmation':

                $cacheId = 'amp_header|order-confirmation';
                $ampLink = $this->getPageLink('order-confirmation', $params);

                break;

            case 'identity':

                $cacheId = 'amp_header|identity';
                $ampLink = $this->getPageLink('identity');

                break;

            case 'history':

                $cacheId = 'amp_header|history';
                $ampLink = $this->getPageLink('history');

                break;

            case 'contact':

                $cacheId = 'amp_header|contact';
                $ampLink = $this->getPageLink('contact');

                break;

            case 'cart':

                $cacheId = 'amp_header|cart';
                $ampLink = $link->getModuleLink($this->name, 'cart', array(), true, $lang_id, $shop_id, false);

                break;

            case 'addresses':

                $cacheId = 'amp_header|addresses';
                $ampLink = $link->getModuleLink($this->name, 'addresses', array(), true, $lang_id, $shop_id, false);

                break;

            case 'address':

                $cacheId = 'amp_header|address';
                $ampLink = $link->getModuleLink($this->name, 'address', array(), true, $lang_id, $shop_id, false);

                break;

            case 'login':

                $cacheId = 'amp_header|login';
                $ampLink = $link->getModuleLink($this->name, 'login', array(), true, $lang_id, $shop_id, false);

                break;

            case 'authentication':

                $cacheId = 'amp_header|login';
                $ampLink = $link->getModuleLink($this->name, 'login', array(), true, $lang_id, $shop_id, false);

                break;

            case 'order-slip':

                $cacheId = 'amp_header|order-slip';
                $ampLink = $link->getModuleLink($this->name, 'order-slip', array(), true, $lang_id, $shop_id, false);

                break;
            
            default:
                return '';
        }

        if (!$this->isCached('module:'.$this->name.'/views/templates/hook/amp_header.tpl', $this->getCacheId($cacheId))) {

            $this->context->smarty->assign(
                array('amp_link' => $ampLink)
            );

        }

        $mobile = $ctx->isMobile();
        $enabled = Module::isEnabled($this->name);
        $canonical = $this->context->shop->getBaseURL(true, false).$_SERVER['REQUEST_URI'];
        //print_r($ampLink);
        if ($ampConfig['general_force_amp'] && $mobile && $enabled && ($canonical != $ampLink)) {
            Tools::redirect($ampLink);
        }

        // add AMP link for desktop version 
        return $this->fetch('module:'.$this->name.'/views/templates/hook/amp_header.tpl', $this->getCacheId($cacheId));
    }

    public function getPageLink($name, $params = array()) {
        return $this->context->link->getModuleLink($this->name, $name, $params, true, $this->context->language->id, $this->context->shop->id, false);
    }

    public function getContent()
    {
        $ampClass = new Amp();
        $adminHelper = new adminHelper();
        $ampConfig = $ampClass->getAmpConfiguration();
        $formRaw = $this->configForm();
        $output = '';

        if (Tools::isSubmit('resetAmpConfiguration')) {

            if (!$f = @fopen($this->config_file, 'r')) {
                $output .= $this->displayError($this->l('Unable to read config file: ').$this->config_file);
            } else {

                $json_config = fread($f, filesize($this->config_file));
                if ($configObj = Tools::jsonDecode($json_config)) {
                    $adminHelper->updateAmpConfiguration((array)$configObj);
                    $cssStyles = $adminHelper->generateCSS((array)$configObj, $formRaw['form']['input']);
                    $output .= $adminHelper->writeFile($cssStyles, $this->genCssFile);
                } else {
                    $output .= $this->displayError($this->l('JSON Config is invalid'));
                }

            }

            return $output.$this->renderForm();

        }
        

        if (Tools::isSubmit('submitAmpConfiguration')) {

            $configValues = $adminHelper->getLiveConfigValues();

            if ($adminHelper->updateAmpConfiguration($configValues)) {
                $output .= $this->displayConfirmation($this->l('Configuration saved successfull'));
            } else {
                $output .= $this->displayError($this->l('An error occurred on saving'));
            }

            $cssStyles = $adminHelper->generateCSS($configValues, $formRaw['form']['input']);
            $output .= $adminHelper->writeFile($cssStyles, $this->genCssFile);

        }

        return $output.$this->renderForm();
    }

    public function renderForm()
    {
        $ampClass = new Amp();
        $formValues = $ampClass->getAmpConfiguration();
        $adminLink = $this->context->link->getAdminLink('AdminModules', false);
        $default_lang = (int)Configuration::get('PS_LANG_DEFAULT');

        $helper = new HelperForm();
        $helper->show_toolbar = true;
        $helper->table = $this->table;
        $helper->module = $this;
        $helper->default_form_language = $default_lang;
        $helper->allow_employee_form_lang = $default_lang;
        $helper->submit_action = 'submitAmpConfiguration';
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->currentIndex = $adminLink.'&configure='.$this->name.'&tab_module='.$this->tab.'&module_name='.$this->name;
        $helper->tpl_vars = array('fields_value' => $formValues);
        foreach (Language::getLanguages(false) as $lang) {
            $helper->languages[] = array(
                'id_lang' => $lang['id_lang'],
                'iso_code' => $lang['iso_code'],
                'name' => $lang['name'],
                'is_default' => ($default_lang == $lang['id_lang'] ? 1 : 0)
            );
        }

        $this->context->controller->addCSS($this->_path . 'views/css/admin.css');
        return $helper->generateForm(array($this->configForm()));
    }

    protected function configForm()
    {
        $adminLink = $this->context->link->getAdminLink('AdminModules', false);
        $menuAdminLink = $adminLink.'&configure=ps_mainmenu&token='.Tools::getAdminTokenLite('AdminModules');
        $builderAdminLink = $this->context->link->getAdminLink('AdminPspagebuilderAmp').'&token='.Tools::getAdminTokenLite('AdminPspagebuilderAmp');

        return array(
            'form' => array(
                'tinymce' => true,
                'tabs' => array(
                    'general' => $this->l('General'),
                    'menu' => $this->l('Menu'),
                    'sidebars' => $this->l('Sidebars'),
                    'header_conf' => $this->l('Header'),
                    'footer_conf' => $this->l('Footer'),
                    'home_page' => $this->l('Home Page'),
                    'category_page' => $this->l('Category Page'),
                    'product_page' => $this->l('Product Page'),
                    'documentation' => $this->l('AMP Documentation'),
                ),
                'input' => array(
                    array(
                        'type' => 'html',
                        'html_content' => '<h2 class="ap-title">'. $this->l('General Settings') .'</h2><hr>',
                        'name' => '',
                        'tab' => 'general',
                        'label' => '',
                        'col' => 12,
                    ),
                    array(
                        'type' => 'switch',
                        'name' => 'general_force_amp',
                        'label' => $this->l('Force loading AMP'),
                        'hint' => $this->l('Force loading AMP on mobile devices if AMP page is available'),
                        'col' => 8,
                        'tab' => 'general',
                        'values' => array(
                            array(
                              'id'    => 'active_on',
                              'value' => true,
                              'label' => $this->l('Yes'),
                            ),
                            array(
                              'id'    => 'active_off',
                              'value' => false,
                              'label' => $this->l('No'),
                            ),
                        ),
                    ),
                    array(
                        'type' => 'switch',
                        'name' => 'general_force_canonical',
                        'label' => $this->l('Force loading desktop version'),
                        'hint' => $this->l('Force loading desktop version on desktops if AMP page is opened'),
                        'col' => 8,
                        'tab' => 'general',
                        'values' => array(
                            array(
                              'id'    => 'active_on',
                              'value' => true,
                              'label' => $this->l('Yes'),
                            ),
                            array(
                              'id'    => 'active_off',
                              'value' => false,
                              'label' => $this->l('No'),
                            ),
                        ),
                    ),
                    array(
                        'type' => 'switch',
                        'name' => 'general_enable_search',
                        'label' => $this->l('Enable search'),
                        'col' => 8,
                        'tab' => 'general',
                        'values' => array(
                            array(
                              'id'    => 'active_on',
                              'value' => true,
                              'label' => $this->l('Yes'),
                            ),
                            array(
                              'id'    => 'active_off',
                              'value' => false,
                              'label' => $this->l('No'),
                            ),
                        ),
                    ),
                    array(
                        'type'   => 'color',
                        'name'   => 'general_buttons_color',
                        'tab' => 'general',
                        'label'  => $this->l('Buttons Color'),
                        'selector' => '.big-btn, .btn',
                        'css_property' => 'background',
                    ),
                    array(
                        'type'   => 'color',
                        'name'   => 'general_buttons_text_color',
                        'tab' => 'general',
                        'label'  => $this->l('Buttons Text Color'),
                        'selector' => '.big-btn, .btn',
                        'css_property' => 'color',
                    ),/*
                    array(
                        'type'   => 'text',
                        'name'   => 'general_price_font_size',
                        'tab' => 'general',
                        'label'  => $this->l('Price Font Size'),
                        'col' => 1,
                        'suffix'      => 'px',
                        'selector' => '.price',
                        'css_property' => 'font-size',
                    ),*/
                    array(
                        'type'   => 'color',
                        'name'   => 'general_price_color',
                        'tab' => 'general',
                        'label'  => $this->l('Price Color'),
                        'selector' => '.price',
                        'css_property' => 'color',
                    ),
                    array(
                        'type' => 'switch',
                        'name' => 'general_cookies',
                        'label' => $this->l('Show Cookie Message'),
                        'col' => 8,
                        'tab' => 'general',
                        'values' => array(
                            array(
                              'id'    => 'active_on',
                              'value' => true,
                              'label' => $this->l('Yes'),
                            ),
                            array(
                              'id'    => 'active_off',
                              'value' => false,
                              'label' => $this->l('No'),
                            ),
                        ),
                    ),
                    array(
                        'type' => 'switch',
                        'name' => 'general_googleanalytics_state',
                        'label' => $this->l('Enable Google Analytics'),
                        'col' => 8,
                        'tab' => 'general',
                        'values' => array(
                            array(
                              'id'    => 'active_on',
                              'value' => true,
                              'label' => $this->l('Yes'),
                            ),
                            array(
                              'id'    => 'active_off',
                              'value' => false,
                              'label' => $this->l('No'),
                            ),
                        ),
                    ),
                    array(
                        'type'   => 'text',
                        'name'   => 'general_googleanalytics_id',
                        'tab' => 'general',
                        'label'  => $this->l('Google Analytics ID'),
                        'value'  => '#',
                        'col' => 6,
                    ),
                    array(
                        'type' => 'switch',
                        'name' => 'general_fbpixel_state',
                        'label' => $this->l('Enable Facebook Pixel Analytics'),
                        'col' => 8,
                        'tab' => 'general',
                        'values' => array(
                            array(
                              'id'    => 'active_on',
                              'value' => true,
                              'label' => $this->l('Yes'),
                            ),
                            array(
                              'id'    => 'active_off',
                              'value' => false,
                              'label' => $this->l('No'),
                            ),
                        ),
                    ),
                    array(
                        'type'   => 'text',
                        'name'   => 'general_fbpixel_id',
                        'tab' => 'general',
                        'label'  => $this->l('Facebook Pixel ID'),
                        'value'  => '#',
                        'col' => 6,
                    ),
                    array(
                        'type' => 'html',
                        'html_content' => '<button class="btn btn-default" type="submit" name="resetAmpConfiguration" value="1">'. $this->l('Reset') .'</button>',
                        'name' => '',
                        'tab' => 'general',
                        'label'  => $this->l('Reset AMP Settings'),
                        'col' => 9,
                    ),
                    // MENU
                    array(
                        'type' => 'html',
                        'html_content' => '<h2 class="ap-title">'. $this->l('Menu Settings') .'</h2><hr>',
                        'name' => '',
                        'tab' => 'menu',
                        'label' => '',
                        'col' => 12,
                    ),
                    array(
                        'type' => 'html',
                        'html_content' => '<label class="control-label"><a href="'.$menuAdminLink.'">'.$this->l('Menu Configuration') .'</a></label>',
                        'name' => '',
                        'tab' => 'menu',
                        'label' => 'Build Your Menu',
                        'col' => 9,
                    ),
                    array(
                        'type'   => 'color',
                        'name'   => 'menu_bar_bg',
                        'tab' => 'menu',
                        'label'  => $this->l('Menu Bar Background Сolor'),
                        'selector' => '.main-menu',
                        'css_property' => 'background',
                    ),
                    array(
                        'type'   => 'color',
                        'name'   => 'menu_bar_font_color',
                        'tab' => 'menu',
                        'label'  => $this->l('Menu Bar Font Сolor'),
                        'selector' => '.main-menu',
                        'css_property' => 'color',
                    ),
                    array(
                        'type'   => 'color',
                        'name'   => 'menu_items_bg',
                        'tab' => 'menu',
                        'label'  => $this->l('Menu Items Background Сolor'),
                        'selector' => '#selector-menu section',
                        'css_property' => 'background',
                    ),
                    array(
                        'type'   => 'color',
                        'name'   => 'menu_items_color',
                        'tab' => 'menu',
                        'label'  => $this->l('Menu Items Text Сolor'),
                        'selector' => '#selector-menu ul',
                        'css_property' => 'color',
                    ),
                    // SIDEBARS
                    array(
                        'type' => 'html',
                        'html_content' => '<h2 class="ap-title">'. $this->l('Sidebar Settings') .'</h2><hr>',
                        'name' => '',
                        'tab' => 'sidebars',
                        'label' => '',
                        'col' => 12,
                    ),
                    array(
                        'type'   => 'color',
                        'name'   => 'sidebars_bg',
                        'tab' => 'sidebars',
                        'label'  => $this->l('Sidebars Background Сolor'),
                        'selector' => 'amp-sidebar',
                        'css_property' => 'background',
                    ),
                    array(
                        'type'   => 'color',
                        'name'   => 'sidebars_title_color',
                        'tab' => 'sidebars',
                        'label'  => $this->l('Sidebars Title Сolor'),
                        'selector' => '.close-section h4',
                        'css_property' => 'color',
                    ),
                    array(
                        'type'   => 'color',
                        'name'   => 'sidebars_content_color',
                        'tab' => 'sidebars',
                        'label'  => $this->l('Sidebars Content Сolor'),
                        'selector' => 'amp-sidebar',
                        'css_property' => 'color',
                    ),
                    array(
                        'type' => 'switch',
                        'name' => 'sidebars_currencies',
                        'label' => $this->l('Show Currencies'),
                        'col' => 8,
                        'tab' => 'sidebars',
                        'values' => array(
                            array(
                              'id'    => 'active_on',
                              'value' => true,
                              'label' => $this->l('Yes'),
                            ),
                            array(
                              'id'    => 'active_off',
                              'value' => false,
                              'label' => $this->l('No'),
                            ),
                        ),
                    ),
                    array(
                        'type' => 'switch',
                        'name' => 'sidebars_lng',
                        'label' => $this->l('Show Languages'),
                        'col' => 8,
                        'tab' => 'sidebars',
                        'values' => array(
                            array(
                              'id'    => 'active_on',
                              'value' => true,
                              'label' => $this->l('Yes'),
                            ),
                            array(
                              'id'    => 'active_off',
                              'value' => false,
                              'label' => $this->l('No'),
                            ),
                        ),
                    ),
                    // HEADER
                    array(
                        'type' => 'html',
                        'html_content' => '<h2 class="ap-title">'. $this->l('Header Settings') .'</h2><hr>',
                        'name' => '',
                        'tab' => 'header_conf',
                        'label' => '',
                        'col' => 12,
                    ),
                    array(
                        'type'   => 'color',
                        'name'   => 'header_background_color',
                        'tab' => 'header_conf',
                        'label'  => $this->l('Header Background Сolor'),
                        'selector' => 'header.general-item',
                        'css_property' => 'background',
                    ),
                    array(
                        'type'   => 'color',
                        'name'   => 'header_content_color',
                        'tab' => 'header_conf',
                        'label'  => $this->l('Header Content Сolor'),
                        'selector' => 'header .header-top, header .header-top button',
                        'css_property' => 'color',
                    ),
                    array(
                        'type' => 'switch',
                        'name' => 'header_cartnumber',
                        'label' => $this->l('Show Products in Cart Number'),
                        'col' => 8,
                        'tab' => 'header_conf',
                        'values' => array(
                            array(
                              'id'    => 'active_on',
                              'value' => true,
                              'label' => $this->l('Yes'),
                            ),
                            array(
                              'id'    => 'active_off',
                              'value' => false,
                              'label' => $this->l('No'),
                            ),
                        ),
                    ),
                    // FOOTER
                    array(
                        'type' => 'html',
                        'html_content' => '<h2 class="ap-title">'. $this->l('Footer Settings') .'</h2><hr>',
                        'name' => '',
                        'tab' => 'footer_conf',
                        'label' => '',
                        'col' => 12,
                    ),
                    array(
                        'type'   => 'color',
                        'name'   => 'footer_background_color',
                        'tab' => 'footer_conf',
                        'label'  => $this->l('Footer Background Сolor'),
                        'selector' => '#footer',
                        'css_property' => 'background',
                    ),
                    array(
                        'type'   => 'color',
                        'name'   => 'footer_content_color',
                        'tab' => 'footer_conf',
                        'label'  => $this->l('Footer Content Сolor'),
                        'selector' => '#footer',
                        'css_property' => 'color',
                    ),
                    array(
                        'type' => 'switch',
                        'name' => 'footer_checkoutbtn',
                        'label' => $this->l('Show Quick Checkout Button'),
                        'col' => 8,
                        'tab' => 'footer_conf',
                        'values' => array(
                            array(
                              'id'    => 'active_on',
                              'value' => true,
                              'label' => $this->l('Yes'),
                            ),
                            array(
                              'id'    => 'active_off',
                              'value' => false,
                              'label' => $this->l('No'),
                            ),
                        ),
                    ),
                    array(
                        'type' => 'html',
                        'html_content' => '<h3 class="modal-title">'. $this->l('Social Networks') .'</h3>',
                        'name' => '',
                        'tab' => 'footer_conf',
                        'label' => '',
                        'col' => 12,
                    ),
                    array(
                        'type' => 'switch',
                        'name' => 'footer_socialdisplay',
                        'label' => $this->l('Display Social Icons'),
                        'col' => 8,
                        'tab' => 'footer_conf',
                        'values' => array(
                            array(
                              'id'    => 'active_on',
                              'value' => true,
                              'label' => $this->l('Yes'),
                            ),
                            array(
                              'id'    => 'active_off',
                              'value' => false,
                              'label' => $this->l('No'),
                            ),
                        ),
                    ),
                    array(
                        'type'   => 'text',
                        'name'   => 'footer_social_facebook',
                        'hint' => $this->l('The icon will not appear if the link is empty'),
                        'tab' => 'footer_conf',
                        'label'  => $this->l('Facebook Link'),
                        'value'  => '#',
                        'col' => 6,
                    ),
                    array(
                        'type'   => 'text',
                        'name'   => 'footer_social_twitter',
                        'hint' => $this->l('The icon will not appear if the link is empty'),
                        'tab' => 'footer_conf',
                        'label'  => $this->l('Twitter Link'),
                        'value'  => '#',
                        'col' => 6,
                    ),
                    array(
                        'type'   => 'text',
                        'name'   => 'footer_social_pinterest',
                        'hint' => $this->l('The icon will not appear if the link is empty'),
                        'tab' => 'footer_conf',
                        'label'  => $this->l('Pinterest Link'),
                        'value'  => '#',
                        'col' => 6,
                    ),
                    array(
                        'type'   => 'text',
                        'name'   => 'footer_social_linkedin',
                        'hint' => $this->l('The icon will not appear if the link is empty'),
                        'tab' => 'footer_conf',
                        'label'  => $this->l('Linkedin Link'),
                        'value'  => '#',
                        'col' => 6,
                    ),
                    array(
                        'type'   => 'text',
                        'name'   => 'footer_social_instagram',
                        'hint' => $this->l('The icon will not appear if the link is empty'),
                        'tab' => 'footer_conf',
                        'label'  => $this->l('Instagram Link'),
                        'value'  => '#',
                        'col' => 6,
                    ),
                    array(
                        'type'   => 'text',
                        'name'   => 'footer_social_flickr',
                        'hint' => $this->l('The icon will not appear if the link is empty'),
                        'tab' => 'footer_conf',
                        'label'  => $this->l('Flickr Link'),
                        'value'  => '#',
                        'col' => 6,
                    ),
                    array(
                        'type'   => 'text',
                        'name'   => 'footer_social_youtube',
                        'hint' => $this->l('The icon will not appear if the link is empty'),
                        'tab' => 'footer_conf',
                        'label'  => $this->l('Youtube Link'),
                        'value'  => '#',
                        'col' => 6,
                    ),
                    array(
                        'type' => 'html',
                        'html_content' => '<h3 class="modal-title">'. $this->l('Payment Systems') .'</h3>',
                        'name' => '',
                        'tab' => 'footer_conf',
                        'label' => '',
                        'col' => 12,
                    ),
                    array(
                        'type' => 'switch',
                        'name' => 'footer_paymentdisplay',
                        'label' => $this->l('Display Payment Icons'),
                        'col' => 8,
                        'tab' => 'footer_conf',
                        'values' => array(
                            array(
                              'id'    => 'active_on',
                              'value' => true,
                              'label' => $this->l('Yes'),
                            ),
                            array(
                              'id'    => 'active_off',
                              'value' => false,
                              'label' => $this->l('No'),
                            ),
                        ),
                    ),
                    array(
                        'type' => 'switch',
                        'name' => 'footer_payment_paypal',
                        'label' => $this->l('Display Paypal Icon'),
                        'col' => 8,
                        'tab' => 'footer_conf',
                        'values' => array(
                            array(
                              'id'    => 'active_on',
                              'value' => true,
                              'label' => $this->l('Yes'),
                            ),
                            array(
                              'id'    => 'active_off',
                              'value' => false,
                              'label' => $this->l('No'),
                            ),
                        ),
                    ),
                    array(
                        'type' => 'switch',
                        'name' => 'footer_payment_skrill',
                        'label' => $this->l('Display Skrill Icon'),
                        'col' => 8,
                        'tab' => 'footer_conf',
                        'values' => array(
                            array(
                              'id'    => 'active_on',
                              'value' => true,
                              'label' => $this->l('Yes'),
                            ),
                            array(
                              'id'    => 'active_off',
                              'value' => false,
                              'label' => $this->l('No'),
                            ),
                        ),
                    ),
                    array(
                        'type' => 'switch',
                        'name' => 'footer_payment_visa',
                        'label' => $this->l('Display Visa Icon'),
                        'col' => 8,
                        'tab' => 'footer_conf',
                        'values' => array(
                            array(
                              'id'    => 'active_on',
                              'value' => true,
                              'label' => $this->l('Yes'),
                            ),
                            array(
                              'id'    => 'active_off',
                              'value' => false,
                              'label' => $this->l('No'),
                            ),
                        ),
                    ),
                    array(
                        'type' => 'switch',
                        'name' => 'footer_payment_mastercard',
                        'label' => $this->l('Display Mastercard Icon'),
                        'col' => 8,
                        'tab' => 'footer_conf',
                        'values' => array(
                            array(
                              'id'    => 'active_on',
                              'value' => true,
                              'label' => $this->l('Yes'),
                            ),
                            array(
                              'id'    => 'active_off',
                              'value' => false,
                              'label' => $this->l('No'),
                            ),
                        ),
                    ),
                    array(
                        'type' => 'switch',
                        'name' => 'footer_payment_amexpress',
                        'label' => $this->l('Display American Express Icon'),
                        'col' => 8,
                        'tab' => 'footer_conf',
                        'values' => array(
                            array(
                              'id'    => 'active_on',
                              'value' => true,
                              'label' => $this->l('Yes'),
                            ),
                            array(
                              'id'    => 'active_off',
                              'value' => false,
                              'label' => $this->l('No'),
                            ),
                        ),
                    ),
                    array(
                        'type' => 'switch',
                        'name' => 'footer_payment_discover',
                        'label' => $this->l('Display Discover Icon'),
                        'col' => 8,
                        'tab' => 'footer_conf',
                        'values' => array(
                            array(
                              'id'    => 'active_on',
                              'value' => true,
                              'label' => $this->l('Yes'),
                            ),
                            array(
                              'id'    => 'active_off',
                              'value' => false,
                              'label' => $this->l('No'),
                            ),
                        ),
                    ),
                    array(
                        'type' => 'switch',
                        'name' => 'footer_payment_cirrus',
                        'label' => $this->l('Display Cirrus Icon'),
                        'col' => 8,
                        'tab' => 'footer_conf',
                        'values' => array(
                            array(
                              'id'    => 'active_on',
                              'value' => true,
                              'label' => $this->l('Yes'),
                            ),
                            array(
                              'id'    => 'active_off',
                              'value' => false,
                              'label' => $this->l('No'),
                            ),
                        ),
                    ),
                    array(
                        'type' => 'switch',
                        'name' => 'footer_payment_bitcoin',
                        'label' => $this->l('Display Bitcoin Icon'),
                        'col' => 8,
                        'tab' => 'footer_conf',
                        'values' => array(
                            array(
                              'id'    => 'active_on',
                              'value' => true,
                              'label' => $this->l('Yes'),
                            ),
                            array(
                              'id'    => 'active_off',
                              'value' => false,
                              'label' => $this->l('No'),
                            ),
                        ),
                    ),
                    array(
                        'type' => 'switch',
                        'name' => 'footer_payment_apple',
                        'label' => $this->l('Display Apple Pay Icon'),
                        'col' => 8,
                        'tab' => 'footer_conf',
                        'values' => array(
                            array(
                              'id'    => 'active_on',
                              'value' => true,
                              'label' => $this->l('Yes'),
                            ),
                            array(
                              'id'    => 'active_off',
                              'value' => false,
                              'label' => $this->l('No'),
                            ),
                        ),
                    ),
                    array(
                        'type' => 'html',
                        'html_content' => '<h3 class="modal-title">'. $this->l('Footer Message') .'</h3>',
                        'name' => '',
                        'tab' => 'footer_conf',
                        'label' => '',
                        'col' => 12,
                    ),
                    array(
                        'type'   => 'text',
                        'name'   => 'footer_message_lang',
                        'tab' => 'footer_conf',
                        'label'  => $this->l('Text'),
                        'lang' => true,
                        'col' => 9,
                    ),
                    // HOMEPAGE
                    array(
                        'type' => 'html',
                        'html_content' => '<h2 class="ap-title">'. $this->l('Home Page') .'</h2><hr>',
                        'name' => '',
                        'tab' => 'home_page',
                        'label' => '',
                        'col' => 12,
                    ),
                    array(
                        'type' => 'html',
                        'html_content' => '<label class="control-label"><a href="'.$builderAdminLink.'">'.$this->l('HomePage Configuration') .'</a></label>',
                        'name' => '',
                        'tab' => 'home_page',
                        'label' => 'Build Your Homepage',
                        'col' => 9,
                    ),
                    // CATEGORY PAGE
                    array(
                        'type' => 'html',
                        'html_content' => '<h2 class="ap-title">'. $this->l('Сategory Page') .'</h2><hr>',
                        'name' => '',
                        'tab' => 'category_page',
                        'label' => '',
                        'col' => 12,
                    ),
                    array(
                        'type' => 'switch',
                        'name' => 'category_image',
                        'label' => $this->l('Display Category Image'),
                        'col' => 8,
                        'tab' => 'category_page',
                        'values' => array(
                            array(
                              'id'    => 'active_on',
                              'value' => true,
                              'label' => $this->l('Yes'),
                            ),
                            array(
                              'id'    => 'active_off',
                              'value' => false,
                              'label' => $this->l('No'),
                            ),
                        ),
                    ),
                    array(
                        'type' => 'switch',
                        'name' => 'category_description',
                        'label' => $this->l('Display Category Description'),
                        'col' => 8,
                        'tab' => 'category_page',
                        'values' => array(
                            array(
                              'id'    => 'active_on',
                              'value' => true,
                              'label' => $this->l('Yes'),
                            ),
                            array(
                              'id'    => 'active_off',
                              'value' => false,
                              'label' => $this->l('No'),
                            ),
                        ),
                    ),
                    array(
                        'type' => 'switch',
                        'name' => 'category_subcategories',
                        'label' => $this->l('Display Subcategories'),
                        'col' => 8,
                        'tab' => 'category_page',
                        'values' => array(
                            array(
                              'id'    => 'active_on',
                              'value' => true,
                              'label' => $this->l('Yes'),
                            ),
                            array(
                              'id'    => 'active_off',
                              'value' => false,
                              'label' => $this->l('No'),
                            ),
                        ),
                    ),
                    array(
                        'type' => 'switch',
                        'name' => 'category_product_filter',
                        'label' => $this->l('Display Product Filter'),
                        'col' => 8,
                        'tab' => 'category_page',
                        'values' => array(
                            array(
                              'id'    => 'active_on',
                              'value' => true,
                              'label' => $this->l('Yes'),
                            ),
                            array(
                              'id'    => 'active_off',
                              'value' => false,
                              'label' => $this->l('No'),
                            ),
                        ),
                    ),
                    array(
                        'type' => 'switch',
                        'name' => 'category_product_labels',
                        'label' => $this->l('Display Product Labels'),
                        'col' => 8,
                        'tab' => 'category_page',
                        'values' => array(
                            array(
                              'id'    => 'active_on',
                              'value' => true,
                              'label' => $this->l('Yes'),
                            ),
                            array(
                              'id'    => 'active_off',
                              'value' => false,
                              'label' => $this->l('No'),
                            ),
                        ),
                    ),
                    // PRODUCT PAGE
                    array(
                        'type' => 'html',
                        'html_content' => '<h2 class="ap-title">'. $this->l('Product Page') .'</h2><hr>',
                        'name' => '',
                        'tab' => 'product_page',
                        'label' => '',
                        'col' => 12,
                    ),
                    array(
                        'type' => 'switch',
                        'name' => 'product_brand',
                        'label' => $this->l('Show Product Brand'),
                        'col' => 8,
                        'tab' => 'product_page',
                        'values' => array(
                            array(
                              'id'    => 'active_on',
                              'value' => true,
                              'label' => $this->l('Yes'),
                            ),
                            array(
                              'id'    => 'active_off',
                              'value' => false,
                              'label' => $this->l('No'),
                            ),
                        ),
                    ),
                    array(
                        'type' => 'switch',
                        'name' => 'product_shortdescription',
                        'label' => $this->l('Show Product Short Description'),
                        'col' => 8,
                        'tab' => 'product_page',
                        'values' => array(
                            array(
                              'id'    => 'active_on',
                              'value' => true,
                              'label' => $this->l('Yes'),
                            ),
                            array(
                              'id'    => 'active_off',
                              'value' => false,
                              'label' => $this->l('No'),
                            ),
                        ),
                    ),
                    array(
                        'type' => 'switch',
                        'name' => 'product_accessories',
                        'label' => $this->l('Show Product Accessories'),
                        'col' => 8,
                        'tab' => 'product_page',
                        'values' => array(
                            array(
                              'id'    => 'active_on',
                              'value' => true,
                              'label' => $this->l('Yes'),
                            ),
                            array(
                              'id'    => 'active_off',
                              'value' => false,
                              'label' => $this->l('No'),
                            ),
                        ),
                    ),
                    array(
                        'type' => 'switch',
                        'name' => 'product_samecategory',
                        'label' => $this->l('Show In The Same Category'),
                        'col' => 8,
                        'tab' => 'product_page',
                        'values' => array(
                            array(
                              'id'    => 'active_on',
                              'value' => true,
                              'label' => $this->l('Yes'),
                            ),
                            array(
                              'id'    => 'active_off',
                              'value' => false,
                              'label' => $this->l('No'),
                            ),
                        ),
                    ),
                    array(
                        'type' => 'switch',
                        'name' => 'product_sizeguide',
                        'label' => $this->l('Show Size Guide (Must be enabled module)'),
                        'col' => 8,
                        'tab' => 'product_page',
                        'values' => array(
                            array(
                              'id'    => 'active_on',
                              'value' => true,
                              'label' => $this->l('Yes'),
                            ),
                            array(
                              'id'    => 'active_off',
                              'value' => false,
                              'label' => $this->l('No'),
                            ),
                        ),
                    ),
                    array(
                        'type' => 'switch',
                        'name' => 'product_carousel_autoplay',
                        'label' => $this->l('Product Carousel Autoplay'),
                        'col' => 8,
                        'tab' => 'product_page',
                        'values' => array(
                            array(
                              'id'    => 'active_on',
                              'value' => true,
                              'label' => $this->l('Yes'),
                            ),
                            array(
                              'id'    => 'active_off',
                              'value' => false,
                              'label' => $this->l('No'),
                            ),
                        ),
                    ),
                    array(
                        'type' => 'switch',
                        'name' => 'product_carousel_controls',
                        'label' => $this->l('Always Show Product Carousel Arrows'),
                        'col' => 8,
                        'tab' => 'product_page',
                        'values' => array(
                            array(
                              'id'    => 'active_on',
                              'value' => true,
                              'label' => $this->l('Yes'),
                            ),
                            array(
                              'id'    => 'active_off',
                              'value' => false,
                              'label' => $this->l('No'),
                            ),
                        ),
                    ),
                    array(
                        'type'   => 'text',
                        'name'   => 'product_carousel_delay',
                        'tab' => 'product_page',
                        'label'  => $this->l('Product Carousel Delay'),
                        'value'  => '',
                        'col' => 2,
                        'suffix' => 'ms'
                    ),
                    array(
                        'type'   => 'text',
                        'name'   => 'product_pricesize',
                        'tab' => 'product_page',
                        'label'  => $this->l('Product Price Size'),
                        'selector' => '#product .product-price-amp .price',
                        'css_property' => 'font-size',
                        'col' => 2,
                        'suffix' => 'px'
                    ),
                    // DOCUMENTATION
                    array(
                        'type' => 'html',
                        'html_content' => '<h2 class="ap-title">'. $this->l('Documentation') .'</h2><hr>',
                        'name' => '',
                        'tab' => 'documentation',
                        'label' => '',
                        'col' => 12,
                    ),
                    array(
                        'type' => 'html',
                        'html_content' => '<label class="control-label"><a href="#">'.$this->l('Open') .'</a></label>',
                        'name' => '',
                        'tab' => 'documentation',
                        'label' => 'Documentation Link',
                        'col' => 9,
                    ),
                ),
                'submit' => array(
                    'title' => $this->l('Save'),
                ),
            ),
        );
    }

}