<?php

if (!defined('_PS_VERSION_'))
	exit;

use PrestaShop\PrestaShop\Core\Module\WidgetInterface;

class Pk_Contact extends Module implements WidgetInterface
{
  function __construct()
  {
		$this->name = 'pk_contact';
		$this->version = '1.0';
		$this->author = 'promokit.eu';
		$this->templateFile = 'module:'.$this->name.'/'.$this->name.'.tpl';
		$this->ps_versions_compliancy = array('min' => '1.7.0.0', 'max' => _PS_VERSION_);

		$this->bootstrap = true;
		parent::__construct();	

		$this->displayName = $this->trans('Contact Form');
		$this->description = $this->trans('Display Contact Form');
	}

	public function install() {
		return parent::install() && $this->registerHook('displayHeader');
	}
	
	public function uninstall()
	{
		return true;
	}

  public function hookDisplayHeader()
  {
    $this->context->controller->registerJavascript($this->name, 'modules/'.$this->name.'/views/assets/js/scripts.js', ['position' => 'bottom', 'priority' => 430, 'attributes' => 'async']);
  }

	public function renderWidget($hookName, array $params)
  {
      return $this->fetch($this->templateFile);
  }

  public function getWidgetVariables($hookName, array $params)
  {
      return true;
  }

}