$(document).ready(function(){

	if ( $('.pk-dailydeal-products')[0] ) {

		var SiemaSlider = new Siema({
		  selector: '.pk-dailydeal-products',
		  duration: 400,
		  easing: 'cubic-bezier(0.23, 1, 0.32, 1)',
		  perPage: 1,
		  startIndex: 0,
		  draggable: true,
		  threshold: 20,
		  loop: true,
		  onInit: updateInfoSection,
		  onChange: updateInfoSection,
		});

		$('.pk-dd-prev').click(function(){
			SiemaSlider.prev()
		});
		$('.pk-dd-next').click(function(){
			SiemaSlider.next()
		});

		function updateInfoSection() {
			var current_slide = this.innerElements[this.currentSlide],
				current_id = current_slide.getAttribute("data-id-product"),
				current_link = $(current_slide).find('.thumbnail > a').attr('href'),
				$container = $('.pk-dd-countdowns'),
				$btn = $('.btn-current-link'),
				$products = $('.pk-dailydeal-products');
			
			$products.find("article").removeClass('activeSlide');
			$products.find("[data-id-product='" + current_id + "']").addClass('activeSlide');
			$container.find('.countdown').hide(400);
			$container.find('.countdown-'+current_id).show(400);
			$btn.attr('href', current_link);
		}
	}

});