<?php
/*
* Promokit Facebook Comments Module
*
* @package   alysum
* @version   5.0
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2018 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
*/
class pk_facebookcomments extends Module
{
    function __construct()
    {
        $this->name = 'pk_facebookcomments';
        $this->tab = 'social_networks';
        $this->version = '1.0';
        $this->author = 'promokit.eu';
        $this->bootstrap = true;
        $this->dir = '/modules/pk_facebookcomments/';
        parent::__construct();
        $this->displayName = $this->l('Facebook Comments');
        $this->description = $this->l('An easiest way to add facebook comments plugin for your prestashop store');
        $this->mkey = "freelicense";
    }

    public function install()
    {
        if (
          parent::install() == false or
          !$this->registerHook('displayProductExtraContent') OR
          !Configuration::updateValue('update_' . $this->name, '0') OR
          !$this->registerHook('displayHeader') OR
          !$this->registerHook('displayProductFooter') OR
          !Configuration::updateValue('fcbc_where', '1'))
        {
            return false;
        }
        return true;
    }

    public function installconfiguration()
    {
        $fcbc_langarray = "";
        foreach (Language::getLanguages(false) AS $key => $value)
        {
            $fcbc_langarray[$key] = 'en_GB';
        }
        return $fcbc_langarray;
    }

    public function getconf()
    {
        $array['fcbc_where'] = Configuration::get('fcbc_where');
        $array['fcbc_url'] = Configuration::get('fcbc_url');
        $array['fcbc_width'] = Configuration::get('fcbc_width');
        $array['fcbc_nbp'] = Configuration::get('fcbc_nbp');
        $array['fcbc_scheme'] = Configuration::get('fcbc_scheme');
        $array['fcbc_lang'] = Configuration::get('fcbc_langarray', $this->context->language->id);
        $array['fcbc_admins'] = Configuration::get('fcbc_admins');
        $array['fcbc_appid'] = Configuration::get('fcbc_appid');
        $array['product_page_url'] = trim(strtok($_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'], '?'));
        return $array;
    }

    public function getContent()
    {
        $output = "";
        if (Tools::isSubmit('submit_settings'))
        {
            Configuration::updatevalue('fcbc_where', $_POST['fcbc_where']);
            //Configuration::updatevalue('fcbc_url',$_POST['fcbc_url']);
            Configuration::updatevalue('fcbc_width', $_POST['fcbc_width']);
            Configuration::updatevalue('fcbc_nbp', $_POST['fcbc_nbp']);
            Configuration::updatevalue('fcbc_scheme', $_POST['fcbc_scheme']);
            Configuration::updatevalue('fcbc_langarray', $_POST['fcbc_langarray']);
            Configuration::updatevalue('fcbc_admins', $_POST['fcbc_admins']);
            Configuration::updatevalue('fcbc_appid', $_POST['fcbc_appid']);
            Configuration::updateValue('fcbc_addappid', $_POST['fcbc_addappid']);
            $output .= $this->displayConfirmation($this->l('Settings Saved'));
        }
        return $output . $this->displayForm();
    }

    public function displayForm()
    {
        $var = $this->getconf();
        $fcbcwhere1 = "";
        $fcbcwhere2 = "";
        $fcbcwhere3 = "";
        $fcbcwhere4 = "";
        $fcbcscheme1 = "";
        $fcbcscheme2 = "";
        if ($var['fcbc_where'] == "1")
        {
            $fcbcwhere1 = "checked=\"yes\"";
        }
        if ($var['fcbc_where'] == "2")
        {
            $fcbcwhere2 = "checked=\"yes\"";
        }
        if ($var['fcbc_where'] == "3")
        {
            $fcbcwhere3 = "checked=\"yes\"";
        }
        if ($var['fcbc_where'] == "4")
        {
            $fcbcwhere4 = "checked=\"yes\"";
        }
        if ($var['fcbc_scheme'] == "dark")
        {
            $fcbcscheme2 = "selected=\"yes\"";
        }
        if ($var['fcbc_scheme'] == "light")
        {
            $fcbcscheme1 = "selected=\"yes\"";
        }

        $form = '<div id="module_block_settings">
                <form action="' . $_SERVER['REQUEST_URI'] . '" method="post" class="form-horizontal">
                <div class="panel">
                  <div class="panel-heading"><i class="icon-cogs"></i> Settings</div>
                  <div class="form-wrapper">
                    <div class="form-group">
                      <label class="control-label col-lg-3">' . $this->l('Tabs Location') . '</label>
                      <div class="margin-form col-lg-9">
                          <input type="radio" name="fcbc_where" value="1" ' . $fcbcwhere1 . '/>&nbsp;<span>' . $this->l('Product Tabs') . '</span><br>
                          <input type="radio" name="fcbc_where" value="2" ' . $fcbcwhere2 . '/>&nbsp;<span>' . $this->l('Product Footer') . '</span>
                      </div>
                    </div>
                    <div class="form-group">
                      <label class="control-label col-lg-3">' . $this->l('Comments feed width') . '</label>
                      <div class="margin-form col-lg-9">
                          <input type="text" name="fcbc_width" value="' . $var['fcbc_width'] . '"/>
                      </div>
                    </div>
                    <div class="form-group">
                      <label class="control-label col-lg-3">' . $this->l('Number of comments') . '</label>
                      <div class="margin-form col-lg-9">
                          <input type="text" name="fcbc_nbp" value="' . $var['fcbc_nbp'] . '"/>
                      </div>
                    </div>
                    <div class="form-group" style="display:none">
                      <label class="control-label col-lg-3">' . $this->l('Color scheme') . '</label>
                      <div class="margin-form col-lg-9">
                          <select name="fcbc_scheme"/>
                              <option value="light" ' . $fcbcscheme1 . '>' . $this->l('light') . '</option>
                              <option value="dark" ' . $fcbcscheme2 . '>' . $this->l('dark') . '</option>
                          </select>
                      </div>
                    </div>
                    <div class="form-group">
                      <label class="control-label col-lg-3">' . $this->l('Admins') . '</label>
                      <div class="margin-form col-lg-9">
                          <input type="text" name="fcbc_admins" value="' . $var['fcbc_admins'] . '"/>
                          <p class="clear">' . $this->l('Grant moderation privileges for selected facebook accounts.') . ' ' . $this->l('Separate all admin IDs by commas') . ' ' . $this->l('(ID of facebook private profile)') . '</p>
                      </div>
                    </div>
                    <div class="form-group">
                      <label class="control-label col-lg-3">' . $this->l('Include Facebook APP') . '</label>
                      <div class="margin-form col-lg-9">
                          <select name="fcbc_addappid"/>
                              <option value="1" ' . (configuration::get('fcbc_addappid') == 1 ? 'selected="selected"' : '') . '>' . $this->l('Yes') . '</option>
                              <option value="0" ' . (configuration::get('fcbc_addappid') != 1 ? 'selected="selected"' : '') . '>' . $this->l('No') . '</option>
                          </select>
                      </div>
                    </div>
                    <div class="form-group">
                      <label class="control-label col-lg-3">' . $this->l('APP id') . '</label>
                      <div class="margin-form col-lg-9">
                          <input type="text" name="fcbc_appid" value="' . $var['fcbc_appid'] . '"/>
                          <p class="clear">' . $this->l('You can use own facebook app') . '</p>
                      </div>
                    </div>
                  </div>
                  <div class="panel-footer">
											<button type="submit" value="1" id="submit_settings_submit_btn" name="submit_settings" class="btn btn-default pull-right">
                      <i class="process-icon-save"></i> Save</button>
                  </div>
                </div>
            </form>
        </div>
        ';
        return '<div class="bootstrap">' . $form . '</div>';
    }

    public function hookDisplayHeader($params)
    {
      if (isset($this->context->controller->php_self) && $this->context->controller->php_self == 'product') {
        $var = $this->getconf();
        $this->context->smarty->assign('var', $var);
        return $this->display(__FILE__, 'views/templates/hook/header.tpl');
      }
    }

    public function hookdisplayProductFooter($params)
    {
        if (isset($_GET['id_product']) && isset($_GET['controller']))
        {
            if ($_GET['controller'] == 'product')
            {
                $var = $this->getconf();
                $this->context->smarty->assign('var', $var);
                if ($var['fcbc_where'] == 2)
                {
                    return $this->display(__FILE__, 'views/templates/hook/productfooter.tpl');
                }
            }
        }
    }

    public function hookdisplayProductExtraContent($params)
    {
        $var = $this->getconf();
        $this->context->smarty->assign('var', $var);
        if ($var['fcbc_where'] == 1)
        {
            $ps17tabz[] = (new PrestaShop\PrestaShop\Core\Product\ProductExtraContent())->setTitle($this->l('Facebook Comments'))->setContent($this->context->smarty->fetch('module:pk_facebookcomments/views/templates/hook/tabcontents.tpl'));
            return $ps17tabz;
        }
    }

}

?>
