<?php

if (!defined('_PS_VERSION_'))
	exit;

class Pk_FacebookConnect extends Module{

	public $error = "";
	public $fb_login_page;
	public $fb_on;
	public $fb_app_id;
	public $fb_position_top;
	public $fb_position_right;
	public $fb_position_left;

	public function __construct(){
		$this->name = 'pk_facebookconnect';
		$this->tab = 'front_office_features';
		$this->version = '1.0.0';
		$this->author = 'promokit.eu';
		$this->need_instance = 0;
		$this->bootstrap = true;

		parent::__construct();

		$this->_globalVars();

		$this->displayName = $this->l('Facebook Connect');
		$this->description = $this->l('Allow your customers to sign in with Facebook');
		$this->confirmUninstall = $this->l('Are you sure you want to uninstall?');
	}

	public function install(){
		if (!parent::install()
			|| !$this->registerHook('displayHeader')
			|| !$this->registerHook('displayFacebookConnect')
			|| !$this->registerHook('displayAfterBodyOpeningTag')
			|| !$this->createFbTable()

			|| !Configuration::updateValue('HI_FB_LOGIN_PAGE', 'no_redirect')
			|| !Configuration::updateValue('HI_FB_ON', false)
			|| !Configuration::updateValue('HI_FB_APP_ID', '')
		)
			return false;

		return true;
	}

	public function uninstall(){
		if (!parent::uninstall())
			return false;
			$this->dropFbTable();
		return true;
	}

	private function createFbTable (){
		$sql = 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'pk_facebookusers` (
		   `id`            INT NOT NULL AUTO_INCREMENT,
		   `id_user`       VARCHAR (100) NOT NULL,
		   `id_shop_group` INT (11) NOT NULL,
		   `id_shop`       INT (11) NOT NULL,
		   `first_name`    VARCHAR (100) NOT NULL,
		   `last_name`     VARCHAR (100) NOT NULL,
		   `email`         VARCHAR (100) NOT NULL,
		   `gender`        VARCHAR (100) NOT NULL,
		   `birthday`      DATE NOT NULL,
		   `date_add`      DATE NOT NULL,
		   `date_upd`      DATE NOT NULL,
		   PRIMARY KEY     ( `id` )
		) ENGINE = '._MYSQL_ENGINE_.' DEFAULT CHARSET=UTF8;';
		return Db::getInstance()->Execute(trim($sql));
	}

	private function dropFbTable(){
		return DB::getInstance()->execute("DROP TABLE IF EXISTS "._DB_PREFIX_."pk_facebookusers");
	}

	private function _globalVars(){
		$this->fb_login_page = Configuration::get('HI_FB_LOGIN_PAGE');
		$this->fb_on = (bool)Configuration::get('HI_FB_ON');
		$this->fb_app_id = Configuration::get('HI_FB_APP_ID');
	}

	private function isSelectedShopGroup(){
		if (Shop::getContext() == Shop::CONTEXT_GROUP || Shop::getContext() == Shop::CONTEXT_ALL)
			return true;
		else
			return false;
	}

	protected function isTableExists($table)
	{
		$sqlExistsTable = "SELECT * FROM information_schema.TABLES WHERE TABLE_SCHEMA=DATABASE()
			AND TABLE_NAME='" . _DB_PREFIX_ . $table . "'; ";
		$exists = Db::getInstance()->ExecuteS($sqlExistsTable);
		return !empty($exists);
	}

	public function _displayForm(){
		return $this->error.$this->generateAdminPage();
	}

	private function generateAdminPage(){
		$this->context->smarty->assign(array(
			'action' => Tools::safeOutput($_SERVER['REQUEST_URI']),
			'hi_fb_on' => $this->fb_on,
			'hi_fb_app_id' => $this->fb_app_id,
			'hi_login_page' => $this->fb_login_page
		));
		return $this->display(__FILE__, 'views/templates/admin/admin.tpl');
	}

	private function _postProcess(){
		Configuration::updateValue('HI_FB_LOGIN_PAGE', Tools::getValue('hi_fb_login_page'));
		Configuration::updateValue('HI_FB_ON', (bool)Tools::getValue('hi_fb_on'));
		Configuration::updateValue('HI_FB_APP_ID', trim(Tools::getValue('hi_fb_app_id')));
	}

	public function getContent(){
		$html = "";
		if (Tools::isSubmit('pk_fb_submit'))
			$this->_postProcess();

		$this->_globalVars();

		if (!$this->isSelectedShopGroup()){
			$html .= $this->_displayForm();
		}else{
			$html .= '
				<p class="alert alert-warning">'.
					$this->l('You cannot manage the module from a "All Shops" or a "Group Shop" context, select directly the shop you want to edit').'
				</p>';
		}
		return $html;
	}

	public function checkState()
	{
		if ($this->fb_on && $this->fb_app_id && !$this->context->customer->isLogged()) {
			return true;
		}
		return false;
	}

	public function hookDisplayHeader()
	{

		if ($this->checkState()) {
			$this->context->controller->registerJavascript('modules-facebookconnect', 'modules/'.$this->name.'/views/assets/js/scripts.js', ['position' => 'bottom', 'priority' => 150]);
		}

	}

	public function hookdisplayAfterBodyOpeningTag($params) {

		if ($this->checkState()) {
			$this->context->smarty->assign(array(
				'pk_fb_app_id' => $this->fb_app_id,
				'pk_fb_login_page' => $this->fb_login_page
			));

			return $this->display(__FILE__,'data.tpl');
		}

	}

	public function hookDisplayFacebookConnect($params){
		if ($this->checkState()) {
			return $this->display(__FILE__, 'facebookCustomHook.tpl');
		}
	}

	public function sendConfirmationMail(Customer $customer, $password){
		if (!Configuration::get('PS_CUSTOMER_CREATION_EMAIL'))
			return true;
		return Mail::Send(
			$this->context->language->id,
			'account',
			Mail::l('Welcome!'),
			array(
				'{firstname}' => $customer->firstname,
				'{lastname}' => $customer->lastname,
				'{email}' => $customer->email,
				'{passwd}' => $password),
			$customer->email,
			$customer->firstname.' '.$customer->lastname
		);
	}
}
