{*
* Promokit Favorites Module
*
* @package   alysum
* @version   1.0
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2018 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
*}
{assign var="pkfp_text" value=''}
{assign var="pkfp_class" value=''}
{if !$isCustomerFavoriteProduct AND $customer.is_logged}
  {assign var="pkfp_text" value={l s='Add to favorites' mod='pk_favorites'}}
  {assign var="pkfp_class" value='addToFav'}
{else if $isCustomerFavoriteProduct AND $customer.is_logged}
  {assign var="pkfp_text" value={l s='Remove from favorites' mod='pk_favorites'}}
  {assign var="pkfp_class" value='removeFromFav icon_checked'}
{else if !$customer.is_logged}
  {assign var="pkfp_text" value={l s='Add to favorites' mod='pk_favorites'}}
  {assign var="pkfp_title" value={l s='You have to login to add product to Favorites' mod='pk_favorites'}}
  {assign var="pkfp_class" value='loginToAdd'}
{/if}

{if $pkfp_text != ''}
<div class="wrap_alert relative dib">
  <a href="#" class="flex-container align-items-center favoritesButton icon-button {$pkfp_class}" title="{$pkfp_text}" data-pid="{$id_product|intval}">
    <svg class="svgic"><use xlink:href="#si-like-stroke"></use></svg><span>{$pkfp_text}</span>
  </a>
  {if !$customer.is_logged}
    <div class="alert_note">
      {l s='You must be logged in' mod='pk_favorites'}
      <p class="login_links">
          <a class="inline" href="{$link->getPageLink('my-account', true)}">{l s='Sign in' d='Shop.Theme.Actions'}</a> | <a class="inline" href="{$link->getPageLink('my-account', true)}">{l s='Register' d='Modules.Customersignin.Shop'}</a>
      </p>
    </div>
  {/if}
  {if $isCustomerFavoriteProduct AND $customer.is_logged}
    <div class="alert_note">
      {l s='This product is in your' mod='pk_favorites'}&nbsp;<a href="{$link->getModuleLink('pk_favorites', 'account', array(), true)}">{l s='favorites' mod='pk_favorites'}</a>
    </div>
  {/if}

</div>
{/if}