<?php
/**
 * 2017 PROMOKIT.EU
 *
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement
 *
 *  @author    PROMOKIT.EU <support@promokit.eu>
 *  @copyright 2017 PROMOKIT.EU
 *  @license   Commercial license (You can not resell or redistribute this software.)
 *
 */
include_once(_PS_MODULE_DIR_.'pk_lookbook/pk_lookbook.php');

class Pk_LookbookLookbookModuleFrontController extends ModuleFrontController
{
    /**
    * Assign template vars related to page content
    * @see FrontController::initContent()
    */
    public function initContent()
    {
        parent::initContent();

        $lookbooksClass = new Pk_Lookbook();

        $lookbooks = $lookbooksClass->getSlides();

        if (is_array($lookbooks)) {
            foreach ($lookbooks as &$lookbook) {
                $lookbook['products_list'] = array();
                $lookbook['sizes'] = @getimagesize((dirname(__FILE__) . DIRECTORY_SEPARATOR . 'images' . DIRECTORY_SEPARATOR . $lookbook['image']));
                if (isset($lookbook['sizes'][3]) && $lookbook['sizes'][3]) {
                    $lookbook['size'] = $lookbook['sizes'][3];
                }
                $lookbook['points'] = json_decode($lookbook['products']);
                if (is_object($lookbook['points'])) {
                  $products = '';
                  foreach ($lookbook['points'] as $point) {
                    $products .= $point->pid.',';
                  }
                  $lookbook['products_list'] = $lookbooksClass->getSelectedProducts(rtrim($products));
                }
            }
        }

        $config = $lookbooksClass->getConfigFieldsValues();

        $this->context->smarty->assign(
          array(
            'lookbook_list' => $lookbooks,
            'config' => $config,
          )

        );

        $this->setTemplate('module:pk_lookbook/views/templates/front/lookbook_list.tpl');

    }

    public function getBreadcrumbLinks()
    {
        $breadcrumb = parent::getBreadcrumbLinks();
        $title = "Lookbook";
        $breadcrumb['links'][] = array(
            'title' => $title,
            'url' => false,//Context::getContext()->link->getModuleLink('pk_lookbook', 'lookbook'),
        );

        return $breadcrumb;
    }
}
