$(document).ready(function() {

	$( "#all_products" ).change(function() {
	  var id = $(this).val(),
	  		$selected_input = $('#products'),
	  		current_selection = $selected_input.val();

	  $selected_input.val( ((current_selection == '') ? '' : current_selection+',') + id );

	});

	// show saved points
	var currentPoints = $('#products').val();
	var allPoints = getAllPoints();

	$.each(allPoints, function( index, value ) {
		pos = value.pos.split(',');
		value['parent'] = $('.img-container');
		value['id'] = index;
		value['posX'] = pos[0];
		value['posY'] = pos[1];
		value['point_sett'] = 'hidden';
		value['point'] = '';
	  showPoints(value);
	});

	$('.img-thumbnail').click(function(e){

		var $parent = $(this).parent(),
				points = $parent.find('span'),
				areaWidth = $(this).width(),
				areaHeight = $(this).height(),
				data = {};

		var offset_t = $(this).offset().top - $(window).scrollTop(),
    		offset_l = $(this).offset().left - $(window).scrollLeft(),
				posXpx = (e.clientX - offset_l),
				posYpx = (e.clientY - offset_t),
				posXperc = (posXpx*100/areaWidth).toFixed(2),
				posYperc = (posYpx*100/areaHeight).toFixed(2);
				//console.log(posXperc+' '+posYperc);

		data['parent'] = $parent;
    data['posX'] = posXperc;
    data['posY'] = posYperc;
		data['point'] = 'hidden';
		data['point_sett'] = '';
		data['id'] = 0;

		if ( points.last()[0] ) {
			 var lastID = points.last().data('id');
			 data['id'] = lastID+1;
		}

    showPoints(data);

	});

	// hide point settings
	$('body').on('click', '.close_point', function() {
		var $point = $(this).parent(),
				$el = $point.parent(),
				id = $point.data('id');

		$el.find("div[data-id='" + id + "']").toggleClass('hidden');
		$point.toggleClass('hidden');
	});

	// remove point
	$('body').on('click', '.remove_prd', function() {
		var $point = $(this).parent(),
				$el = $point.parent(),
				id = $point.data('id');
		removePoint(id);
		$el.find("[data-id='" + id + "']").remove();
	});

	// save point
	$('body').on('click', '.save_prd', function() {

		var p = {},
				$point = $(this).parent(),
				$el = $point.parent();

		p['id'] = $point.data('id');
		p['pos'] = $point.data('position');
		p['pid'] = $point.find('select').find(":selected").val();

		addPoint(p);

		$point.toggleClass('hidden');
		$el.find("div[data-id='" + p.id + "']").toggleClass('hidden');

	});

	// show point settings
	$('body').on('click', '.poi', function() {

		$(this).toggleClass('hidden');
		var id = $(this).data('id');
		var details = getPoint(id);
		$(this).parent().find("span[data-id='" + id + "']").toggleClass('hidden');

	});

});

function showPoints(data) {

	data.parent.append('<span style="left:'+data.posX+'%; top:'+data.posY+'%;" data-position="'+data.posX+','+data.posY+'" data-id="'+data.id+'" class="'+data.point_sett+' point-'+data.id+'"><strong>Select Product:</strong><div class="select-cont"></div><div class="save_prd btn">Save</div><div class="remove_prd btn">Remove</div><div class="close_point"><svg class="svgic-add"><use xlink:href="#si-add"></use></svg></div></span><div style="left:'+data.posX+'%;top:'+data.posY+'%;" data-id="'+data.id+'" class="poi '+data.point+'"><svg class="svgic-add"><use xlink:href="#si-add"></use></svg></div>');

	$('.hidden.toClone').clone().removeClass('hidden').appendTo('.point-'+data.id+' .select-cont');
	$('.point-'+data.id+' .select-cont .toClone option[value="'+data.pid+'"]').attr('selected', 'selected');

}

function removePoint(id) {
	var points = getAllPoints();
	var newPoints = {};

	$.each(points, function( index, value ) {
		if (index != id) newPoints[index] = value;
	});

	if (jQuery.isEmptyObject(newPoints)) {
		$('#products').val('');
	} else {
		$('#products').val(JSON.stringify(newPoints));
	}
}

function addPoint(point) {
	var points = getAllPoints(),
			newPoint = new Array(),
			new_id = point.id;

	points[point.id] = {'pos':point.pos, 'pid':point.pid};
	$('#products').val(JSON.stringify(points));
}

function getAllPoints() {
	var allPoints = $('#products').val();
	if (allPoints.length > 0) {
		allPoints = JSON.parse(allPoints);
	} else {
		allPoints = {};
	}
	return allPoints;
}

function getPoint(id) {
	var points = getAllPoints();
	return points[id];
}
