$(document).ready(function(){

	if ( $('.lookbook-slides')[0] ) {

		var SiemaSlider = new Siema({
		  selector: '.lookbook-slides',
		  duration: 400,
		  easing: 'cubic-bezier(0.23, 1, 0.32, 1)',
		  perPage: 1,
		  startIndex: 0,
		  draggable: true,
		  threshold: 20,
		  loop: true,
		  //onInit: runinit, // autoscroll
    });

		$('.pk-lb-prev').click(function(){
			SiemaSlider.prev()
		});
		$('.pk-lb-next').click(function(){
			SiemaSlider.next()
		});

		function runinit() {
			setInterval(() => SiemaSlider.next(), 3000);
		}

	}

  var lookbooks = [
      '.lookbook-products-list',
  ];

  var block = '.lookbook-products-list';

	$('.lookbook-item .product-miniature').hover(
	  function() {
	    var pid = $(this).data('id-product');
			var $currentLook = $(this).closest('.lookbook-item');
			$currentLook.find(".pk-poi").removeClass('pk-active');
			$currentLook.find(".product-id"+pid).addClass('pk-active');
	  }, function() {
			$(this).closest('.lookbook-item').find(".pk-poi").removeClass('pk-active');
	  }
	);

	$('.pk-poi').hover(
	  function() {
	    var pid = $(this).data('pid');
			var $currentLook = $(this).closest('.lookbook-item');
			$currentLook.find(".product-miniature").removeClass('pk-active');
			$currentLook.find("[data-id-product='" + pid + "']").addClass('pk-active');
	  }, function() {
			$(this).closest('.lookbook-item').find(".product-miniature").removeClass('pk-active');
	  }
	);

	//if slider view enabled
	if ($('.lookbook-container').hasClass('pk-slider-view')) {
	  $('.lookbook-slides .lookbook-products-list').each(function( k, innerSlider ) {
	    if ( $(innerSlider)[0] ) {

	      var prev = $(innerSlider).parent().find('.pk-lbp-prev');
	      var next = $(innerSlider).parent().find('.pk-lbp-next');

				next.show();
				prev.show();

	      var SiemaSliderPrdcts = new Siema({
	        selector: innerSlider,
	        duration: 400,
	        easing: 'cubic-bezier(0.23, 1, 0.32, 1)',
	        perPage: 1,
	        startIndex: 0,
	        draggable: true,
	        threshold: 20,
	        loop: true,
	        onInit: updatePois,
	        onChange: updatePois,
	      });

	      $(prev).click(function(){
	        SiemaSliderPrdcts.prev()
	      });
	      $(next).click(function(){
	        SiemaSliderPrdcts.next()
	      });

	      function updatePois() {
	        var current_slide = this.innerElements[this.currentSlide],
	  			    current_id = current_slide.getAttribute("data-id-product");

	        $(current_slide).closest('.lookbook-item').find('.pk-poi').removeClass('pk-active');
	        $(current_slide).closest('.lookbook-item').find('.pois .product-id'+current_id).addClass('pk-active');
	      }
	    }
	  });
	}//if slider view enabled

});
