{*
 * 2017 PROMOKIT.EU
 *
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement
 *
 *  @author    PROMOKIT.EU <support@promokit.eu>
 *  @copyright 2017 PROMOKIT.EU
 *  @license   Commercial license (You can not resell or redistribute this software.)
 *
*}
{extends file='page.tpl'}
{block name="page_content"}
<h2 class="text-center h2 lookbook-title">{l s='Key Looks for Spring' mod='pk_lookbook'}.</h2>
<div class="lookbook-page {$config.PK_LB_ALT_VIEW}">
{foreach from=$lookbook_list item=lookbook}
  {if (isset($pkts.gs_lazy_load) && $pkts.gs_lazy_load == true)}
  {assign var="src" value="https://via.placeholder.com/300x400"}
  {assign var="dataSrc" value="{$lookbook.image_url}"}
  {assign var="bclass" value=" b-lazy"}
  {else}
  {assign var="dataSrc" value=""}
  {assign var="src" value="{$lookbook.image_url}"}
  {assign var="bclass" value=""}
  {/if}
  <article class="lookbook-item">
    <div class="lookbook-item-space relative flex-container">
      <section class="lookbook-image relative">
      {if $lookbook.title}
        <h2>{$lookbook.title}</h2>
      {/if}
      <div class="relative product-thumbnail">
        <img src="{$src}" data-src="{$dataSrc}" alt="{$lookbook.legend|escape}" class="smooth05 cover-image{$bclass}" />
        <div class="pois">
        {foreach from=$lookbook.points item=point}
          {assign var="pos" value=","|explode:$point->pos}
          <div class="pk-poi smooth02 product-id{$point->pid}" data-pid="{$point->pid}" style="left:{$pos.0}%;top:{$pos.1}%"></div>
        {/foreach}
        </div>
        {if $lookbook.description}
          <span class="caption">
            <div>{$lookbook.description nofilter}</div>
          </span>
        {/if}
      </div>
      </section>
      <section class="lookbook-products-list flex-container relative">
      {foreach from=$lookbook.products_list item=product key=p}
        {include file="catalog/_partials/miniatures/product.tpl" product=$product image_size='large_default'}
      {/foreach}
      </section>
    </div>
  </article>
{/foreach}
</div>
{/block}
