{*
* Promokit Lookbook Module
*
* @package   alysum
* @version   1.0
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2018 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
*}
{if $pk_lookbook.slides}
<div class="pk-lookbook view_grid">
<div class="page-width">
  <h4 class="module-title"><span>{l s='Shop the look' mod='pk_lookbook'}</span></h4>
  <div class="lookbook-container relative {if ($pk_lookbook.view == 'PK_LB_ALT_VIEW')}pk-alt-view{else}{$pk_lookbook.view}{/if}">
    <button class="pk-lb-prev smooth500"><svg class='svgic svgic-left-arrow'><use xlink:href='#si-left-arrow-thin'></use></svg></button>
    <button class="pk-lb-next smooth500"><svg class='svgic svgic-right-arrow'><use xlink:href='#si-right-arrow-thin'></use></svg></button>
    <div class="lookbook-slides">
      {foreach from=$pk_lookbook.slides item=slide}
        <article class="lookbook-item relative">
          <section class="lookbook-image relative">
            {if (isset($pkts.gs_lazy_load) && $pkts.gs_lazy_load == true)}
              {assign var="src" value="data:image/gif;base64,R0lGODdhAQABAPAAAMPDwwAAACwAAAAAAQABAAACAkQBADs="}
              {assign var="dataSrc" value="{$slide.image_url}"}
              {assign var="bclass" value=" b-lazy"}
            {else}
              {assign var="dataSrc" value=""}
              {assign var="src" value="{$slide.image_url}"}
              {assign var="bclass" value=""}
            {/if}
            <!--<a href="{$slide.url}">-->
              <div class="relative">
                <img src="{$src}" data-src="{$dataSrc}" alt="{$slide.legend|escape}" class="{$bclass}" />
                <div class="pois">
                {foreach from=$slide.points item=point}
                  {assign var="pos" value=","|explode:$point->pos}
                  <div class="pk-poi smooth02 product-id{$point->pid}" data-pid="{$point->pid}" style="left:{$pos.0}%;top:{$pos.1}%"></div>
                {/foreach}
                </div>
              </div>
              {if $slide.title || $slide.description}
                <span class="caption">
                  <h2>{$slide.title}</h2>
                  <div>{$slide.description nofilter}</div>
                </span>
              {/if}
            <!--</a>-->
          </section>
          <section class="lookbook-products-list-wrap relative">
            <button class="pk-lbp-prev smooth500 hidden"><svg class='svgic svgic-left-arrow'><use xlink:href='#si-left-arrow-thin'></use></svg></button>
            <button class="pk-lbp-next smooth500 hidden"><svg class='svgic svgic-right-arrow'><use xlink:href='#si-right-arrow-thin'></use></svg></button>
            <div class="lookbook-products-list">
            {foreach from=$slide.products_list item=product key=p}
              {include file="catalog/_partials/miniatures/product.tpl" product=$product image_size='medium_default'}
  					{/foreach}
            </div>
          </section>
        </article>
      {/foreach}
    </div>
  </div>
</div>
</div>
{/if}
