{**
* 2007-2017 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2017 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*}
{if ($svg_icons != false)}
{include file="{$svg_icons_path}"}
{/if}
<form id="module_form" class="defaultForm form-horizontal" action="index.php?controller=AdminModules&amp;configure=pk_menu&amp;token={Tools::getAdminTokenLite('AdminModules')}" method="post" enctype="multipart/form-data" novalidate="">
<div class="panel"><h3><i class="icon-list-ul"></i> {l s='Menu Item' mod='pk_menu'}</h3>
	<div class="form-wrapper" id="menuContent" >
		<div class="form-group owl-type-link">
			<label class="control-label col-lg-3">{l s='Link Type' mod='pk_menu'}</label>
			<div class="col-lg-9">
				<div class="radio owl-radio">
					<label><input type="radio" name="type_link" id="type_link_custom" value="1" {if $menu->type_link == 1}checked="checked" {/if}>Custom Link</label>
				</div>
				<div class="radio owl-radio">
					<label><input type="radio" name="type_link" id="type_link_ps" value="0" {if $menu->type_link == 0}checked="checked" {/if}>PrestaShop Link</label>
				</div>
			</div>
		</div>

		<div class="form-group owl-menu-title" {if $menu->type_link == 0}style="display:none"{/if}>
			<label class="control-label col-lg-3">{l s='Title' mod='pk_menu'}</label>
			<div class="col-lg-9">
				{foreach from=$languages item=language}
					{if $languages|count > 1}
						<div class="translatable-field row lang-{$language.id_lang|intval}" {if $language.id_lang != $id_language}style="display:none"{/if}>
					{/if}
					<div class="col-lg-10">
					<input type="text" class="title" id="title_{$language.id_lang|intval}" name="title_{$language.id_lang|intval}" value="{if isset($menu->title[$language.id_lang|intval])}{$menu->title[$language.id_lang|intval]}{else}menu title{/if}"/>
					</div>
					{if $languages|count > 1}
						<div class="col-lg-2">
							<button type="button" class="btn btn-default dropdown-toggle" tabindex="-1" data-toggle="dropdown">
								{$language.iso_code}
								<span class="caret"></span>
							</button>
							<ul class="dropdown-menu">
								{foreach from=$languages item=lang}
								<li><a href="javascript:hideOtherLanguage({$lang.id_lang|intval});javascript:changeLangInfor({$lang.id_lang|intval});" tabindex="-1">{$lang.name}</a></li>
								{/foreach}
							</ul>
						</div>
					{/if}
					{if $languages|count > 1}
						</div>
					{/if}
				{/foreach}
			</div>
		</div>

		<div class="form-group owl-menu-link" {if $menu->type_link == 0}style="display:none"{/if}>
			<label class="control-label col-lg-3">{l s='Link' mod='pk_menu'}</label>
			<div class="col-lg-9">
				{foreach from=$languages item=language}
					{if $languages|count > 1}
						<div class="translatable-field row lang-{$language.id_lang|intval}" {if $language.id_lang != $id_language}style="display:none"{/if}>
					{/if}
					<div class="col-lg-10">
					<input type="text" id="link_{$language.id_lang|intval}" name="link_{$language.id_lang|intval}" value="{if isset($menu->link[$language.id_lang|intval])}{$menu->link[$language.id_lang|intval]}{else}#{/if}"/>
					</div>
					{if $languages|count > 1}
						<div class="col-lg-2">
							<button type="button" class="btn btn-default dropdown-toggle" tabindex="-1" data-toggle="dropdown">
								{$language.iso_code}
								<span class="caret"></span>
							</button>
							<ul class="dropdown-menu">
								{foreach from=$languages item=lang}
								<li><a href="javascript:hideOtherLanguage({$lang.id_lang|intval});javascript:changeLangInfor({$lang.id_lang|intval});" tabindex="-1">{$lang.name}</a></li>
								{/foreach}
							</ul>
						</div>
					{/if}
					{if $languages|count > 1}
						</div>
					{/if}
				{/foreach}
			</div>
		</div>

		<div class="form-group ps_link" {if $menu->type_link == 1}style="display:none"{/if}>
			<label class="control-label col-lg-3">{l s='PrestaShop Link' mod='pk_menu'}</label>
			<div class="col-lg-9">
				<select class="form-control fixed-width-lg" name="ps_link" id="ps_link">
					<optgroup label="{l s='Category' mod='pk_menu'}">
						{include file="./menu_item_cat.tpl" cat_option = $cat_option}
					</optgroup>
					<optgroup label="{l s='Cms' mod='pk_menu'}">
						{include file="./menu_item_cms.tpl" cms_option = $cms_option}
					</optgroup>
					{if !empty($layout_option)}
					<optgroup label="{l s='Layouts' mod='pk_menu'}">
					{foreach from=$layout_option item = layout}
						<option value="LAY{$layout.id}">&nbsp;&nbsp;&nbsp;{if $layout.title}{$layout.title}{/if}</option>
					{/foreach}
					</optgroup>
					{/if}
					{if !empty($blog_option)}
					<optgroup label="{l s='Blog' mod='pk_menu'}">
					{foreach from=$blog_option item = blog}
						<option value="BLG{$blog.id}">&nbsp;{if $blog.id != 0}&nbsp;&nbsp;{/if}{if $blog.title}{$blog.title}{/if}</option>
					{/foreach}
					</optgroup>
					{/if}
					<optgroup label="{l s='Pages' mod='pk_menu'}">
					{foreach from=$page_option item = pageo}
						<option value="PAG{$pageo.page}">&nbsp;&nbsp;&nbsp;{if $pageo.title}{$pageo.title}{else}{$pageo.page}{/if}</option>
					{/foreach}
					</optgroup>
					{if !empty($shop_option)}
					<optgroup label="{l s='Shops' mod='pk_menu'}">
					{foreach from=$shop_option item=shop}
						<option value="SHO{$shop.id}">&nbsp;&nbsp;&nbsp;{if $shop.title}{$shop.title}{/if}</option>
					{/foreach}
					</optgroup>
					{/if}
				</select>
			</div>
			<script type="text/javascript">
				{if $menu->type_link == 0}
				$(document).ready(function(){
					{if isset($menu->link[$id_language]) &&  $menu->link[$id_language] != ''}
						var ps_link_val = '{$menu->link[$id_language]}';
					{else}
						var ps_link_val = 'CAT3';
					{/if}
					$("#ps_link").val(ps_link_val);
				});
				$(document).on('change', '#ps_link', function() {
					$('.override_title').val($('#ps_link option:selected').text().trim());
				});
				{/if}
			</script>
		</div>


		<div class="form-group menu-title" {if $menu->type_link == 1}style="display:none"{/if}>
			<label class="control-label col-lg-3">{l s='Item Title' mod='pk_menu'}</label>
			<div class="col-lg-9">
				{foreach from=$languages item=language}
					{if $languages|count > 1}
						<div class="translatable-field row lang-{$language.id_lang|intval}" {if $language.id_lang != $id_language}style="display:none"{/if}>
					{/if}
					<div class="col-lg-10">
					<input type="text" class="title override_title" id="override_title_{$language.id_lang|intval}" name="override_title_{$language.id_lang|intval}" value="{if isset($menu->title[$language.id_lang|intval])}{$menu->title[$language.id_lang|intval]}{else}menu title{/if}"/>
					</div>
					{if $languages|count > 1}
						<div class="col-lg-2">
							<button type="button" class="btn btn-default dropdown-toggle" tabindex="-1" data-toggle="dropdown">
								{$language.iso_code}
								<span class="caret"></span>
							</button>
							<ul class="dropdown-menu">
								{foreach from=$languages item=lang}
								<li><a href="javascript:hideOtherLanguage({$lang.id_lang|intval});javascript:changeLangInfor({$lang.id_lang|intval});" tabindex="-1">{$lang.name}</a></li>
								{/foreach}
							</ul>
						</div>
					{/if}
					{if $languages|count > 1}
						</div>
					{/if}
				{/foreach}
			</div>
		</div>


		<div class="form-group show_sub" {if $menu->type_link == 1}style="display:none"{/if}>
			<label class="control-label col-lg-3">{l s='Auto Show SubCategories' mod='pk_menu'}</label>
			<div class="col-lg-9">
				<span class="switch prestashop-switch fixed-width-lg">
					<input type="radio" name="dropdown" id="dropdown_on" value="1" {if (isset($menu->dropdown) && $menu->dropdown == 1)}checked="checked"{/if}>
					<label for="dropdown_on">Yes</label>
					<input type="radio" name="dropdown" id="dropdown_off" value="0" {if (isset($menu->dropdown) && $menu->dropdown == 0) || !$menu->dropdown}checked="checked"{/if}>
					<label for="dropdown_off">No</label>
					<a class="slide-button btn"></a>
				</span>
			</div>
		</div>

		<div class="form-group">
			<label class="control-label col-lg-3">{l s='Sub Title' mod='pk_menu'}</label>
			<div class="col-lg-9">
				{foreach from=$languages item=language}
					{if $languages|count > 1}
						<div class="translatable-field row lang-{$language.id_lang|intval}" {if $language.id_lang != $id_language}style="display:none"{/if}>
					{/if}
					<div class="col-lg-10">
					<input type="text" class="subtitle" id="subtitle_{$language.id_lang|intval}" name="subtitle_{$language.id_lang|intval}" value="{if $menu->subtitle[$language.id_lang|intval]}{$menu->subtitle[$language.id_lang|intval]}{/if}"/>
					</div>
					{if $languages|count > 1}
						<div class="col-lg-2">
							<button type="button" class="btn btn-default dropdown-toggle" tabindex="-1" data-toggle="dropdown">
								{$language.iso_code}
								<span class="caret"></span>
							</button>
							<ul class="dropdown-menu">
								{foreach from=$languages item=lang}
								<li><a href="javascript:hideOtherLanguage({$lang.id_lang|intval});javascript:changeLangInfor({$lang.id_lang|intval});" tabindex="-1">{$lang.name}</a></li>
								{/foreach}
							</ul>
						</div>
					{/if}
					{if $languages|count > 1}
						</div>
					{/if}
				{/foreach}
			</div>
		</div>

		<div class="form-group owl-type-icon row">
			<label class="control-label col-lg-3">{l s='Icon Type' mod='pk_menu'}</label>
			<div class="col-lg-9">
				<div class="radio owl-radio">
					<label><input type="radio" name="type_icon" id="type_icon_fw" value="1" {if $menu->type_icon == 1}checked="checked"{/if}>SVG Icon</label>
				</div>
				<div class="radio owl-radio">
					<label><input type="radio" name="type_icon" id="type_icon_img" value="0" {if $menu->type_icon == 0}checked="checked"{/if}>Image Icon</label>
				</div>
			</div>
		</div>

		<div class="form-group owl-fw-icon" {if $menu->type_icon == 0}style="display:none"{/if}>
			<label class="control-label col-lg-3"></label>
			<div class="svg_icons_conteiner col-lg-9">
				{foreach from=$svg_icons item=icon}
					<div class="ic" data-icon="{$icon}"><svg class="svgic"><use xlink:href="#si-{$icon}"></use></svg></div>
				{/foreach}
			</div>
			<label class="control-label col-lg-3">{l s='SVG Icon' mod='pk_menu'}</label>
			<div class="col-lg-9">
				<input type="text" class="icon_font" id="icon_font" name="icon_font" value="{if $menu->icon && $menu->type_icon == 1}{$menu->icon}{/if}"/>
				<p>{l s='Click on icon to select' mod='pk_menu'}</p>
			</div>
		</div>
		<div class="form-group owl-img-icon" {if $menu->type_icon == 1}style="display:none"{/if}>
			<label class="control-label col-lg-3">{l s='Image Icon' mod='pk_menu'}</label>
			<div class="row">
				<div class="col-lg-6">
					<input id="icon_img" type="file" name="icon_img" class="hide">
					<div class="dummyfile input-group">
						<span class="input-group-addon"><i class="icon-file"></i></span>
						<input id="icon_img-name" type="text" name="filename" readonly="">
						<span class="input-group-btn">
							<button id="icon_img-selectbutton" type="button" name="submitAddAttachments" class="btn btn-default">
								<i class="icon-folder-open"></i> Add file				</button>
										</span>
					</div>
					{if $menu->type_icon == 0 && isset($menu->icon) && $menu->icon != ''}
						<img src="{$image_baseurl}{$menu->icon}" class="img-thumbnail"/>
						{if isset($menu->id)}
							<a href="index.php?controller=AdminModules&amp;configure=pk_menu&amp;tab_module=front_office_features&amp;module_name=pk_menu&amp;token={Tools::getAdminTokenLite('AdminModules')}&amp;removeIcon=1&amp;id_pkmenu={$menu->id|intval}" id="del_icon">Remove</a>
						{/if}
					{/if}
						<script type="text/javascript">
						$(document).ready(function(){
							$('.svg_icons_conteiner > div').click(function(e) {
								$('#icon_font').val($(this).data('icon'));
							});
							$('#icon_img-selectbutton').click(function(e) {
								$('#icon_img').trigger('click');
							});

							$('#icon_img-name').click(function(e) {
								$('#icon_img').trigger('click');
							});

							$('#icon_img-name').on('dragenter', function(e) {
								e.stopPropagation();
								e.preventDefault();
							});

							$('#icon_img-name').on('dragover', function(e) {
								e.stopPropagation();
								e.preventDefault();
							});

							$('#icon_img-name').on('drop', function(e) {
								e.preventDefault();
								var files = e.originalEvent.dataTransfer.files;
								$('#icon_img')[0].files = files;
								$(this).val(files[0].name);
							});

							$('#icon_img').change(function(e) {
								if ($(this)[0].files !== undefined)
								{
									var files = $(this)[0].files;
									var name  = '';

									$.each(files, function(index, value) {
										name += value.name+', ';
									});

									$('#icon_img-name').val(name.slice(0, -2));
								}
								else // Internet Explorer 9 Compatibility
								{
									var name = $(this).val().split(/[\\/]/);
									$('#icon_img-name').val(name[name.length-1]);
								}
							});

							if (typeof icon_img_max_files !== 'undefined')
							{
								$('#icon_img').closest('form').on('submit', function(e) {
									if ($('#icon_img')[0].files.length > icon_img_max_files) {
										e.preventDefault();
										alert('You can upload a maximum of files');
									}
								});
							}
						});
					</script>
			</div>
		</div>
	</div>
	<div class="form-group">
		<label class="control-label col-lg-3">{l s='Submenu Alignment' mod='pk_menu'}</label>
		<div class="col-lg-9">
			<select class="form-control fixed-width-lg" name="align_sub" id="align_sub">
				<option value="owl-sub-left" {if $menu->align_sub == 'owl-sub-left'}selected{/if}>{l s='Left' mod='pk_menu'}</option>
				<option value="owl-sub-right" {if $menu->align_sub == 'owl-sub-right'}selected{/if}>{l s='Right' mod='pk_menu'}</option>
				<option value="owl-sub-auto" {if $menu->align_sub == 'owl-sub-auto'}selected{/if}>{l s='Auto' mod='pk_menu'}</option>
			</select>
		</div>
	</div>
	<div class="form-group">
		<label class="control-label col-lg-3">{l s='SubMenu Width' mod='pk_menu'}</label>
		<div class="col-lg-9">
			<select class="form-control fixed-width-lg" name="width_sub" id="width_sub">
				<option value="col-lg-2" {if $menu->width_sub == 'col-lg-2'}selected{/if}>16.66%</option>
				<option value="col-lg-25" {if $menu->width_sub == 'col-lg-25'}selected{/if}>20%</option>
				<option value="col-lg-3" {if $menu->width_sub == 'col-lg-3'}selected{/if}>25%</option>
				<option value="col-lg-4" {if $menu->width_sub == 'col-lg-4'}selected{/if}>33.33%</option>
				<option value="col-lg-5" {if $menu->width_sub == 'col-lg-5'}selected{/if}>41.66%</option>
				<option value="col-lg-6" {if $menu->width_sub == 'col-lg-6'}selected{/if}>50%</option>
				<option value="col-lg-7" {if $menu->width_sub == 'col-lg-7'}selected{/if}>58.33%</option>
				<option value="col-lg-8" {if $menu->width_sub == 'col-lg-8'}selected{/if}>66.66%</option>
				<option value="col-lg-9" {if $menu->width_sub == 'col-lg-9'}selected{/if}>75%</option>
				<option value="col-lg-10" {if $menu->width_sub == 'col-lg-10'}selected{/if}>83.33%</option>
				<option value="col-lg-11" {if $menu->width_sub == 'col-lg-11'}selected{/if}>91.66%</option>
				<option value="col-lg-12" {if $menu->width_sub == 'col-lg-12'}selected{/if}>100%</option>
			</select>
		</div>
	</div>
	<div class="form-group">
		<label class="control-label col-lg-3">{l s='Class' mod='pk_menu'}</label>
		<div class="col-lg-9">
			<input type="text" class="class" id="class" name="class" value="{if $menu->class}{$menu->class}{/if}"/>
		</div>
	</div>
	<div class="form-group">
		<label class="control-label col-lg-3">{l s='Active' mod='pk_menu'}</label>
		<div class="col-lg-9">
			<span class="switch prestashop-switch fixed-width-lg">
				<input type="radio" name="active" id="active_on" value="1" {if (isset($menu->active) &&  $menu->active != 0) || !$menu->active}checked="checked"{/if}>
				<label for="active_on">Yes</label>
				<input type="radio" name="active" id="active_off" value="0" {if isset($menu->active) && $menu->active == 0}checked="checked"{/if}>
				<label for="active_off">No</label>
				<a class="slide-button btn"></a>
			</span>
		</div>
	</div>

	<div class="panel-footer">
		<input type="hidden" name="id_pkmenu" id="id_pkmenu" value="{if isset($menu->id)}{$menu->id|intval}{/if}"/>
		<button type="submit" value="1" id="module_form_submit_btn" name="submitMenuItem" class="btn btn-default pull-right">
			<i class="process-icon-save"></i> Save
		</button>
		<a href="index.php?controller=AdminModules&amp;configure=pk_menu&amp;token={$token}" class="btn btn-default">
		<i class="process-icon-back"></i> Back to list</a>
	</div>
</div>
</div>
</form>